/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.gui.db.ColumnListDialog;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.DropColumnCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.PrimaryKeyCommandUtility;

public class AddPrimaryKeyCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(DropColumnCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddPrimaryKeyCommand.class);
    protected ColumnListDialog customDialog;

    public AddPrimaryKeyCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        ITableInfo ti = (ITableInfo)this._info[0];
        PrimaryKeyCommandUtility pkcUtil = new PrimaryKeyCommandUtility(this._session, this._info);
        if (pkcUtil.tableHasPrimaryKey()) {
            this._session.showErrorMessage(s_stringMgr.getString("AddPrimaryKeyCommand.primaryKeyExists", new Object[]{ti.getSimpleName()}));
        } else {
            this.showCustomDialog();
        }
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        return this._dialect.getAddPrimaryKeySQL(this.customDialog.getPrimaryKeyName(), this.customDialog.getSelectedColumnList(), (ITableInfo)this._info[0], this._qualifier, this._sqlPrefs);
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AddPrimaryKeyCommand.this.customDialog.setVisible(false);
                        AddPrimaryKeyCommand.this.customDialog.dispose();
                        AddPrimaryKeyCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return true;
    }

    public void showCustomDialog() throws SQLException {
        ITableInfo ti = (ITableInfo)this._info[0];
        TableColumnInfo[] columns = this._session.getMetaData().getColumnInfo(ti);
        if (columns == null || columns.length == 0) {
            this._session.showErrorMessage(s_stringMgr.getString("AddPrimaryKeyCommand.noColumns", new Object[]{ti.getSimpleName()}));
            return;
        }
        this.customDialog = new ColumnListDialog(columns, 2);
        this.customDialog.setTableName(ti.getQualifiedName());
        this.customDialog.setPrimaryKeyName("PK_" + columns[0].getTableName().toUpperCase());
        this.customDialog.addColumnSelectionListener((ActionListener)new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener((ActionListener)new AbstractRefactoringCommand.EditSQLListener((IDisposableDialog)this.customDialog));
        this.customDialog.addShowSQLListener((ActionListener)new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, (IDisposableDialog)this.customDialog));
        this.customDialog.setLocationRelativeTo((Component)SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setMultiSelection();
        this.customDialog.setVisible(true);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = AddPrimaryKeyCommand.access$000().getString("AddPrimaryKeyCommand.sqlDialogTitle");
    }
}

