/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.tab;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseDataSetTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ActiveConnections
extends BaseDataSetTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ActiveConnections.class);
    private static final String QUERY = "SELECT datname,procpid,query_start,current_query,client_addr::TEXT,client_hostname::TEXT,datid,client_port,backend_start,xact_start,usesysid,usename,application_name,waiting FROM pg_stat_activity ORDER BY query_start DESC NULLS LAST ";
    private static final String QUERY_92 = "SELECT datid,datname,pid,query_start,state,query,client_addr::TEXT,client_hostname::TEXT,client_port,backend_start,xact_start,usesysid,usename,application_name FROM pg_stat_activity ORDER BY query_start DESC NULLS LAST";

    protected IDataSet createDataSet() throws DataSetException {
        ISession session = this.getSession();
        try {
            ISQLConnection con = session.getSQLConnection();
            Statement stmt = con.createStatement();
            ResultSet rs = this.isPostgres92(con) ? stmt.executeQuery(QUERY_92) : stmt.executeQuery(QUERY);
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, DialectType.POSTGRES);
            return rsds;
        }
        catch (SQLException ex) {
            throw new DataSetException((Throwable)ex);
        }
    }

    private boolean isPostgres92(ISQLConnection con) throws SQLException {
        int databaseMajorVersion = con.getSQLMetaData().getDatabaseMajorVersion();
        int databaseMinorVersion = 0;
        String databaseProductVersion = con.getSQLMetaData().getDatabaseProductVersion();
        if (databaseProductVersion.contains(".")) {
            databaseMinorVersion = Integer.parseInt(databaseProductVersion.split("\\.")[1]);
        }
        return databaseMajorVersion == 9 && databaseMinorVersion >= 2 || databaseMajorVersion >= 10;
    }

    public String getHint() {
        return i18n.HINT;
    }

    public String getTitle() {
        return i18n.TITLE;
    }

    protected String getDestinationClassName() {
        return this.getSession().getProperties().getMetaDataOutputClassName();
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String HINT = ActiveConnections.access$000().getString("ActiveConnectionsTab.hint");
        public static final String TITLE = ActiveConnections.access$000().getString("ActiveConnectionsTab.title");
    }
}

