/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Contour;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JideSplitPane
extends JPanel
implements ContainerListener,
ComponentListener,
Accessible {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String PROPERTY_DIVIDER_LOCATION = "dividerLocation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPORTIONAL_LAYOUT_PROPERTY = "proportionalLayout";
    public static final String PROPORTIONS_PROPERTY = "proportions";
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    private int _orientation;
    private int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    private HeavyweightWrapper _nonContinuousLayoutDividerWrapper;
    private boolean _continuousLayout = false;
    private Container _layeredPane;
    private boolean _showGripper = false;
    private boolean _proportionalLayout = false;
    private double[] _proportions;
    private boolean _initiallyEven = true;
    private boolean _heavyweightComponentEnabled = false;
    public WindowAdapter _windowDeactivatedListener;
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    private boolean _oneTouchExpandable = false;
    private int oneTouchExpandableDividerSize = 8;
    private ImageIcon _leftOneTouchButtonImageIcon = null;
    private ImageIcon _rightOneTouchButtonImageIcon = null;

    public JideSplitPane() {
        this(1);
    }

    public JideSplitPane(int newOrientation) {
        this._orientation = newOrientation;
        if (this._orientation != 1 && this._orientation != 0) {
            throw new IllegalArgumentException("cannot create JideSplitPane, orientation must be one of JideSplitPane.HORIZONTAL_SPLIT or JideSplitPane.VERTICAL_SPLIT");
        }
        JideSplitPaneLayout layoutManager = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(layoutManager);
        this.setOpaque(false);
        this.installListeners();
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get("JideSplitPane.dividerSize") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
    }

    private void installListeners() {
        this.addContainerListener(this);
    }

    public void setDividerSize(int newSize) {
        int oldSize = this._dividerSize;
        if (oldSize != newSize) {
            this._dividerSize = newSize;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, oldSize, newSize);
            this.invalidate();
        }
    }

    public int getDividerSize() {
        return this._dividerSize;
    }

    public Component insertPane(Component pane, int index) {
        return this.insertPane(pane, null, index);
    }

    public Component insertPane(Component pane, Object constraint, int index) {
        if (index <= 0) {
            this.addImpl(pane, constraint, 0);
        } else if (index >= this.getPaneCount()) {
            this.addImpl(pane, constraint, -1);
        } else {
            this.addImpl(pane, constraint, (index << 1) - 1);
        }
        return pane;
    }

    public Component addPane(Component pane) {
        if (pane == null) {
            return null;
        }
        return super.add(pane);
    }

    public void removePane(Component pane) {
        this.removePane(this.indexOfPane(pane));
    }

    public void setPaneAt(Component pane, int index) {
        this.setPaneAt(pane, null, index);
    }

    public void setPaneAt(Component pane, Object constraint, int index) {
        double[] proportions = this._proportions;
        this._proportions = null;
        this.removePane(index);
        this.insertPane(pane, constraint, index);
        this._proportions = proportions;
    }

    public void removePane(int index) {
        if (index == 0) {
            super.remove(0);
        } else {
            super.remove(index << 1);
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("JideSplitPane: orientation must be one of JideSplitPane.VERTICAL_SPLIT or JideSplitPane.HORIZONTAL_SPLIT");
        }
        if (this._orientation == orientation) {
            return;
        }
        int oldOrientation = this._orientation;
        this._orientation = orientation;
        JideSplitPaneLayout layoutManager = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(layoutManager);
        this.doLayout();
        this.firePropertyChange(ORIENTATION_PROPERTY, oldOrientation, orientation);
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void resetToPreferredSizes() {
        this.doLayout();
    }

    public void setProportionalLayout(boolean proportionalLayout) {
        if (proportionalLayout == this._proportionalLayout) {
            return;
        }
        this._proportionalLayout = proportionalLayout;
        this.revalidate();
        this.firePropertyChange(PROPORTIONAL_LAYOUT_PROPERTY, !proportionalLayout, proportionalLayout);
        if (!proportionalLayout) {
            this.setProportions(null);
        }
    }

    public boolean isProportionalLayout() {
        return this._proportionalLayout;
    }

    public void setProportions(double[] proportions) {
        if (!this._proportionalLayout && proportions != null) {
            throw new IllegalStateException("Can't set proportions on a non-proportional split pane");
        }
        if (Arrays.equals(proportions, this._proportions)) {
            return;
        }
        if (proportions != null && proportions.length != this.getPaneCount() - 1) {
            throw new IllegalArgumentException("Must provide one fewer proportions than there are panes: got " + proportions.length + ", expected " + (this.getPaneCount() - 1));
        }
        if (proportions != null) {
            double sum = 0.0;
            for (int i = 0; i < proportions.length; ++i) {
                if (proportions[i] < 0.0) {
                    proportions[i] = 0.0;
                }
                if (proportions[i] > 1.0) {
                    proportions[i] = 1.0;
                }
                sum += proportions[i];
            }
            if (sum > 1.0) {
                throw new IllegalArgumentException("Sum of proportions must be no more than 1, got " + sum);
            }
        }
        double[] oldProportions = this._proportions;
        this._proportions = proportions == null ? null : (double[])proportions.clone();
        LayoutManager layoutManager = this.getLayout();
        boolean reset = false;
        if (layoutManager instanceof JideBoxLayout) {
            reset = ((JideBoxLayout)layoutManager).isResetWhenInvalidate();
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
        }
        this.revalidate();
        if (reset) {
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(reset);
        }
        this.firePropertyChange(PROPORTIONS_PROPERTY, oldProportions, proportions);
    }

    public double[] getProportions() {
        double[] answer = this._proportions;
        if (answer != null) {
            answer = (double[])answer.clone();
        }
        return answer;
    }

    public void setInitiallyEven(boolean initiallyEven) {
        this._initiallyEven = initiallyEven;
    }

    public boolean isInitiallyEven() {
        return this._initiallyEven;
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    protected void startDragging(JideSplitPaneDivider divider) {
        if (!this.isContinuousLayout()) {
            Container topLevelAncestor = this.getTopLevelAncestor();
            if (this._windowDeactivatedListener == null) {
                this._windowDeactivatedListener = new WindowAdapter(){

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                        JideSplitPane.this.stopDragging();
                        if (e.getWindow() != null) {
                            e.getWindow().removeWindowListener(JideSplitPane.this._windowDeactivatedListener);
                        }
                    }
                };
            }
            if (topLevelAncestor instanceof Window) {
                ((Window)topLevelAncestor).addWindowListener(this._windowDeactivatedListener);
            }
            if (topLevelAncestor instanceof RootPaneContainer) {
                this._layeredPane = ((RootPaneContainer)((Object)topLevelAncestor)).getLayeredPane();
                if (this._nonContinuousLayoutDividerWrapper == null) {
                    Contour nonContinuousLayoutDivider = new Contour();
                    this._nonContinuousLayoutDividerWrapper = new HeavyweightWrapper(nonContinuousLayoutDivider);
                    this._nonContinuousLayoutDividerWrapper.setHeavyweight(this.isHeavyweightComponentEnabled());
                }
                this._nonContinuousLayoutDividerWrapper.delegateSetCursor(this._orientation == 1 ? JideSplitPaneDivider.HORIZONTAL_CURSOR : JideSplitPaneDivider.VERTICAL_CURSOR);
                this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
                this._nonContinuousLayoutDividerWrapper.delegateAdd(this._layeredPane, JLayeredPane.DRAG_LAYER);
                Rectangle bounds = this.getVisibleRect();
                Rectangle layeredPaneBounds = SwingUtilities.convertRectangle(this, bounds, this._layeredPane);
                int dividerThickness = Math.min(4, this.getDividerSize());
                if (this.getOrientation() == 1) {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(layeredPaneBounds.x, layeredPaneBounds.y, dividerThickness, layeredPaneBounds.height);
                } else {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(layeredPaneBounds.x, layeredPaneBounds.y, layeredPaneBounds.width, dividerThickness);
                }
            }
        }
    }

    private void stopDragging() {
        if (!this.isContinuousLayout() && this._layeredPane != null && this._nonContinuousLayoutDividerWrapper != null) {
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
            this._nonContinuousLayoutDividerWrapper.delegateRemove(this._layeredPane);
            this._nonContinuousLayoutDividerWrapper.delegateSetNull();
            this._nonContinuousLayoutDividerWrapper = null;
        }
    }

    protected void dragDividerTo(JideSplitPaneDivider divider, int location) {
        if (this._layeredPane == null || this.isContinuousLayout()) {
            this.setDividerLocation(divider, location);
        } else if (this._nonContinuousLayoutDividerWrapper != null) {
            Point p = this.getOrientation() == 1 ? SwingUtilities.convertPoint(this, location, 0, this._layeredPane) : SwingUtilities.convertPoint(this, 0, location, this._layeredPane);
            int dividerThickness = Math.min(4, this.getDividerSize());
            if (this.getOrientation() == 1) {
                p.x += this.getDividerSize() - dividerThickness >> 1;
            } else {
                p.y += this.getDividerSize() - dividerThickness >> 1;
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetLocation(p);
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(true);
        }
    }

    protected void finishDraggingTo(JideSplitPaneDivider divider, int location) {
        if (this.isContinuousLayout() || this._nonContinuousLayoutDividerWrapper != null) {
            this.stopDragging();
            this.setDividerLocation(divider, location);
        }
    }

    public int indexOfDivider(JideSplitPaneDivider divider) {
        int index = this.indexOf(divider);
        if (index == -1) {
            return index;
        }
        if (index % 2 == 0) {
            System.err.println("Warning: divider's index is even. (index = " + index + ")");
        }
        return (index - 1) / 2;
    }

    public int indexOfPane(Component pane) {
        int index = this.indexOf(pane);
        if (index == -1) {
            return -1;
        }
        if (index % 2 != 0) {
            System.err.println("Warning: pane's index is odd. (index = " + index + ")");
        }
        return index >> 1;
    }

    public int indexOf(Component comp) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).equals(comp)) continue;
            return i;
        }
        return -1;
    }

    public JideSplitPaneDivider getDividerAt(int index) {
        if (index < 0 || index * 2 + 1 >= this.getComponentCount()) {
            return null;
        }
        return (JideSplitPaneDivider)this.getComponent(index * 2 + 1);
    }

    public Component getPaneAt(int index) {
        if (index < 0 || index << 1 >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(index << 1);
    }

    public int getPaneCount() {
        return this.getComponentCount() + 1 >> 1;
    }

    public void setDividerLocation(JideSplitPaneDivider divider, int location) {
        this.setDividerLocation(this.indexOfDivider(divider), location);
    }

    public void setDividerLocation(int dividerIndex, int location) {
        int old = ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(dividerIndex);
        ((JideSplitPaneLayout)this.getLayout()).setDividerLocation(dividerIndex, location);
        this.firePropertyChange(PROPERTY_DIVIDER_LOCATION, old, location);
        this.revalidate();
    }

    public int getDividerLocation(int dividerIndex) {
        return ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(dividerIndex);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        e.getChild().addComponentListener(this);
        if (!(e.getChild() instanceof JideSplitPaneDivider)) {
            this.addExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        e.getChild().removeComponentListener(this);
        if (!(e.getChild() instanceof JideSplitPaneDivider)) {
            this.removeExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (e.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        if (e.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    protected boolean removeExtraDividers() {
        int extra = 0;
        if (this.getComponentCount() == 0) {
            if (this._proportions != null) {
                this.setProportions(null);
            }
            return false;
        }
        boolean changed = false;
        if (this.getComponent(0) instanceof JideSplitPaneDivider) {
            this.remove(0);
            this.removeProportion(0);
            changed = true;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            if (comp instanceof JideSplitPaneDivider) {
                if (++extra != 2) continue;
                this.remove(comp);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length) {
                    this.removeProportion(i / 2);
                }
                changed = true;
                --extra;
                --i;
                continue;
            }
            extra = 0;
        }
        if (extra == 1) {
            this.remove(this.getComponentCount() - 1);
            this.removeProportion((this.getComponentCount() + 1) / 2);
            changed = true;
        }
        return changed;
    }

    protected void removeProportion(int paneIndex) {
        double p;
        double[] oldProportions = this._proportions;
        if (oldProportions == null) {
            return;
        }
        if (oldProportions.length <= 1) {
            this.setProportions(null);
            return;
        }
        double[] newProportions = new double[oldProportions.length - 1];
        if (paneIndex < oldProportions.length) {
            p = oldProportions[paneIndex];
        } else {
            p = 1.0;
            for (double proportion : oldProportions) {
                p -= proportion;
            }
        }
        double total = 1.0 - p;
        for (int i = 0; i < newProportions.length; ++i) {
            int j = i < paneIndex ? i : i + 1;
            newProportions[i] = oldProportions[j] / total;
        }
        this.setProportions(newProportions);
    }

    protected void addExtraDividers() {
        int extra = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof JideSplitPaneDivider)) {
                if (++extra != 2) continue;
                this.add(this.createSplitPaneDivider(), "fix", i);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length + 2) {
                    this.addProportion((i + 1) / 2);
                }
                extra = 0;
                continue;
            }
            extra = 0;
        }
    }

    protected void addProportion(int paneIndex) {
        double[] oldProportions = this._proportions;
        if (oldProportions == null) {
            return;
        }
        double[] newProportions = new double[oldProportions.length + 1];
        double p = 1.0 / (double)(newProportions.length + 1);
        double total = 1.0 - p;
        for (int i = 0; i < newProportions.length; ++i) {
            if (i == paneIndex) {
                newProportions[i] = p;
                continue;
            }
            int j = i < paneIndex ? i : i - 1;
            newProportions[i] = j < oldProportions.length ? oldProportions[j] * total : p;
        }
        this.setProportions(newProportions);
    }

    protected void setDividersVisible() {
        if (this.getComponentCount() == 1) {
            this.setVisible(this.getComponent(0).isVisible());
        } else if (this.getComponentCount() > 1) {
            boolean anyVisible = false;
            boolean anyPrevVisible = false;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component comp = this.getComponent(i);
                if (!(comp instanceof JideSplitPaneDivider)) {
                    if (!comp.isVisible() || anyVisible) continue;
                    anyVisible = true;
                    continue;
                }
                boolean visiblePrev = this.getComponent(i - 1).isVisible();
                boolean visibleNext = this.getComponent(i + 1).isVisible();
                if (visiblePrev && visibleNext) {
                    comp.setVisible(true);
                    continue;
                }
                if (!visiblePrev && !visibleNext) {
                    comp.setVisible(false);
                    continue;
                }
                if (visiblePrev && !visibleNext) {
                    comp.setVisible(false);
                    anyPrevVisible = true;
                    continue;
                }
                if (anyPrevVisible) {
                    comp.setVisible(true);
                    anyPrevVisible = false;
                    continue;
                }
                comp.setVisible(false);
            }
            this.setVisible(anyVisible);
        }
    }

    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new JideSplitPaneDivider(this);
    }

    protected int getPreviousDividerLocation(JideSplitPaneDivider divider, boolean ignoreVisibility, boolean reversed) {
        int index = this.indexOfDivider(divider);
        int location = -1;
        if (reversed) {
            if ((index + 1) * 2 + 1 <= this.getComponentCount()) {
                int i = index + 1;
                while (i * 2 + 1 < this.getComponentCount()) {
                    if (ignoreVisibility || this.getDividerAt(i).isVisible()) {
                        location = this._orientation == 1 ? this.getDividerAt((int)i).getBounds().x : this.getDividerAt((int)i).getBounds().y;
                        break;
                    }
                    ++i;
                }
            }
        } else if (index > 0) {
            for (int i = index - 1; i >= 0; --i) {
                if (!ignoreVisibility && !this.getDividerAt(i).isVisible()) continue;
                location = this._orientation == 1 ? this.getDividerAt((int)i).getBounds().x : this.getDividerAt((int)i).getBounds().y;
                break;
            }
        }
        if (location != -1) {
            return location + this.getDividerSize();
        }
        return 0;
    }

    public int getNextDividerLocation(JideSplitPaneDivider divider, boolean ignoreVisibility, boolean reversed) {
        int index = this.indexOfDivider(divider);
        int location = -1;
        if (!reversed) {
            if ((index + 1) * 2 + 1 <= this.getComponentCount()) {
                int i = index + 1;
                while (i * 2 + 1 < this.getComponentCount()) {
                    if (ignoreVisibility || this.getDividerAt(i).isVisible()) {
                        location = this._orientation == 1 ? this.getDividerAt((int)i).getBounds().x : this.getDividerAt((int)i).getBounds().y;
                        break;
                    }
                    ++i;
                }
            }
        } else if (index > 0) {
            for (int i = index - 1; i >= 0; --i) {
                if (!ignoreVisibility && !this.getDividerAt(i).isVisible()) continue;
                location = this._orientation == 1 ? this.getDividerAt((int)i).getBounds().x : this.getDividerAt((int)i).getBounds().y;
                break;
            }
        }
        if (location != -1) {
            return location - this.getDividerSize();
        }
        return this.getOrientation() == 1 ? this.getWidth() - this.getDividerSize() : this.getHeight() - this.getDividerSize();
    }

    public boolean isShowGripper() {
        return this._showGripper;
    }

    public void setShowGripper(boolean showGripper) {
        boolean oldShowGripper = this._showGripper;
        if (oldShowGripper != showGripper) {
            this._showGripper = showGripper;
            this.firePropertyChange(GRIPPER_PROPERTY, oldShowGripper, this._showGripper);
        }
    }

    @Override
    public void doLayout() {
        if (this.removeExtraDividers()) {
            ((JideSplitPaneLayout)this.getLayout()).invalidateLayout(this);
        }
        super.doLayout();
    }

    public boolean isContinuousLayout() {
        return this._continuousLayout;
    }

    public void setContinuousLayout(boolean continuousLayout) {
        boolean oldCD = this._continuousLayout;
        this._continuousLayout = continuousLayout;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, oldCD, continuousLayout);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJideSplitPane();
        }
        return this.accessibleContext;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean heavyweightComponentEnabled) {
        boolean old = this._heavyweightComponentEnabled;
        if (this._heavyweightComponentEnabled != heavyweightComponentEnabled) {
            this._heavyweightComponentEnabled = heavyweightComponentEnabled;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, old, this._heavyweightComponentEnabled);
        }
    }

    public void setOneTouchExpandable(boolean oneTouchExpandable) {
        boolean oldValue = this._oneTouchExpandable;
        if (oldValue != oneTouchExpandable) {
            this._oneTouchExpandable = oneTouchExpandable;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
            }
            if (oneTouchExpandable) {
                this.setDividerSize(this.oneTouchExpandableDividerSize);
            } else {
                this.setDividerSize(UIDefaultsLookup.getInt("JideSplitPane.dividerSize"));
            }
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, oldValue, this._oneTouchExpandable);
            this.revalidate();
            this.repaint();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(false);
            }
        }
    }

    public boolean isOneTouchExpandable() {
        return this._oneTouchExpandable;
    }

    public void setLeftOneTouchButtonImageIcon(ImageIcon leftButtonImageIcon) {
        this._leftOneTouchButtonImageIcon = leftButtonImageIcon;
    }

    public ImageIcon getLeftOneTouchButtonImageIcon() {
        return this._leftOneTouchButtonImageIcon;
    }

    public void setRightOneTouchButtonImageIcon(ImageIcon rightButtonImageIcon) {
        this._rightOneTouchButtonImageIcon = rightButtonImageIcon;
    }

    public ImageIcon getRightOneTouchButtonImageIcon() {
        return this._rightOneTouchButtonImageIcon;
    }

    public void setDividerLocations(int[] locations) {
        for (int i = 0; i < locations.length; ++i) {
            int location = locations[i];
            this.setDividerLocation(i, location);
        }
    }

    public int[] getDividerLocations() {
        int count = this.getPaneCount();
        if (this.getPaneCount() == 0) {
            return new int[0];
        }
        int[] locations = new int[count - 1];
        for (int i = 0; i < count - 1; ++i) {
            locations[i] = this.getDividerLocation(i);
        }
        return locations;
    }

    static /* synthetic */ double[] access$002(JideSplitPane x0, double[] x1) {
        x0._proportions = x1;
        return x1;
    }

    protected class AccessibleJideSplitPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJideSplitPane() {
            super(JideSplitPane.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (JideSplitPane.this.getOrientation() == 0) {
                states.add(AccessibleState.VERTICAL);
            } else {
                states.add(AccessibleState.HORIZONTAL);
            }
            return states;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }

    private class JideSplitPaneLayout
    extends JideBoxLayout {
        public JideSplitPaneLayout(Container target) {
            super(target);
            this.setResetWhenInvalidate(false);
        }

        public JideSplitPaneLayout(Container target, int axis) {
            super(target, axis);
            this.setResetWhenInvalidate(false);
        }

        public JideSplitPaneLayout(Container target, int axis, int gap) {
            super(target, axis, gap);
            this.setResetWhenInvalidate(false);
        }

        int getDividerLocation(int index) {
            Insets insets;
            int i;
            if (this._componentSizes == null) {
                return -1;
            }
            if (index < 0 || index + 1 << 1 >= this._componentSizes.length) {
                return -1;
            }
            boolean ltr = JideSplitPane.this.getComponentOrientation().isLeftToRight();
            boolean reversed = !ltr && JideSplitPane.this.getOrientation() == 1;
            int location = 0;
            if (reversed) {
                for (i = this._componentSizes.length - 1; i >= index * 2 + 1; --i) {
                    location += this._componentSizes[i];
                }
            } else {
                for (i = 0; i < index * 2 + 1; ++i) {
                    location += this._componentSizes[i];
                }
            }
            if ((insets = JideSplitPane.this.getInsets()) != null) {
                location = JideSplitPane.this.getOrientation() == 1 ? (location += reversed ? insets.right : insets.left) : (location += insets.top);
            }
            return location;
        }

        void setDividerLocation(int index, int location) {
            int nextIndex;
            int i;
            int prevIndex;
            boolean reversed;
            int oldLocation = this.getDividerLocation(index);
            if (oldLocation == -1 || oldLocation == location) {
                return;
            }
            boolean ltr = JideSplitPane.this.getComponentOrientation().isLeftToRight();
            boolean bl = reversed = !ltr && JideSplitPane.this.getOrientation() == 1;
            if (reversed) {
                prevIndex = 2 * index + 2;
                for (i = nextIndex = 2 * index; !(i < 0 || this._target.getComponent(i).isVisible() && this.getConstraintMap().get(this._target.getComponent(i)) != "fix"); --i) {
                    --nextIndex;
                }
                for (i = prevIndex; !(i >= this._target.getComponentCount() || this._target.getComponent(i).isVisible() && this.getConstraintMap().get(this._target.getComponent(i)) != "fix"); ++i) {
                    ++prevIndex;
                }
                if (nextIndex < 0 || prevIndex >= this._componentSizes.length) {
                    return;
                }
            } else {
                prevIndex = 2 * index;
                nextIndex = 2 * index + 2;
                for (i = prevIndex; !(i < 0 || this._target.getComponent(i).isVisible() && this.getConstraintMap().get(this._target.getComponent(i)) != "fix"); --i) {
                    --prevIndex;
                }
                for (i = nextIndex; !(i >= this._target.getComponentCount() || this._target.getComponent(i).isVisible() && this.getConstraintMap().get(this._target.getComponent(i)) != "fix"); ++i) {
                    ++nextIndex;
                }
                if (prevIndex < 0 || nextIndex >= this._componentSizes.length) {
                    return;
                }
            }
            int n = prevIndex;
            this._componentSizes[n] = this._componentSizes[n] + (location - oldLocation);
            int n2 = nextIndex;
            this._componentSizes[n2] = this._componentSizes[n2] - (location - oldLocation);
            Component comp1 = this._target.getComponent(prevIndex);
            Component comp2 = this._target.getComponent(nextIndex);
            if (JideSplitPane.this.isProportionalLayout()) {
                this.replaceProportions();
                return;
            }
            ComponentOrientation o = this._target.getComponentOrientation();
            if (JideSplitPaneLayout.resolveAxis(this._axis, o) == 0) {
                if (comp1 instanceof JComponent) {
                    ((JComponent)comp1).setPreferredSize(new Dimension(this._componentSizes[prevIndex], comp1.getPreferredSize().height));
                }
                if (comp2 instanceof JComponent) {
                    ((JComponent)comp2).setPreferredSize(new Dimension(this._componentSizes[nextIndex], comp2.getPreferredSize().height));
                }
            } else {
                if (comp1 instanceof JComponent) {
                    ((JComponent)comp1).setPreferredSize(new Dimension(comp1.getPreferredSize().width, this._componentSizes[prevIndex]));
                }
                if (comp2 instanceof JComponent) {
                    ((JComponent)comp2).setPreferredSize(new Dimension(comp2.getPreferredSize().width, this._componentSizes[nextIndex]));
                }
            }
        }

        private void replaceProportions() {
            JideSplitPane.this.setProportions(this.deduceProportions());
        }

        private double[] deduceProportions() {
            double[] newProportions;
            double total = 0.0;
            for (int i = 0; i < this._componentSizes.length; i += 2) {
                total += (double)this._componentSizes[i];
            }
            if (total == 0.0) {
                newProportions = null;
            } else {
                newProportions = new double[(this._componentSizes.length - 1) / 2];
                for (int i = 0; i < newProportions.length; ++i) {
                    newProportions[i] = (double)this._componentSizes[i * 2] / total;
                }
            }
            return newProportions;
        }

        @Override
        protected boolean calculateComponentSizes(int availableSize, int startIndex, int endIndex) {
            if (!JideSplitPane.this.isProportionalLayout() || JideSplitPane.this.getComponentCount() <= 1) {
                return super.calculateComponentSizes(availableSize, startIndex, endIndex);
            }
            if (JideSplitPane.this._proportions == null) {
                if (!JideSplitPane.this.isInitiallyEven()) {
                    return super.calculateComponentSizes(availableSize, startIndex, endIndex);
                }
                int c = JideSplitPane.this.getPaneCount();
                double[] p = new double[c - 1];
                for (int i = 0; i < p.length; ++i) {
                    p[i] = 1.0 / (double)c;
                }
                JideSplitPane.access$002(JideSplitPane.this, p);
            }
            for (int i = 1; i < JideSplitPane.this.getComponentCount(); i += 2) {
                if (JideSplitPane.this.getComponent(i).isVisible()) {
                    this._componentSizes[i] = JideSplitPane.this.getDividerSize();
                }
                availableSize -= this._componentSizes[i];
            }
            if (availableSize < 0) {
                return false;
            }
            double[] proportions = JideSplitPane.this._proportions;
            double last = 1.0;
            for (double p : proportions) {
                last -= p;
            }
            double total = 0.0;
            for (int i = 0; i < JideSplitPane.this.getComponentCount(); i += 2) {
                int j = i / 2;
                if (!JideSplitPane.this.getComponent(i).isVisible()) continue;
                total += j < proportions.length ? proportions[j] : last;
            }
            int size = availableSize;
            for (int i = 0; i < proportions.length; ++i) {
                double d;
                int j = i * 2;
                if (JideSplitPane.this.getComponent(j).isVisible() && (d = proportions[i] / total) <= 1.0) {
                    this._componentSizes[j] = (int)(0.5 + (double)size * d);
                }
                availableSize -= this._componentSizes[j];
            }
            if (availableSize < 0) {
                return false;
            }
            this._componentSizes[this._componentSizes.length - 1] = availableSize;
            return true;
        }
    }
}

