/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import sun.reflect.Reflection;

public class UIDefaultsLookup {
    private static boolean _debug = false;
    private static boolean _trace = false;

    public static void setDebug(boolean debug) {
        _debug = debug;
    }

    public static void setTrace(boolean trace) {
        _trace = trace;
    }

    public static void put(UIDefaults table, String key, Object value) {
        Object cl;
        HashMap v = table.get(key);
        if (v == null || !(v instanceof Map)) {
            v = new HashMap();
            table.put(key, v);
        }
        if (!((cl = UIManager.get("ClassLoader")) instanceof ClassLoader)) {
            cl = value.getClass().getClassLoader();
        }
        ((Map)v).put(cl, value);
    }

    static ClassLoader getCallerClassLoader() {
        Object cl = UIManager.get("ClassLoader");
        if (cl instanceof ClassLoader) {
            return (ClassLoader)cl;
        }
        Class caller = Reflection.getCallerClass((int)3);
        if (caller == null) {
            return null;
        }
        return caller.getClassLoader();
    }

    public static Object get(Object key) {
        Object value = UIManager.get(key);
        UIDefaultsLookup.log(value, key, null);
        if (value instanceof Map && "Theme.painter".equals(key)) {
            Map map = (Map)value;
            try {
                ClassLoader classLoader = UIDefaultsLookup.getCallerClassLoader();
                Object o = map.get(classLoader);
                while (o == null && classLoader.getParent() != null) {
                    classLoader = classLoader.getParent();
                    o = map.get(classLoader);
                }
                if (o == null && map.size() >= 1) {
                    Collection classLoaders = map.values();
                    for (Object cl : classLoaders) {
                        if (cl == null) continue;
                        o = cl;
                        break;
                    }
                }
                return o;
            }
            catch (Exception e) {
                if (map.size() == 1) {
                    return map.values().iterator().next();
                }
                return map.get(LookAndFeelFactory.getUIManagerClassLoader());
            }
        }
        return value;
    }

    public static Object get(Object key, Locale l) {
        Object value = UIManager.get(key, l);
        UIDefaultsLookup.log(value, key, l);
        return value;
    }

    private static void log(Object value, Object key, Locale l) {
        if (_debug && value == null) {
            System.out.println("\"" + key + (l == null ? "" : l.toString()) + " \" ==> null ------------------------");
        } else if (_trace) {
            if (value == null) {
                System.out.println("\"" + key + (l == null ? "" : l.toString()) + " \" ==> null ------------------------");
            } else {
                System.out.println("\"" + key + (l == null ? "" : l.toString()) + " \" ==> " + value.getClass().getName() + "(" + ObjectConverterManager.toString(value) + ")");
            }
        }
    }

    public static Font getFont(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Font ? (Font)value : null;
    }

    public static Font getFont(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Font ? (Font)value : null;
    }

    public static Color getColor(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Color ? (Color)value : null;
    }

    public static Color getColor(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Color ? (Color)value : null;
    }

    public static Icon getIcon(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Icon ? (Icon)value : null;
    }

    public static Icon getIcon(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Icon ? (Icon)value : null;
    }

    public static Border getBorder(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Border ? (Border)value : null;
    }

    public static Border getBorder(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Border ? (Border)value : null;
    }

    public static String getString(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof String ? (String)value : null;
    }

    public static String getString(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof String ? (String)value : null;
    }

    public static int getInt(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public static int getInt(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public static boolean getBoolean(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static boolean getBoolean(Object key, boolean defaultValue) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static boolean getBoolean(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static Insets getInsets(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Insets ? (Insets)value : null;
    }

    public static Insets getInsets(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Insets ? (Insets)value : null;
    }

    public static Dimension getDimension(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Dimension ? (Dimension)value : null;
    }

    public static Dimension getDimension(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Dimension ? (Dimension)value : null;
    }
}

