/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.prefs;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.jmeld.util.prefs.Preference;

public class DirectoryChooserPreference
extends Preference {
    private static String DIRECTORY = "DIRECTORY";
    private JFileChooser target;

    public DirectoryChooserPreference(String preferenceName, JFileChooser target) {
        super("DirectoryChooser-" + preferenceName);
        this.target = target;
        this.init();
    }

    private void init() {
        String fileName = this.getString(DIRECTORY, null);
        if (fileName != null) {
            this.target.setCurrentDirectory(new File(fileName));
        }
    }

    public void save() {
        File file = this.target.getSelectedFile();
        if (file == null || !file.exists()) {
            return;
        }
        if ((file = new File(file.getParent())) == null || !file.exists()) {
            return;
        }
        try {
            String fileName = file.getCanonicalPath();
            this.putString(DIRECTORY, fileName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

