/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util;

import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharsetDetector {
    private static CharsetDetector instance = new CharsetDetector();
    private Map<String, Charset> charsetMap = Charset.availableCharsets();

    private CharsetDetector() {
    }

    public static CharsetDetector getInstance() {
        return instance;
    }

    public Charset getCharset(BufferedInputStream bis) {
        EditorSettings settings = JMeldSettings.getInstance().getEditor();
        Charset charset = null;
        if (settings.getDefaultFileEncodingEnabled()) {
            charset = this.getDefaultCharset();
        } else if (settings.getSpecificFileEncodingEnabled()) {
            charset = this.charsetMap.get(settings.getSpecificFileEncodingName());
        } else if (settings.getDetectFileEncodingEnabled()) {
            charset = this.detectCharset(bis);
        }
        if (charset == null) {
            charset = this.getDefaultCharset();
        }
        return charset;
    }

    private Charset detectCharset(BufferedInputStream bis) {
        try {
            Charset foundCharset;
            com.ibm.icu.text.CharsetDetector detector = new com.ibm.icu.text.CharsetDetector();
            detector.setText((InputStream)bis);
            CharsetMatch match = detector.detect();
            if (match != null && (foundCharset = this.charsetMap.get(match.getName())) != null) {
                return foundCharset;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    public List<String> getCharsetNameList() {
        ArrayList<String> charsetNameList = new ArrayList<String>();
        for (String name : this.charsetMap.keySet()) {
            charsetNameList.add(name);
        }
        return charsetNameList;
    }
}

