/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.fife.ui.rtextfilechooser.RootManager;

public class FileDisplayNames {
    private Map rootNameCache = new HashMap();
    private static final FileDisplayNames INSTANCE = new FileDisplayNames();

    private FileDisplayNames() {
        Iterator i = RootManager.getInstance().iterator();
        while (i.hasNext()) {
            File aRoot = (File)i.next();
            this.addCachedRootName(aRoot);
        }
    }

    private void addCachedRootName(File aRoot) {
        String absolutePath;
        if (File.separatorChar == '\\' && (absolutePath = aRoot.getAbsolutePath()).length() == 3 && absolutePath.endsWith(":\\")) {
            this.rootNameCache.put(aRoot, absolutePath);
            return;
        }
        this.rootNameCache.put(aRoot, this.getName(aRoot));
    }

    public static FileDisplayNames get() {
        return INSTANCE;
    }

    public String getName(File file) {
        if (file == null) {
            return null;
        }
        String name = (String)this.rootNameCache.get(file);
        if (name != null) {
            return name;
        }
        name = FileSystemView.getFileSystemView().getSystemDisplayName(file);
        if (name != null && name.length() > 0) {
            return name;
        }
        name = file.getAbsolutePath();
        if (name.length() == 0) {
            name = "/";
        }
        return name;
    }
}

