/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import com.apple.osxadapter.NativeMacApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.fife.help.HelpDialog;
import org.fife.ui.AboutDialog;
import org.fife.ui.CustomizableToolBar;
import org.fife.ui.OptionsDialog;
import org.fife.ui.SplashScreen;
import org.fife.ui.StatusBar;
import org.fife.ui.app.ActionRegistry;
import org.fife.ui.app.ExceptionDialog;
import org.fife.ui.app.ExtendedLookAndFeelInfo;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.GUIApplicationPreferences;
import org.fife.ui.app.ThirdPartyLookAndFeelManager;

public abstract class AbstractGUIApplication
extends JFrame
implements GUIApplication,
NativeMacApp {
    public static final String STATUS_BAR_PROPERTY = "statusBar";
    public static final String STATUS_BAR_VISIBLE_PROPERTY = "statusBarVisible";
    public static final String TOOL_BAR_PROPERTY = "toolBar";
    public static final String TOOL_BAR_VISIBLE_PROPERTY = "toolBarVisible";
    public static final String ABOUT_ACTION_KEY = "aboutAction";
    public static final String EXIT_ACTION_KEY = "exitAction";
    public static final String HELP_ACTION_KEY = "helpAction";
    private JDialog aboutDialog;
    private CustomizableToolBar toolBar;
    private StatusBar statusBar;
    private ActionRegistry actions;
    private ResourceBundle resourceBundle;
    private String installLocation;
    private String language;
    private JPanel contentPane;
    private JPanel[] toolBarPanels;
    protected JPanel mainContentPanel;
    protected JPanel actualContentPane;
    private ThirdPartyLookAndFeelManager lafManager;
    private static final String STATUS_BAR_LOCATION = "South";
    private static final String TOOL_BAR_LOCATION = "North";
    private int os;

    public AbstractGUIApplication(String jarFile) {
        this(null, jarFile);
    }

    public AbstractGUIApplication(String title, String jarFile) {
        this.initialize(title, jarFile, this.loadPreferences());
    }

    public AbstractGUIApplication(String title, String jarFile, GUIApplicationPreferences prefs) {
        this.initialize(title, jarFile, prefs);
    }

    private void initialize(String title, String jarFile, GUIApplicationPreferences prefs) {
        this.enableEvents(64L);
        this.setLanguage(prefs == null ? "en" : prefs.language);
        Locale locale = null;
        String language = this.getLanguage();
        int underscore = language.indexOf(95);
        locale = underscore > -1 ? new Locale(language.substring(0, underscore), language.substring(underscore + 1)) : new Locale(language);
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
        this.setLocale(locale);
        SplashScreen splashScreen = this.createSplashScreen();
        if (splashScreen != null) {
            splashScreen.setVisible(true);
        }
        SwingUtilities.invokeLater(new StartupRunnable(title, jarFile, splashScreen, prefs));
    }

    public void about() {
        try {
            this.getAboutDialog().setVisible(true);
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    public void addAction(String key, Action action) {
        this.actions.addAction(key, action);
    }

    public void addToolBar(JToolBar toolBar, String pos) {
        int count = this.toolBarPanels.length;
        JPanel[] newPanels = new JPanel[count + 1];
        System.arraycopy(this.toolBarPanels, 0, newPanels, 0, count);
        newPanels[count] = new JPanel(new BorderLayout());
        this.toolBarPanels = newPanels;
        this.toolBarPanels[count - 1].remove(this.mainContentPanel);
        this.toolBarPanels[count - 1].add(this.toolBarPanels[count]);
        this.toolBarPanels[count].add((Component)toolBar, pos);
        this.toolBarPanels[count].add(this.mainContentPanel);
    }

    protected JDialog createAboutDialog() {
        return new AboutDialog(this);
    }

    protected void createActions(GUIApplicationPreferences prefs) {
    }

    JPanel createMainContentPanel(JPanel actualContentPane) {
        JPanel mcp = new JPanel(new GridLayout(1, 1));
        mcp.add(actualContentPane);
        return mcp;
    }

    protected abstract JMenuBar createMenuBar(GUIApplicationPreferences var1);

    protected abstract SplashScreen createSplashScreen();

    protected abstract StatusBar createStatusBar(GUIApplicationPreferences var1);

    protected abstract CustomizableToolBar createToolBar(GUIApplicationPreferences var1);

    public final void displayException(Throwable t) {
        this.displayException(this, t);
    }

    public final void displayException(Throwable t, String desc) {
        this.displayException(this, t, desc);
    }

    public final void displayException(Dialog owner, Throwable t) {
        this.displayException(owner, t, null);
    }

    public void displayException(Dialog owner, Throwable t, String desc) {
        ExceptionDialog ed = new ExceptionDialog(owner, t);
        if (desc != null) {
            ed.setDescription(desc);
        }
        ed.setLocationRelativeTo(owner);
        ed.setVisible(true);
    }

    public final void displayException(Frame owner, Throwable t) {
        this.displayException(owner, t, null);
    }

    public void displayException(Frame owner, Throwable t, String desc) {
        ExceptionDialog ed = new ExceptionDialog(owner, t);
        if (desc != null) {
            ed.setDescription(desc);
        }
        ed.setLocationRelativeTo(owner);
        ed.setVisible(true);
    }

    public void doExit() {
        System.exit(0);
    }

    public JDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = this.createAboutDialog();
            this.aboutDialog.setLocationRelativeTo(this);
        }
        return this.aboutDialog;
    }

    public Action getAction(String key) {
        return this.actions.getAction(key);
    }

    public SortedSet getActionKeys() {
        return this.actions.getActionKeys();
    }

    public Action[] getActions() {
        return this.actions.getActions();
    }

    public Container getContentPane() {
        return this.actualContentPane;
    }

    public abstract HelpDialog getHelpDialog();

    public String getInstallLocation() {
        return this.installLocation;
    }

    public String getLanguage() {
        return this.language;
    }

    public ThirdPartyLookAndFeelManager getLookAndFeelManager() {
        return this.lafManager;
    }

    public static String getLocationOfJar(String jarFileName) {
        String classPath = System.getProperty("java.class.path");
        int index = classPath.indexOf(jarFileName);
        if (index > -1) {
            int pathBeginning = classPath.lastIndexOf(File.pathSeparator, index - 1) + 1;
            String loc = classPath.substring(pathBeginning, index);
            File file = new File(loc);
            return file.getAbsolutePath();
        }
        return System.getProperty("user.dir");
    }

    public ExtendedLookAndFeelInfo[] get3rdPartyLookAndFeelInfo() {
        return this.lafManager != null ? this.lafManager.get3rdPartyLookAndFeelInfo() : null;
    }

    public OptionsDialog getOptionsDialog() {
        return null;
    }

    public int getOS() {
        if (this.os == 0) {
            this.os = 8;
            String osName = System.getProperty("os.name");
            if (osName != null) {
                this.os = (osName = osName.toLowerCase()).indexOf("windows") > -1 ? 1 : (osName.indexOf("mac os x") > -1 ? 2 : (osName.indexOf("linux") > -1 ? 4 : 8));
            }
        }
        return this.os;
    }

    protected abstract String getPreferencesClassName();

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle(this.getResourceBundleClassName());
        }
        return this.resourceBundle;
    }

    public abstract String getResourceBundleClassName();

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public boolean getStatusBarVisible() {
        return this.statusBar != null ? this.statusBar.isVisible() : false;
    }

    public String getString(String key) {
        return this.getResourceBundle().getString(key);
    }

    public String getString(String key, Object param) {
        return this.getString(key, new Object[]{param});
    }

    public String getString(String key, Object param1, Object param2) {
        return this.getString(key, new Object[]{param1, param2});
    }

    public String getString(String key, Object param1, Object param2, Object param3) {
        return this.getString(key, new Object[]{param1, param2, param3});
    }

    public String getString(String key, Object[] params) {
        String text = this.getResourceBundle().getString(key);
        return MessageFormat.format(text, params);
    }

    public CustomizableToolBar getToolBar() {
        return this.toolBar;
    }

    public boolean getToolBarVisible() {
        return this.toolBar != null ? this.toolBar.isVisible() : false;
    }

    public abstract String getVersionString();

    public boolean isMaximized() {
        return this.getExtendedState() == 6;
    }

    protected void loadActionShortcuts(File file) {
        try {
            this.actions.loadShortcuts(file);
        }
        catch (IOException ioe) {
            this.displayException(ioe);
        }
    }

    public GUIApplicationPreferences loadPreferences() {
        GUIApplicationPreferences prefs = null;
        String prefsClassName = this.getPreferencesClassName();
        if (prefsClassName != null) {
            try {
                Class<?> prefsClass = Class.forName(prefsClassName);
                Object[] nullClass = null;
                Method method = prefsClass.getMethod("loadPreferences", (Class<?>[])nullClass);
                prefs = (GUIApplicationPreferences)method.invoke(prefsClass, nullClass);
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
        return prefs;
    }

    public abstract void openFile(String var1);

    private void possibleMacOSXRegistration() {
        if (this.getOS() == 2) {
            try {
                Class<?> osxAdapter = Class.forName("com.apple.osxadapter.OSXAdapter");
                Class[] defArgs = new Class[]{NativeMacApp.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this};
                    registerMethod.invoke(osxAdapter, args);
                }
                defArgs[0] = Boolean.TYPE;
                Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                if (prefsEnableMethod != null) {
                    Object[] args = new Object[]{Boolean.TRUE};
                    prefsEnableMethod.invoke(osxAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                this.displayException(e);
            }
            catch (ClassNotFoundException e) {
                this.displayException(e);
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
    }

    public abstract void preferences();

    protected abstract void preDisplayInit(GUIApplicationPreferences var1, SplashScreen var2);

    protected abstract void preMenuBarInit(GUIApplicationPreferences var1, SplashScreen var2);

    protected abstract void preStatusBarInit(GUIApplicationPreferences var1, SplashScreen var2);

    protected abstract void preToolBarInit(GUIApplicationPreferences var1, SplashScreen var2);

    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                this.doExit();
                break;
            }
            case 206: {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
        super.processWindowEvent(e);
    }

    public void quit() {
        this.doExit();
    }

    private void registerMenuSelectionManagerListener() {
        if (this.statusBar == null) {
            return;
        }
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component c;
                if (AbstractGUIApplication.this.statusBar == null) {
                    return;
                }
                String msg = AbstractGUIApplication.this.statusBar.getDefaultStatusMessage();
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 0 && (c = path[path.length - 1].getComponent()) instanceof JMenuItem) {
                    JMenuItem item = (JMenuItem)c;
                    Action a = item.getAction();
                    if (a != null) {
                        msg = (String)a.getValue("ShortDescription");
                    } else {
                        String text = item.getAccessibleContext().getAccessibleDescription();
                        if (text != null) {
                            msg = text;
                        }
                    }
                }
                AbstractGUIApplication.this.statusBar.setStatusMessage(msg);
            }
        });
    }

    protected void saveActionShortcuts(File file) {
        try {
            this.actions.saveShortcuts(file);
        }
        catch (IOException ioe) {
            this.displayException(ioe);
        }
    }

    public void setContentPane(Container contentPane) {
        if (contentPane != null && !contentPane.equals(this.actualContentPane)) {
            if (this.actualContentPane != null) {
                this.mainContentPanel.remove(this.actualContentPane);
            }
            this.mainContentPanel.add(contentPane);
        }
    }

    private void setInstallLocation(String location) {
        File temp = new File(location);
        this.installLocation = temp.isDirectory() ? temp.getAbsolutePath() : System.getProperty("user.dir");
    }

    public void setLanguage(String language) {
        this.language = language == null ? "en" : language;
    }

    public void setLookAndFeelManager(ThirdPartyLookAndFeelManager manager) {
        this.lafManager = manager;
    }

    public void setStatusBar(StatusBar statusBar) {
        if (statusBar != null && !statusBar.equals(this.statusBar)) {
            StatusBar old = this.statusBar;
            if (old != null) {
                this.contentPane.remove(old);
            }
            this.statusBar = statusBar;
            this.contentPane.add((Component)statusBar, STATUS_BAR_LOCATION);
            this.firePropertyChange(STATUS_BAR_PROPERTY, old, statusBar);
        }
    }

    public void setStatusBarVisible(boolean visible) {
        if (this.statusBar != null && this.statusBar.isVisible() != visible) {
            this.statusBar.setVisible(visible);
            this.firePropertyChange(STATUS_BAR_VISIBLE_PROPERTY, !visible, visible);
        }
    }

    public void setToolBar(CustomizableToolBar toolBar) {
        if (toolBar != null && !toolBar.equals(this.toolBar)) {
            CustomizableToolBar old = this.toolBar;
            if (old != null) {
                this.toolBarPanels[0].remove(old);
            }
            this.toolBar = toolBar;
            this.toolBarPanels[0].add((Component)toolBar, TOOL_BAR_LOCATION);
            this.firePropertyChange(TOOL_BAR_PROPERTY, old, toolBar);
        }
    }

    public void setToolBarVisible(boolean visible) {
        if (this.toolBar != null && this.toolBar.isVisible() != visible) {
            this.toolBar.setVisible(visible);
            this.firePropertyChange(TOOL_BAR_VISIBLE_PROPERTY, !visible, visible);
        }
    }

    public void updateLookAndFeel(LookAndFeel lnf) {
        if (this.aboutDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.aboutDialog);
        }
    }

    static /* synthetic */ JPanel[] access$402(AbstractGUIApplication x0, JPanel[] x1) {
        x0.toolBarPanels = x1;
        return x1;
    }

    private class StartupRunnable
    implements Runnable {
        private String title;
        private String jarFile;
        private SplashScreen splashScreen;
        private GUIApplicationPreferences prefs;

        public StartupRunnable(String title, String jarFile, SplashScreen splashScreen, GUIApplicationPreferences prefs) {
            this.splashScreen = splashScreen;
            this.prefs = prefs;
            this.title = title;
            this.jarFile = jarFile;
        }

        public void run() {
            AbstractGUIApplication.this.setTitle(this.title);
            AbstractGUIApplication.this.setInstallLocation(AbstractGUIApplication.getLocationOfJar(this.jarFile));
            AbstractGUIApplication.this.contentPane = new JPanel(new BorderLayout());
            AbstractGUIApplication.super.setContentPane(AbstractGUIApplication.this.contentPane);
            AbstractGUIApplication.access$402(AbstractGUIApplication.this, new JPanel[1]);
            ((AbstractGUIApplication)AbstractGUIApplication.this).toolBarPanels[0] = new JPanel(new BorderLayout());
            AbstractGUIApplication.this.contentPane.add(AbstractGUIApplication.this.toolBarPanels[0]);
            AbstractGUIApplication.this.actualContentPane = new JPanel(new BorderLayout());
            AbstractGUIApplication.this.mainContentPanel = AbstractGUIApplication.this.createMainContentPanel(AbstractGUIApplication.this.actualContentPane);
            AbstractGUIApplication.this.toolBarPanels[0].add(AbstractGUIApplication.this.mainContentPanel);
            if (AbstractGUIApplication.this.lafManager != null) {
                ClassLoader cl = AbstractGUIApplication.this.lafManager.getLAFClassLoader();
                UIManager.getLookAndFeelDefaults().put("ClassLoader", cl);
            }
            AbstractGUIApplication.this.actions = new ActionRegistry();
            AbstractGUIApplication.this.createActions(this.prefs);
            AbstractGUIApplication.this.preStatusBarInit(this.prefs, this.splashScreen);
            StatusBar statusBar = AbstractGUIApplication.this.createStatusBar(this.prefs);
            AbstractGUIApplication.this.setStatusBar(statusBar);
            AbstractGUIApplication.this.preToolBarInit(this.prefs, this.splashScreen);
            CustomizableToolBar toolBar = AbstractGUIApplication.this.createToolBar(this.prefs);
            AbstractGUIApplication.this.setToolBar(toolBar);
            AbstractGUIApplication.this.preMenuBarInit(this.prefs, this.splashScreen);
            JMenuBar menuBar = AbstractGUIApplication.this.createMenuBar(this.prefs);
            ComponentOrientation o = ComponentOrientation.getOrientation(AbstractGUIApplication.this.getLocale());
            menuBar.applyComponentOrientation(o);
            AbstractGUIApplication.this.setJMenuBar(menuBar);
            AbstractGUIApplication.this.preDisplayInit(this.prefs, this.splashScreen);
            AbstractGUIApplication.this.registerMenuSelectionManagerListener();
            AbstractGUIApplication.this.possibleMacOSXRegistration();
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            AbstractGUIApplication.this.pack();
            if (this.prefs != null) {
                if (this.prefs.location != null) {
                    AbstractGUIApplication.this.setLocation(this.prefs.location);
                } else {
                    AbstractGUIApplication.this.setLocationRelativeTo(null);
                }
                if (this.prefs.size == null || this.prefs.size.equals(new Dimension(-1, -1))) {
                    AbstractGUIApplication.this.setExtendedState(6);
                } else {
                    AbstractGUIApplication.this.setSize(this.prefs.size);
                }
                AbstractGUIApplication.this.setToolBarVisible(this.prefs.toolbarVisible);
                AbstractGUIApplication.this.setStatusBarVisible(this.prefs.statusBarVisible);
            } else {
                AbstractGUIApplication.this.setToolBarVisible(true);
                AbstractGUIApplication.this.setStatusBarVisible(true);
                AbstractGUIApplication.this.setLocationRelativeTo(null);
            }
            ComponentOrientation orientation = ComponentOrientation.getOrientation(AbstractGUIApplication.this.getLocale());
            AbstractGUIApplication.this.applyComponentOrientation(orientation);
            if (this.splashScreen != null) {
                this.splashScreen.setVisible(false);
                this.splashScreen.dispose();
            }
            AbstractGUIApplication.this.setVisible(true);
        }
    }
}

