/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class AnsiTrimEmulationFunction
implements SQLFunction {
    private static final SQLFunction LEADING_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( ?1 )");
    private static final SQLFunction TRAILING_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "rtrim( ?1 )");
    private static final SQLFunction BOTH_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( rtrim( ?1 ) )");
    private static final SQLFunction BOTH_SPACE_TRIM_FROM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( rtrim( ?2 ) )");
    private static final SQLFunction LEADING_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "replace( replace( rtrim( replace( replace( ?1, ' ', '${space}$' ), ?2, ' ' ) ), ' ', ?2 ), '${space}$', ' ' )");
    private static final SQLFunction TRAILING_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "replace( replace( ltrim( replace( replace( ?1, ' ', '${space}$' ), ?2, ' ' ) ), ' ', ?2 ), '${space}$', ' ' )");
    private static final SQLFunction BOTH_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "replace( replace( ltrim( rtrim( replace( replace( ?1, ' ', '${space}$' ), ?2, ' ' ) ) ), ' ', ?2 ), '${space}$', ' ' )");

    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return Hibernate.STRING;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return false;
    }

    public String render(List args, SessionFactoryImplementor factory) throws QueryException {
        if (args.size() == 1) {
            return BOTH_SPACE_TRIM.render(args, factory);
        }
        if ("from".equalsIgnoreCase((String)args.get(0))) {
            return BOTH_SPACE_TRIM_FROM.render(args, factory);
        }
        boolean leading = true;
        boolean trailing = true;
        String trimCharacter = null;
        String trimSource = null;
        int potentialTrimCharacterArgIndex = 1;
        String firstArg = (String)args.get(0);
        if ("leading".equalsIgnoreCase(firstArg)) {
            trailing = false;
        } else if ("trailing".equalsIgnoreCase(firstArg)) {
            leading = false;
        } else if (!"both".equalsIgnoreCase(firstArg)) {
            potentialTrimCharacterArgIndex = 0;
        }
        String potentialTrimCharacter = (String)args.get(potentialTrimCharacterArgIndex);
        if ("from".equalsIgnoreCase(potentialTrimCharacter)) {
            trimCharacter = "' '";
            trimSource = (String)args.get(potentialTrimCharacterArgIndex + 1);
        } else if (potentialTrimCharacterArgIndex + 1 >= args.size()) {
            trimCharacter = "' '";
            trimSource = potentialTrimCharacter;
        } else {
            trimCharacter = potentialTrimCharacter;
            trimSource = "from".equalsIgnoreCase((String)args.get(potentialTrimCharacterArgIndex + 1)) ? (String)args.get(potentialTrimCharacterArgIndex + 2) : (String)args.get(potentialTrimCharacterArgIndex + 1);
        }
        ArrayList<String> argsToUse = null;
        argsToUse = new ArrayList<String>();
        argsToUse.add(trimSource);
        argsToUse.add(trimCharacter);
        if (trimCharacter.equals("' '")) {
            if (leading && trailing) {
                return BOTH_SPACE_TRIM.render(argsToUse, factory);
            }
            if (leading) {
                return LEADING_SPACE_TRIM.render(argsToUse, factory);
            }
            return TRAILING_SPACE_TRIM.render(argsToUse, factory);
        }
        if (leading && trailing) {
            return BOTH_TRIM.render(argsToUse, factory);
        }
        if (leading) {
            return LEADING_TRIM.render(argsToUse, factory);
        }
        return TRAILING_TRIM.render(argsToUse, factory);
    }
}

