/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import net.infonode.gui.BackgroundPainter;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.util.Direction;

public class ComponentUtil {
    private ComponentUtil() {
    }

    public static final Component getChildAt(Container container, Point point) {
        Component component = container.getComponentAt(point);
        return component == null || component.getParent() != container ? null : component;
    }

    public static final Component getVisibleChildAt(Container container, Point point) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible() || !component.contains(point.x - component.getX(), point.y - component.getY())) continue;
            return component;
        }
        return null;
    }

    public static final Component getChildAtLine(Container container, Point point, boolean bl) {
        if (bl) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (point.x < component.getX() || point.x >= component.getX() + component.getWidth()) continue;
                return component;
            }
        } else {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (point.y < component.getY() || point.y >= component.getY() + component.getHeight()) continue;
                return component;
            }
        }
        return null;
    }

    public static void getComponentTreePosition(Component component, ArrayList arrayList) {
        if (component.getParent() == null) {
            return;
        }
        ComponentUtil.getComponentTreePosition(component.getParent(), arrayList);
        arrayList.add(new Integer(component.getParent().getComponentCount() - ComponentUtil.getComponentIndex(component)));
    }

    public static Component findComponentUnderGlassPaneAt(Point point, Component component) {
        Component component2 = null;
        if (component.isShowing()) {
            component2 = component instanceof RootPaneContainer ? ((RootPaneContainer)((Object)component)).getLayeredPane().findComponentAt(SwingUtilities.convertPoint(component, point, ((RootPaneContainer)((Object)component)).getLayeredPane())) : ((Container)component).findComponentAt(point);
        }
        return component2;
    }

    public static final int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container container = component.getParent();
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (container.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    public static final String getBorderLayoutOrientation(Direction direction) {
        return direction == Direction.UP ? "North" : (direction == Direction.LEFT ? "West" : (direction == Direction.DOWN ? "South" : "East"));
    }

    public static Color getBackgroundColor(Component component) {
        Color color;
        ComponentPainter componentPainter;
        if (component == null) {
            return null;
        }
        if (component instanceof BackgroundPainter && (componentPainter = ((BackgroundPainter)((Object)component)).getComponentPainter()) != null && (color = componentPainter.getColor(component)) != null) {
            return color;
        }
        return component.isOpaque() ? component.getBackground() : ComponentUtil.getBackgroundColor(component.getParent());
    }

    public static int countComponents(Container container) {
        int n = 1;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                n += ComponentUtil.countComponents((Container)component);
                continue;
            }
            ++n;
        }
        return n;
    }

    public static int getVisibleChildrenCount(Component component) {
        if (component == null || !(component instanceof Container)) {
            return 0;
        }
        int n = 0;
        Container container = (Container)component;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (!container.getComponent(i).isVisible()) continue;
            ++n;
        }
        return n;
    }

    public static Component getTopLevelAncestor(Component component) {
        while (component != null && !(component instanceof Window) && !(component instanceof Applet)) {
            component = component.getParent();
        }
        return component;
    }

    public static boolean hasVisibleChildren(Component component) {
        return ComponentUtil.getVisibleChildrenCount(component) > 0;
    }

    public static boolean isOnlyVisibleComponent(Component component) {
        return component != null && component.isVisible() && ComponentUtil.getVisibleChildrenCount(component.getParent()) == 1;
    }

    public static boolean isOnlyVisibleComponents(Component[] componentArray) {
        if (componentArray != null && componentArray.length > 0) {
            boolean bl;
            boolean bl2 = bl = ComponentUtil.getVisibleChildrenCount(componentArray[0].getParent()) == componentArray.length;
            if (bl) {
                for (int i = 0; i < componentArray.length; ++i) {
                    bl = bl && componentArray[i].isVisible();
                }
            }
            return bl;
        }
        return false;
    }

    public static Component findFirstComponentOfType(Component component, Class clazz) {
        if (clazz.isInstance(component)) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component2 = ComponentUtil.findFirstComponentOfType(container.getComponent(i), clazz);
                if (component2 == null) continue;
                return component2;
            }
        }
        return null;
    }

    public static boolean isFocusable(Component component) {
        return component.isFocusable() && component.isDisplayable() && component.isVisible() && component.isEnabled();
    }

    public static boolean requestFocus(Component component) {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == component || component.requestFocusInWindow();
    }

    public static Component smartRequestFocus(Component component) {
        Component component2;
        Component[] componentArray;
        if (ComponentUtil.requestFocus(component)) {
            return component;
        }
        if (component instanceof JComponent && (componentArray = ((JComponent)component).getFocusTraversalPolicy()) != null && (component2 = componentArray.getDefaultComponent((Container)component)) != null && ComponentUtil.requestFocus(component2)) {
            return component2;
        }
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                component = ComponentUtil.smartRequestFocus(componentArray[i]);
                if (component == null) continue;
                return component;
            }
        }
        return null;
    }

    public static int getPreferredMaxHeight(Component[] componentArray) {
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            int n2 = (int)componentArray[i].getPreferredSize().getHeight();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static int getPreferredMaxWidth(Component[] componentArray) {
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            int n2 = (int)componentArray[i].getPreferredSize().getWidth();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static void setAllOpaque(Container container, boolean bl) {
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(bl);
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof Container)) continue;
                ComponentUtil.setAllOpaque((Container)component, bl);
            }
        }
    }

    public static void validate(JComponent jComponent) {
        jComponent.revalidate();
    }

    public static void validate(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).revalidate();
        } else {
            component.validate();
        }
    }
}

