/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

public class SyntaxFilters
implements SyntaxConstants {
    private Map<String, List<String>> filters = new HashMap<String, List<String>>();
    private Map<String, List<String>> addedFilters;

    public SyntaxFilters() {
        this(null);
    }

    public SyntaxFilters(String filterStr) {
        this.restoreDefaultFileFilters();
        if (filterStr != null) {
            int oldCommaPos = 0;
            int commaPos = filterStr.indexOf(44, 0);
            try {
                while (commaPos != -1) {
                    int colon;
                    Object temp = filterStr.substring(oldCommaPos, commaPos);
                    int slash = ((String)temp).indexOf(92);
                    if (slash > -1) {
                        temp = ((String)temp).substring(0, slash) + "/" + ((String)temp).substring(slash + 1);
                    }
                    if ((colon = ((String)temp).indexOf(58)) <= -1) {
                        System.err.println("Invalid saved filter string.  Using default syntax filters");
                        this.restoreDefaultFileFilters();
                        return;
                    }
                    String style = ((String)temp).substring(0, colon);
                    this.setFiltersForSyntaxStyle(style, ((String)temp).substring(colon + 1));
                    oldCommaPos = commaPos + 1;
                    commaPos = filterStr.indexOf(44, oldCommaPos);
                }
                int colon = filterStr.indexOf(58, oldCommaPos);
                if (colon > -1) {
                    String style = filterStr.substring(oldCommaPos, colon);
                    this.setFiltersForSyntaxStyle(style, filterStr.substring(colon + 1));
                } else {
                    System.err.println("Invalid saved filter string.  Using default syntax filters");
                    this.restoreDefaultFileFilters();
                }
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Error with syntax style, using defaults: " + iae.getMessage());
                this.restoreDefaultFileFilters();
            }
        }
    }

    public void addFileFilter(String style, String filter) {
        this.getFiltersForStyle(style).add(filter);
    }

    private static List<String> createValue(String ... values) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(values));
        return list;
    }

    private List<String> getFiltersForStyle(String style) {
        List<String> l = this.filters.get(style);
        if (l == null) {
            if (this.addedFilters == null) {
                this.addedFilters = new HashMap<String, List<String>>();
            } else {
                l = this.addedFilters.get(style);
            }
            if (l == null) {
                l = new ArrayList<String>();
                this.addedFilters.put(style, l);
            }
        }
        return l;
    }

    public String getFilterString(String style) {
        StringBuilder filterString = new StringBuilder();
        List<String> filters = this.getFiltersForStyle(style);
        for (String filter : filters) {
            filterString.append(filter).append(' ');
        }
        return filterString.toString();
    }

    public String getSyntaxStyleForFile(String fileName, boolean ignoreBackupExtensions) {
        String style;
        if (fileName == null) {
            return "text/plain";
        }
        int lastSlash = fileName.lastIndexOf(File.separatorChar);
        if (lastSlash > -1) {
            fileName = fileName.substring(lastSlash + 1);
        }
        fileName = fileName.toLowerCase();
        if (ignoreBackupExtensions) {
            fileName = RTextUtilities.stripBackupExtensions(fileName);
        }
        if ((style = SyntaxFilters.getSyntaxStyleForFileImpl(fileName, this.filters)) == null && this.addedFilters != null) {
            style = SyntaxFilters.getSyntaxStyleForFileImpl(fileName, this.addedFilters);
        }
        return style != null ? style : "text/plain";
    }

    private static String getSyntaxStyleForFileImpl(String fileName, Map<String, List<String>> filters) {
        String syntaxStyle = null;
        block0: for (Map.Entry<String, List<String>> entry : filters.entrySet()) {
            for (String filter : entry.getValue()) {
                Pattern p = RTextUtilities.getPatternForFileFilter(filter, true);
                if (p == null || !p.matcher(fileName).matches()) continue;
                syntaxStyle = entry.getKey();
                if (filter.contains("*") || filter.contains("?")) continue;
                continue block0;
            }
        }
        return syntaxStyle;
    }

    public static boolean isValidFileFilterString(String fileFilterString) {
        int length = fileFilterString.length();
        block3: for (int i = 0; i < length; ++i) {
            char c = fileFilterString.charAt(i);
            switch (c) {
                case ' ': 
                case '$': 
                case '*': 
                case '-': 
                case '.': 
                case '?': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public void restoreDefaultFileFilters() {
        this.filters.clear();
        this.filters.put("text/actionscript", SyntaxFilters.createValue("*.as", "*.asc"));
        this.filters.put("text/asm", SyntaxFilters.createValue("*.asm"));
        this.filters.put("text/bbcode", SyntaxFilters.createValue("*.bbc"));
        this.filters.put("text/c", SyntaxFilters.createValue("*.c"));
        this.filters.put("text/clojure", SyntaxFilters.createValue("*.clj"));
        this.filters.put("text/cpp", SyntaxFilters.createValue("*.cpp", "*.cxx", "*.h"));
        this.filters.put("text/cs", SyntaxFilters.createValue("*.cs"));
        this.filters.put("text/css", SyntaxFilters.createValue("*.css"));
        this.filters.put("text/csv", SyntaxFilters.createValue("*.csv"));
        this.filters.put("text/d", SyntaxFilters.createValue("*.d"));
        this.filters.put("text/dart", SyntaxFilters.createValue("*.dart"));
        this.filters.put("text/delphi", SyntaxFilters.createValue("*.pas"));
        this.filters.put("text/dtd", SyntaxFilters.createValue("*.dtd"));
        this.filters.put("text/fortran", SyntaxFilters.createValue("*.f", "*.for", "*.fort", "*.f77", "*.f90"));
        this.filters.put("text/groovy", SyntaxFilters.createValue("*.groovy", "*.gradle", "*.grv"));
        this.filters.put("text/hosts", SyntaxFilters.createValue("hosts"));
        this.filters.put("text/htaccess", SyntaxFilters.createValue(".htaccess"));
        this.filters.put("text/html", SyntaxFilters.createValue("*.htm", "*.html"));
        this.filters.put("text/ini", SyntaxFilters.createValue("*.ini", ".editorconfig"));
        this.filters.put("text/java", SyntaxFilters.createValue("*.java"));
        this.filters.put("text/javascript", SyntaxFilters.createValue("*.js"));
        this.filters.put("text/jsp", SyntaxFilters.createValue("*.jsp"));
        this.filters.put("text/jshintrc", SyntaxFilters.createValue(".jshintrc", "tslint.json"));
        this.filters.put("text/json", SyntaxFilters.createValue("*.json"));
        this.filters.put("text/latex", SyntaxFilters.createValue("*.tex", "*.ltx", "*.latex"));
        this.filters.put("text/less", SyntaxFilters.createValue("*.less"));
        this.filters.put("text/lisp", SyntaxFilters.createValue("*.cl", "*.clisp", "*.el", "*.l", "*.lisp", "*.lsp", "*.ml"));
        this.filters.put("text/lua", SyntaxFilters.createValue("*.lua"));
        this.filters.put("text/makefile", SyntaxFilters.createValue("Makefile", "makefile"));
        this.filters.put("text/mxml", SyntaxFilters.createValue("*.mxml"));
        this.filters.put("text/nsis", SyntaxFilters.createValue("*.nsi"));
        this.filters.put("text/perl", SyntaxFilters.createValue("*.perl", "*.pl", "*.pm"));
        this.filters.put("text/php", SyntaxFilters.createValue("*.php"));
        this.filters.put("text/properties", SyntaxFilters.createValue("*.properties"));
        this.filters.put("text/python", SyntaxFilters.createValue("*.py"));
        this.filters.put("text/ruby", SyntaxFilters.createValue("*.rb", "Vagrantfile"));
        this.filters.put("text/sas", SyntaxFilters.createValue("*.sas"));
        this.filters.put("text/scala", SyntaxFilters.createValue("*.scala"));
        this.filters.put("text/sql", SyntaxFilters.createValue("*.sql"));
        this.filters.put("text/tcl", SyntaxFilters.createValue("*.tcl", "*.tk"));
        this.filters.put("text/typescript", SyntaxFilters.createValue("*.ts"));
        this.filters.put("text/unix", SyntaxFilters.createValue("*.sh", "*.?sh"));
        this.filters.put("text/vb", SyntaxFilters.createValue("*.vb"));
        this.filters.put("text/bat", SyntaxFilters.createValue("*.bat", "*.cmd"));
        this.filters.put("text/xml", SyntaxFilters.createValue("*.xml", "*.xsl", "*.xsd", "*.wsdl", "*.pom", "*.manifest", "*.tmx", "*.tsx"));
        this.filters.put("text/yaml", SyntaxFilters.createValue("*.yml", "*.yaml"));
    }

    public void setFiltersForSyntaxStyle(String style, String filterString) {
        List<String> filters = this.getFiltersForStyle(style);
        filters.clear();
        int oldSpacePos = 0;
        int spacePos = filterString.indexOf(32, 0);
        while (spacePos != -1) {
            if (spacePos > oldSpacePos + 1) {
                filters.add(filterString.substring(oldSpacePos, spacePos));
            }
            oldSpacePos = spacePos + 1;
            spacePos = filterString.indexOf(32, oldSpacePos);
        }
        if (oldSpacePos < filterString.length() - 1) {
            filters.add(filterString.substring(oldSpacePos));
        }
    }

    public void setPreservingPluginAdded(SyntaxFilters filters) {
        this.filters = new HashMap<String, List<String>>(filters.filters);
    }

    public String toString() {
        Object retVal = "";
        for (String style : this.filters.keySet()) {
            retVal = (String)retVal + style + ":" + this.getFilterString(style) + ",";
        }
        retVal = ((String)retVal).substring(0, ((String)retVal).length() - 1);
        return retVal;
    }
}

