/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginDatabaseObjectType;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.mssql.action.GenerateSqlAction;
import net.sourceforge.squirrel_sql.plugins.mssql.action.IndexDefragAction;
import net.sourceforge.squirrel_sql.plugins.mssql.action.ScriptProcedureAction;
import net.sourceforge.squirrel_sql.plugins.mssql.action.ScriptProcedureExecAction;
import net.sourceforge.squirrel_sql.plugins.mssql.action.ShowStatisticsAction;
import net.sourceforge.squirrel_sql.plugins.mssql.action.ShrinkDatabaseAction;
import net.sourceforge.squirrel_sql.plugins.mssql.action.ShrinkDatabaseFileAction;
import net.sourceforge.squirrel_sql.plugins.mssql.action.TruncateLogAction;
import net.sourceforge.squirrel_sql.plugins.mssql.action.UpdateStatisticsAction;
import net.sourceforge.squirrel_sql.plugins.mssql.event.IndexIterationListener;
import net.sourceforge.squirrel_sql.plugins.mssql.exp.MssqlTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.mssql.gui.MonitorPanel;
import net.sourceforge.squirrel_sql.plugins.mssql.prefs.MSSQLPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.mssql.prefs.PreferencesManager;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.dbfile.DatabaseFile;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.dbfile.DatabaseFileInfo;
import net.sourceforge.squirrel_sql.plugins.mssql.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.mssql.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.mssql.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.mssql.tokenizer.MSSQLQueryTokenizer;
import net.sourceforge.squirrel_sql.plugins.mssql.util.MssqlIntrospector;

public class MssqlPlugin
extends DefaultSessionPlugin {
    private static final ILogger s_log = LoggerController.createLogger(MssqlPlugin.class);
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private IObjectTreeAPI _treeAPI;
    private JMenu _mssqlMenu;
    private ISession _session;
    private int[] indexColumnIndices = new int[]{6};
    private PluginQueryTokenizerPreferencesManager _prefsManager = null;
    private static final String SCRIPT_SETTINGS_BORDER_LABEL_DBNAME = "MS SQL-Server";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MssqlPlugin.class);

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getContributors() {
        return "Rob Manning";
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        boolean includeProcSepPref = false;
        PluginQueryTokenizerPreferencesPanel _prefsPanel = new PluginQueryTokenizerPreferencesPanel(this._prefsManager, SCRIPT_SETTINGS_BORDER_LABEL_DBNAME, includeProcSepPref);
        PluginGlobalPreferencesTab tab = new PluginGlobalPreferencesTab(_prefsPanel);
        tab.setHint(i18n.hint);
        tab.setTitle(i18n.title);
        return new IGlobalPreferencesPanel[]{tab};
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public INewSessionPropertiesPanel[] getNewSessionPropertiesPanels() {
        INewSessionPropertiesPanel[] retValue = super.getNewSessionPropertiesPanels();
        return retValue;
    }

    public IPluginDatabaseObjectType[] getObjectTypes(ISession iSession) {
        IPluginDatabaseObjectType[] retValue = super.getObjectTypes(iSession);
        return retValue;
    }

    public FileWrapper getPluginAppSettingsFolder() throws IOException {
        FileWrapper retValue = super.getPluginAppSettingsFolder();
        return retValue;
    }

    public FileWrapper getPluginUserSettingsFolder() throws IOException {
        FileWrapper retValue = super.getPluginUserSettingsFolder();
        return retValue;
    }

    public ISessionPropertiesPanel[] getSessionPropertiesPanels(ISession iSession) {
        ISessionPropertiesPanel[] retValue = super.getSessionPropertiesPanels(iSession);
        return retValue;
    }

    public String getWebSite() {
        String retValue = super.getWebSite();
        return retValue;
    }

    public void initialize() throws PluginException {
        super.initialize();
        PreferencesManager.initialize((IPlugin)this);
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new GenerateSqlAction(app, this._resources, this)));
        coll.add((Action)((Object)new ScriptProcedureAction(app, this._resources, this)));
        coll.add((Action)((Object)new ScriptProcedureExecAction(app, this._resources, this)));
        coll.add((Action)((Object)new ShrinkDatabaseAction(app, this._resources, this)));
        coll.add((Action)((Object)new TruncateLogAction(app, this._resources, this)));
        coll.add((Action)((Object)new UpdateStatisticsAction(app, this._resources, this)));
        this._mssqlMenu = this.createFullMssqlMenu();
        app.addToMenu(2, this._mssqlMenu);
        super.registerSessionMenu(this._mssqlMenu);
        this._prefsManager = new PluginQueryTokenizerPreferencesManager();
        this._prefsManager.initialize((IPlugin)this, (IQueryTokenizerPreferenceBean)new MSSQLPreferenceBean());
    }

    public void load(IApplication iApplication) throws PluginException {
        super.load(iApplication);
        this._resources = this._resourcesFactory.createResource(((Object)((Object)this)).getClass().getName(), (IPlugin)this);
    }

    public void sessionCreated(ISession iSession) {
        super.sessionCreated(iSession);
    }

    public void sessionEnding(ISession iSession) {
        super.sessionEnding(iSession);
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(ISession iSession) {
        if (!this.isPluginSession(iSession)) {
            return null;
        }
        this.installMssqlQueryTokenizer(iSession);
        GUIUtils.processOnSwingEventThread(() -> this.updateTreeApi(iSession));
        return new MssqlPluginSessionCallback();
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isMSSQLServer((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void installMssqlQueryTokenizer(ISession session) {
        IQueryTokenizerPreferenceBean _prefs = this._prefsManager.getPreferences();
        if (_prefs.isInstallCustomQueryTokenizer()) {
            session.setQueryTokenizer((IQueryTokenizer)new MSSQLQueryTokenizer(_prefs));
        }
    }

    private void updateTreeApi(ISession iSession) {
        this._treeAPI = iSession.getSessionInternalFrame().getObjectTreeAPI();
        this._treeAPI.addToPopup(DatabaseObjectType.CATALOG, this.addToMssqlCatalogMenu(null));
        this._treeAPI.addToPopup(DatabaseObjectType.TABLE, this.addToMssqlTableMenu(null));
        this._treeAPI.addToPopup(DatabaseObjectType.PROCEDURE, this.addToMssqlProcedureMenu(null));
        this._treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab());
        this._session = iSession;
        TableWithChildNodesExpander trigExp = new TableWithChildNodesExpander();
        trigExp.setTableTriggerExtractor((ITableTriggerExtractor)new MssqlTableTriggerExtractorImpl());
        this._treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)trigExp);
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab("The source of the trigger"));
        MonitorPanel monitorPanel = new MonitorPanel();
        iSession.addMainTab((IMainPanelTab)monitorPanel);
    }

    public void unload() {
        super.unload();
    }

    public String getAuthor() {
        return "Ryan Walberg";
    }

    public String getDescriptiveName() {
        return "Microsoft SQL Server Assistant";
    }

    public String getInternalName() {
        return "mssql";
    }

    public String getVersion() {
        return "0.4";
    }

    private void removeActionsOfType(ActionCollection coll, Class classType) {
        Iterator iter = coll.actions();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj.getClass() != classType) continue;
            iter.remove();
        }
    }

    private JMenu addToMssqlTableMenu(JMenu menu) {
        final IApplication app = this.getApplication();
        final ActionCollection coll = app.getActionCollection();
        final MssqlPlugin plugin = this;
        JMenu mssqlMenu = menu == null ? this._resources.createMenu("mssql") : menu;
        this._resources.addToMenu(coll.get(UpdateStatisticsAction.class), mssqlMenu);
        JMenu showStatisticsMenu = this._resources.createMenu("show_statistics");
        showStatisticsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                MssqlPlugin.this.onShowStatistics(e, coll, app, plugin);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu indexDefragMenu = this._resources.createMenu("indexdefrag");
        indexDefragMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                MssqlPlugin.this.onIndexDefrag(e, coll, app);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        mssqlMenu.add(showStatisticsMenu);
        mssqlMenu.add(indexDefragMenu);
        return mssqlMenu;
    }

    private void onShowStatistics(MenuEvent e, final ActionCollection coll, final IApplication app, final MssqlPlugin plugin) {
        final JMenu menu = (JMenu)e.getSource();
        menu.removeAll();
        this.removeActionsOfType(coll, ShowStatisticsAction.class);
        this.iterateIndexes(new IndexIterationListener(){

            @Override
            public void indexSpotted(ITableInfo tableInfo, String indexName) {
                ShowStatisticsAction showStatisticsAction = new ShowStatisticsAction(app, MssqlPlugin.this._resources, plugin, tableInfo, indexName);
                showStatisticsAction.setSession(MssqlPlugin.this._session);
                coll.add((Action)((Object)showStatisticsAction));
                MssqlPlugin.this._resources.addToMenu((Action)((Object)showStatisticsAction), menu);
            }
        });
    }

    private void onIndexDefrag(MenuEvent e, ActionCollection coll, IApplication app) {
        JMenu menu = (JMenu)e.getSource();
        menu.removeAll();
        this.removeActionsOfType(coll, IndexDefragAction.class);
        app.getThreadPool().addTask((Runnable)new IteratorIndexesTask(menu));
    }

    private void iterateIndexes(IndexIterationListener listener) {
        IDatabaseObjectInfo[] dbObjs = this._treeAPI.getSelectedDatabaseObjects();
        if (dbObjs.length != 1) {
            s_log.error((Object)"iterateIndexes: more than one item is selected");
            return;
        }
        if (dbObjs[0].getDatabaseObjectType() != DatabaseObjectType.TABLE) {
            s_log.error((Object)"iterateIndexes: selected item isn't a table");
            return;
        }
        ITableInfo tableInfo = (ITableInfo)dbObjs[0];
        ISQLConnection conn = this._session.getSQLConnection();
        SQLDatabaseMetaData metaData = conn.getSQLMetaData();
        try {
            ResultSetDataSet rsds = metaData.getIndexInfo(tableInfo, this.indexColumnIndices, false);
            String indexName = "";
            while (rsds.next(null)) {
                String thisIndexName = (String)rsds.get(0);
                if (thisIndexName == null || indexName.equals(thisIndexName)) continue;
                listener.indexSpotted(tableInfo, thisIndexName);
                indexName = thisIndexName;
            }
        }
        catch (DataSetException ex) {
            s_log.error((Object)("Unable to show indices for table " + tableInfo.getSimpleName()), (Throwable)ex);
        }
    }

    private JMenu createFullMssqlMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu mssqlMenu = this._resources.createMenu("mssql");
        this._resources.addToMenu(coll.get(GenerateSqlAction.class), mssqlMenu);
        this.addToMssqlCatalogMenu(mssqlMenu);
        this.addToMssqlTableMenu(mssqlMenu);
        this.addToMssqlProcedureMenu(mssqlMenu);
        return mssqlMenu;
    }

    private JMenu addToMssqlCatalogMenu(JMenu menu) {
        final IApplication app = this.getApplication();
        final ActionCollection coll = app.getActionCollection();
        final MssqlPlugin plugin = this;
        JMenu mssqlMenu = menu == null ? this._resources.createMenu("mssql") : menu;
        this._resources.addToMenu(coll.get(ShrinkDatabaseAction.class), mssqlMenu);
        this._resources.addToMenu(coll.get(TruncateLogAction.class), mssqlMenu);
        JMenu shrinkDBFileMenu = this._resources.createMenu("shrinkdbfile");
        shrinkDBFileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                MssqlPlugin.this.onShrinkDBFile(e, coll, app, plugin);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        mssqlMenu.add(shrinkDBFileMenu);
        return mssqlMenu;
    }

    private void onShrinkDBFile(MenuEvent e, ActionCollection coll, IApplication app, MssqlPlugin plugin) {
        JMenu menu = (JMenu)e.getSource();
        menu.removeAll();
        this.removeActionsOfType(coll, ShrinkDatabaseFileAction.class);
        ObjectTreeNode[] nodes = this._treeAPI.getSelectedNodes();
        if (nodes.length != 1) {
            return;
        }
        try {
            ShrinkDatabaseFileAction shrinkDatabaseFileAction;
            DatabaseFile file;
            int i;
            if (nodes[0].getDatabaseObjectType() != DatabaseObjectType.CATALOG) {
                return;
            }
            DatabaseFileInfo info = MssqlIntrospector.getDatabaseFileInfo(nodes[0].toString(), this._session.getSQLConnection());
            Object[] files = info.getDataFiles();
            for (i = 0; i < files.length; ++i) {
                file = (DatabaseFile)files[i];
                shrinkDatabaseFileAction = new ShrinkDatabaseFileAction(app, this._resources, plugin, nodes[0].toString(), file);
                shrinkDatabaseFileAction.setSession(this._session);
                coll.add((Action)((Object)shrinkDatabaseFileAction));
                this._resources.addToMenu((Action)((Object)shrinkDatabaseFileAction), menu);
            }
            menu.addSeparator();
            files = info.getLogFiles();
            for (i = 0; i < files.length; ++i) {
                file = (DatabaseFile)files[i];
                shrinkDatabaseFileAction = new ShrinkDatabaseFileAction(app, this._resources, plugin, nodes[0].toString(), file);
                shrinkDatabaseFileAction.setSession(this._session);
                coll.add((Action)((Object)shrinkDatabaseFileAction));
                this._resources.addToMenu((Action)((Object)shrinkDatabaseFileAction), menu);
            }
        }
        catch (SQLException ex) {
            s_log.error((Object)"Exception while attempting to shrink database file", (Throwable)ex);
        }
    }

    private JMenu addToMssqlProcedureMenu(JMenu menu) {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu mssqlMenu = menu == null ? this._resources.createMenu("mssql") : menu;
        this._resources.addToMenu(coll.get(ScriptProcedureAction.class), mssqlMenu);
        this._resources.addToMenu(coll.get(ScriptProcedureExecAction.class), mssqlMenu);
        return mssqlMenu;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class MssqlPluginSessionCallback
    implements PluginSessionCallback {
        private MssqlPluginSessionCallback() {
        }

        public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
        }

        public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
        }

        public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
        }
    }

    private class IteratorIndexesTask
    implements Runnable {
        JMenu _menu = null;
        final IApplication app = MssqlPlugin.this.getApplication();
        final ActionCollection coll = this.app.getActionCollection();
        final MssqlPlugin plugin = MssqlPlugin.this;

        public IteratorIndexesTask(JMenu menu) {
            this._menu = menu;
        }

        @Override
        public void run() {
            MssqlPlugin.this.iterateIndexes(new IndexIterationListener(){

                @Override
                public void indexSpotted(ITableInfo tableInfo, String indexName) {
                    IteratorIndexesTask.this.onIndexSpotted(tableInfo, indexName);
                }
            });
        }

        private void onIndexSpotted(ITableInfo tableInfo, String indexName) {
            final IndexDefragAction indexDefragAction = new IndexDefragAction(this.app, MssqlPlugin.this._resources, this.plugin, tableInfo, indexName);
            indexDefragAction.setSession(MssqlPlugin.this._session);
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    IteratorIndexesTask.this.coll.add((Action)((Object)indexDefragAction));
                    MssqlPlugin.this._resources.addToMenu((Action)((Object)indexDefragAction), IteratorIndexesTask.this._menu);
                }
            });
        }
    }

    static interface i18n {
        public static final String title = MssqlPlugin.access$000().getString("MssqlPlugin.title");
        public static final String hint = MssqlPlugin.access$000().getString("MssqlPlugin.hint");
    }

    public static interface IMenuResourceKeys {
        public static final String SHOW_STATISTICS = "show_statistics";
        public static final String INDEXDEFRAG = "indexdefrag";
        public static final String SHRINKDBFILE = "shrinkdbfile";
        public static final String MSSQL = "mssql";
    }
}

