/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.Desktop;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.ExportFileContainer;
import net.sourceforge.squirrel_sql.fw.gui.action.ExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvController;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class AbstractExportCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractExportCommand.class);
    private static ILogger s_log = LoggerController.createLogger(AbstractExportCommand.class);
    private ProgressAbortCallback progressController = null;
    private File targetFile;
    private ExportFileContainer fileContainer = ExportFileContainer.getInstance();
    private long writtenRows = -1L;

    protected long writeFile(TableExportCsvController ctrl, IExportData data) {
        return ExportFileWriter.writeFile(TableExportPreferencesDAO.loadPreferences(), data, this.progressController, ctrl.getOwningWindow());
    }

    private void executeCommand(String command, final Window owner) {
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            Object[] params = new Object[]{command, e.getMessage()};
            final String msg = s_stringMgr.getString("TableExportCsvCommand.failedToExecuteCommand", params);
            s_log.error(msg, e);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(owner, msg);
                }
            };
            GUIUtils.processOnSwingEventThread(runnable, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Window owner) throws ExportDataException {
        try {
            TableExportCsvController ctrl;
            boolean fileIsInUse = false;
            do {
                if (!(ctrl = this.createTableExportController(owner)).isOK()) {
                    return;
                }
                if (this.checkMissingData(ctrl.getSeparatorChar())) {
                    int choice = JOptionPane.showConfirmDialog(owner, i18n.missingClobDataMsg);
                    if (choice == 0) {
                        // empty if block
                    }
                    if (choice == 1) {
                        return;
                    }
                    if (choice == 2) {
                        return;
                    }
                }
                this.targetFile = ctrl.getFile();
                if (!this.fileContainer.add(this.targetFile)) {
                    fileIsInUse = true;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(owner, i18n.ANOTHER_EXPORT_IS_ACTIVE, i18n.TITLE_ANOTHER_EXPORT_IS_ACTIVE, 2);
                        }
                    };
                    GUIUtils.processOnSwingEventThread(runnable, true);
                    continue;
                }
                fileIsInUse = false;
            } while (fileIsInUse);
            this.progressController = this.createProgressController();
            try {
                this.writtenRows = this.writeFile(ctrl, this.createExportData(ctrl));
            }
            catch (ExportDataException e) {
                s_log.error(i18n.FAILED);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(owner, i18n.FAILED);
                    }
                };
                GUIUtils.processOnSwingEventThread(runnable);
                throw e;
            }
            if (this.writtenRows >= 0L) {
                String command = ctrl.getCommand();
                if (null != command) {
                    this.executeCommand(command, owner);
                } else {
                    TableExportCsvController finalCtrl = ctrl;
                    GUIUtils.processOnSwingEventThread(() -> this.showExportSuccessMessage(owner, this.writtenRows, finalCtrl.getFile()), true);
                }
            } else {
                s_log.info(i18n.FAILED);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(owner, i18n.FAILED);
                    }
                };
                GUIUtils.processOnSwingEventThread(runnable, true);
            }
        }
        finally {
            if (this.targetFile != null) {
                this.fileContainer.remove(this.targetFile);
            }
        }
    }

    private void showExportSuccessMessage(Window owner, long writtenRows, File exportFile) {
        try {
            Object[] selectionValues = new String[]{s_stringMgr.getString("TableExportCsvCommand.export.completed.ok"), s_stringMgr.getString("TableExportCsvCommand.export.completed.ok.show.in.file.manager")};
            String formattedWrittenRows = NumberFormat.getIntegerInstance().format(writtenRows);
            String fileName = StringUtilities.shorten(exportFile.getAbsolutePath(), 300, "...");
            int selectIndex = JOptionPane.showOptionDialog(owner, s_stringMgr.getString("TableExportCsvCommand.writeFileSuccess", formattedWrittenRows, fileName), s_stringMgr.getString("TableExportCsvCommand.writeFileSuccess.title"), -1, 1, null, selectionValues, selectionValues[0]);
            if (selectIndex == 1) {
                Desktop desktop = Desktop.getDesktop();
                desktop.open(exportFile.getParentFile());
            }
        }
        catch (IOException e) {
            s_log.error("Failed to open path to file " + exportFile.getAbsolutePath(), e);
        }
    }

    protected ProgressAbortCallback createProgressController() {
        return null;
    }

    protected TableExportCsvController createTableExportController(final Window owner) {
        try {
            final TableExportCsvController[] buf = new TableExportCsvController[1];
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    buf[0] = new TableExportCsvController(owner);
                }
            };
            GUIUtils.processOnSwingEventThread(runnable, true);
            return buf[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean checkMissingData(String var1);

    protected abstract IExportData createExportData(TableExportCsvController var1) throws ExportDataException;

    protected void progress(String task) {
        if (this.progressController != null) {
            this.progressController.currentlyLoading(task);
        }
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public long getWrittenRows() {
        return this.writtenRows;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String missingClobDataMsg = AbstractExportCommand.access$000().getString("TableExportCsvCommand.missingClobDataMsg", ClobDescriptor.i18n.CLOB_LABEL);
        public static final String FAILED = AbstractExportCommand.access$000().getString("AbstractExportCommand.failed");
        public static final String ANOTHER_EXPORT_IS_ACTIVE = AbstractExportCommand.access$000().getString("AbstractExportCommand.anotherExportIsActive");
        public static final String TITLE_ANOTHER_EXPORT_IS_ACTIVE = AbstractExportCommand.access$000().getString("AbstractExportCommand.anotherExportIsActive.title");
    }
}

