/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindService;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindServiceCallBack;
import net.sourceforge.squirrel_sql.fw.gui.ColumnOrder;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.SortingListener;

public class DefaultFindService
implements FindService {
    private DataSetViewerTable _table;
    private ColumnDisplayDefinition[] _columnDefinitions;

    public DefaultFindService(DataSetViewerTable table, ColumnDisplayDefinition[] columnDefinitions) {
        this._table = table;
        this._columnDefinitions = columnDefinitions;
    }

    @Override
    public int getRowCount() {
        return this._table.getRowCount();
    }

    @Override
    public int getColCount() {
        return this._table.getColumnCount();
    }

    @Override
    public String getViewDataAsString(int row, int col) {
        Object value = this._table.getValueAt(row, col);
        if (value instanceof String) {
            return (String)value;
        }
        return "" + value;
    }

    @Override
    public void scrollToVisible(int viewRow, int viewCol) {
        this._table.scrollToVisible(viewRow, viewCol);
    }

    @Override
    public void repaintCell(int viewRow, int viewCol) {
        Rectangle cellRect = this._table.getCellRect(viewRow, viewCol, true);
        this._table.repaint(cellRect);
    }

    @Override
    public void repaintAll() {
        this._table.repaint();
    }

    @Override
    public ColumnDisplayDefinition[] getColumnDisplayDefinitions() {
        return this._columnDefinitions;
    }

    @Override
    public List<Object[]> getRowsForIndexes(ArrayList<Integer> rowIndexes) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Integer row : rowIndexes) {
            ret.add(this._table.getDataSetViewerTableModel().getRowAt(row));
        }
        return ret;
    }

    @Override
    public Dimension getVisibleSize() {
        return this._table.getVisibleRect().getSize();
    }

    @Override
    public void setFindServiceCallBack(final FindServiceCallBack findServiceCallBack) {
        this._table.getColoringService().getFindColorHandler().setFindServiceCallBack(findServiceCallBack);
        if (this._table.getModel() instanceof SortableTableModel) {
            ((SortableTableModel)this._table.getModel()).addSortingListener(new SortingListener(){

                @Override
                public void sortingDone(int modelColumnIx, ColumnOrder columnOrder) {
                    findServiceCallBack.tableCellStructureChanged();
                }
            });
        }
        this._table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                findServiceCallBack.tableCellStructureChanged();
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }
}

