/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.MarkDuplicatesToggleAction;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooser;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MarkDuplicatesChooserController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MarkDuplicatesChooserController.class);
    private ButtonChooser _toggleBtnChooser;
    private IResultTab _resultTab;
    private static final String PREF_MARK_DUPLICATES_MODE_LAST_MODE = "MarkDuplicatesMode.last.mode";
    private boolean _dontReactToEvents = false;

    public MarkDuplicatesChooserController(IResultTab resultTab) {
        this._resultTab = resultTab;
        this._toggleBtnChooser = new ButtonChooser();
        for (MarkDuplicatesMode mode : MarkDuplicatesMode.values()) {
            JToggleButton btn = new JToggleButton(new MarkDuplicatesToggleAction(resultTab));
            btn.setIcon(mode.getIcon());
            btn.setText(mode.getText());
            btn.setToolTipText(mode.getToolTipText());
            this._toggleBtnChooser.addButton(btn);
        }
        this._toggleBtnChooser.setSelectedButton(this.getLastMode().findButton(this._toggleBtnChooser));
        this._toggleBtnChooser.setButtonSelectedListener((newSelectedButton, formerSelectedButton) -> this.onButtonSelected((JToggleButton)newSelectedButton, (JToggleButton)formerSelectedButton));
        IDataSetViewer dataSetViewer = this._resultTab.getSQLResultDataSetViewer();
        if (dataSetViewer instanceof DataSetViewerTablePanel) {
            SortableTableModel sortableTableModel = ((DataSetViewerTablePanel)dataSetViewer).getTable().getSortableTableModel();
            sortableTableModel.addSortingListener((modelColumnIx, columnOrder) -> this.onTableSorted());
        }
    }

    private void onTableSorted() {
        AbstractButton selButton = this._toggleBtnChooser.getSelectedButton();
        if (!selButton.isSelected()) {
            return;
        }
        MarkDuplicatesMode selectedMode = MarkDuplicatesMode.getModeByIcon(selButton.getIcon());
        if (selectedMode == MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_VALUES_IN_COLUMNS || selectedMode == MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_ROWS) {
            try {
                this._dontReactToEvents = true;
                selButton.setSelected(false);
            }
            finally {
                this._dontReactToEvents = false;
            }
            this.doMarkDuplicates();
        }
    }

    private void onButtonSelected(JToggleButton newSelectedButton, JToggleButton formerSelectedButton) {
        if (this._dontReactToEvents) {
            return;
        }
        Props.putString(PREF_MARK_DUPLICATES_MODE_LAST_MODE, MarkDuplicatesMode.getModeByIcon(newSelectedButton.getIcon()).name());
        try {
            this._dontReactToEvents = true;
            newSelectedButton.setSelected(formerSelectedButton.isSelected());
            newSelectedButton.setContentAreaFilled(newSelectedButton.isSelected());
        }
        finally {
            this._dontReactToEvents = false;
        }
        this.doMarkDuplicates();
    }

    private MarkDuplicatesMode getLastMode() {
        return MarkDuplicatesMode.valueOf(Props.getString(PREF_MARK_DUPLICATES_MODE_LAST_MODE, MarkDuplicatesMode.DUPLICATE_VALUES_IN_COLUMNS.name()));
    }

    public ButtonChooser getComponent() {
        return this._toggleBtnChooser;
    }

    public boolean actionWasFired(ActionEvent e) {
        if (this._dontReactToEvents) {
            return true;
        }
        if (e.getSource() != this._toggleBtnChooser.getSelectedButton()) {
            this._toggleBtnChooser.getSelectedButton().doClick();
            return false;
        }
        this.doMarkDuplicates();
        return true;
    }

    private void doMarkDuplicates() {
        IDataSetViewer dataSetViewer = this._resultTab.getSQLResultDataSetViewer();
        if (!(dataSetViewer instanceof DataSetViewerTablePanel)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("MarkDuplicatesChooserController.mark.duplicates.for.table.output.only"));
            return;
        }
        boolean selected = this._toggleBtnChooser.getSelectedButton().isSelected();
        MarkDuplicatesMode mode = null;
        if (selected) {
            mode = MarkDuplicatesMode.getModeByIcon(this._toggleBtnChooser.getSelectedButton().getIcon());
        }
        ((DataSetViewerTablePanel)dataSetViewer).getTable().getColoringService().getMarkDuplicatesHandler().markDuplicates(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStateFrom(MarkDuplicatesChooserController controllerToCopyFrom) {
        try {
            this._dontReactToEvents = true;
            for (AbstractButton button : this._toggleBtnChooser.getAllButtons()) {
                if (button.getIcon() != controllerToCopyFrom._toggleBtnChooser.getSelectedButton().getIcon()) continue;
                this._toggleBtnChooser.setSelectedButton(button);
                button.setSelected(controllerToCopyFrom._toggleBtnChooser.getSelectedButton().isSelected());
                break;
            }
            this._toggleBtnChooser.getSelectedButton().setContentAreaFilled(this._toggleBtnChooser.getSelectedButton().isSelected());
        }
        finally {
            this._dontReactToEvents = false;
        }
    }
}

