/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyEvent;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IToolkitBeepHelper;

public class StringFieldKeyTextHandler
extends BaseKeyTextHandler {
    private IRestorableTextComponent _textComponent;
    private int _columnSize;
    private boolean _isNullable;
    private IToolkitBeepHelper _beepHelper = null;

    public StringFieldKeyTextHandler(IRestorableTextComponent component, int columnSize, boolean isNullable, IToolkitBeepHelper beepHelper) {
        this._textComponent = component;
        this._columnSize = columnSize;
        this._isNullable = isNullable;
        this._beepHelper = beepHelper;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        JTextComponent _theComponent = (JTextComponent)((Object)this._textComponent);
        String text = _theComponent.getText();
        if (this._columnSize > 0 && text.length() >= this._columnSize && c != '\b' && c != '\u007f') {
            e.consume();
            this._beepHelper.beep(_theComponent);
        }
        if (this._isNullable) {
            if (text.equals("<null>")) {
                if (c == '\b' || c == '\u007f') {
                    this._textComponent.restoreText();
                    e.consume();
                } else {
                    this._textComponent.updateText("");
                }
            } else if ((c == '\b' || c == '\u007f') && text.length() == 0) {
                this._textComponent.updateText("<null>");
                e.consume();
            }
        } else {
            this.handleNotNullableField(text, c, e, this._textComponent);
        }
    }
}

