/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.FloatingPointBase;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.FloatingPointBaseDTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.UserDefinedDecimalFormatFactory;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class FloatingPointPanel
extends OkJPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FloatingPointBase.class);
    JRadioButton optUseLocaleDependendFormat = new JRadioButton();
    JRadioButton optUseUserDefinedFormat = new JRadioButton();
    JRadioButton optUseJavaDefaultFormat = new JRadioButton(s_stringMgr.getString("floatingPointBase.useDefaultFormat", new Double(3.14159).toString()));
    IntegerField localeDependendMinimumFraction = new IntegerField(2);
    IntegerField localeDependendMaximumFraction = new IntegerField(2);
    IntegerField userDefinedMinimumFraction = new IntegerField(2);
    IntegerField userDefinedMaximumFraction = new IntegerField(2);
    JComboBox cboGroupingSeparator = new JComboBox<String>(new String[]{".", ",", "NONE"});
    JComboBox cboDecimalSeparator = new JComboBox<String>(new String[]{",", "."});

    public FloatingPointPanel() {
        this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("floatingPointBase.typeBigDecimal")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 0, 4), 0, 0);
        this.add((Component)this.optUseLocaleDependendFormat, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 30, 4, 4), 0, 0);
        this.add((Component)this.createLocalDependentConfigsPanel(), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 0, 4), 0, 0);
        this.add((Component)this.optUseUserDefinedFormat, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 30, 4, 4), 0, 0);
        this.add((Component)this.createUserDefinedConfigsPanel(), gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
        this.add((Component)this.optUseJavaDefaultFormat, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.optUseJavaDefaultFormat);
        bg.add(this.optUseUserDefinedFormat);
        bg.add(this.optUseLocaleDependendFormat);
        ChangeListener radioButtonListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FloatingPointPanel.this.onRadioButtonsChanged();
            }
        };
        this.optUseJavaDefaultFormat.addChangeListener(radioButtonListener);
        this.optUseLocaleDependendFormat.addChangeListener(radioButtonListener);
        this.optUseUserDefinedFormat.addChangeListener(radioButtonListener);
        this.optUseLocaleDependendFormat.setSelected(FloatingPointBaseDTProperties.isUseLocaleFormat());
        this.optUseJavaDefaultFormat.setSelected(FloatingPointBaseDTProperties.isUseJavaDefaultFormat());
        this.optUseUserDefinedFormat.setSelected(FloatingPointBaseDTProperties.isUseUserDefinedFormat());
        FocusAdapter localeDependentConfigListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FloatingPointPanel.this.optUseLocaleDependendFormat.setText(FloatingPointPanel.this.createTextForOptUseLocaleDependendFormat());
            }
        };
        this.localeDependendMinimumFraction.addFocusListener(localeDependentConfigListener);
        this.localeDependendMaximumFraction.addFocusListener(localeDependentConfigListener);
        this.localeDependendMinimumFraction.setInt(FloatingPointBaseDTProperties.getMinimumFractionDigits());
        this.localeDependendMaximumFraction.setInt(FloatingPointBaseDTProperties.getMaximumFractionDigits());
        FocusAdapter userDefinedFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FloatingPointPanel.this.optUseUserDefinedFormat.setText(FloatingPointPanel.this.createTextForOptUseUserDefinedFormat());
            }
        };
        this.optUseLocaleDependendFormat.setText(this.createTextForOptUseLocaleDependendFormat());
        this.userDefinedMaximumFraction.addFocusListener(userDefinedFocusListener);
        this.userDefinedMinimumFraction.addFocusListener(userDefinedFocusListener);
        this.userDefinedMinimumFraction.setInt(FloatingPointBaseDTProperties.getUserDefinedMinimumFractionDigits());
        this.userDefinedMaximumFraction.setInt(FloatingPointBaseDTProperties.getUserDefinedMaximumFractionDigits());
        ActionListener userDefinedActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloatingPointPanel.this.optUseUserDefinedFormat.setText(FloatingPointPanel.this.createTextForOptUseUserDefinedFormat());
            }
        };
        this.cboDecimalSeparator.addActionListener(userDefinedActionListener);
        this.cboGroupingSeparator.addActionListener(userDefinedActionListener);
        this.cboDecimalSeparator.setSelectedItem(FloatingPointBaseDTProperties.getUserDefinedDecimalSeparator());
        this.cboGroupingSeparator.setSelectedItem(FloatingPointBaseDTProperties.getUserDefinedGroupingSeparator());
        this.optUseUserDefinedFormat.setText(this.createTextForOptUseUserDefinedFormat());
    }

    private void onRadioButtonsChanged() {
        this.userDefinedMinimumFraction.setEditable(this.optUseUserDefinedFormat.isSelected());
        this.userDefinedMinimumFraction.setEnabled(this.optUseUserDefinedFormat.isSelected());
        this.userDefinedMaximumFraction.setEditable(this.optUseUserDefinedFormat.isSelected());
        this.userDefinedMaximumFraction.setEnabled(this.optUseUserDefinedFormat.isSelected());
        this.localeDependendMinimumFraction.setEditable(this.optUseLocaleDependendFormat.isSelected());
        this.localeDependendMinimumFraction.setEnabled(this.optUseLocaleDependendFormat.isSelected());
        this.localeDependendMaximumFraction.setEditable(this.optUseLocaleDependendFormat.isSelected());
        this.localeDependendMaximumFraction.setEnabled(this.optUseLocaleDependendFormat.isSelected());
        this.cboGroupingSeparator.setEnabled(this.optUseUserDefinedFormat.isSelected());
        this.cboDecimalSeparator.setEnabled(this.optUseUserDefinedFormat.isSelected());
    }

    private JPanel createLocalDependentConfigsPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        JLabel minimumFractionLabel = new JLabel(s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat.minDecimalDigits"));
        ret.add((Component)minimumFractionLabel, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        ret.add((Component)this.localeDependendMinimumFraction, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        JLabel maximumFractionLabel = new JLabel(s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat.maxDecimalDigits"));
        ret.add((Component)maximumFractionLabel, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        ret.add((Component)this.localeDependendMaximumFraction, gbc);
        return ret;
    }

    private JPanel createUserDefinedConfigsPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        JLabel minimumFractionLabel = new JLabel(s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat.minDecimalDigits"));
        ret.add((Component)minimumFractionLabel, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        ret.add((Component)this.userDefinedMinimumFraction, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        JLabel maximumFractionLabel = new JLabel(s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat.maxDecimalDigits"));
        ret.add((Component)maximumFractionLabel, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        ret.add((Component)this.userDefinedMaximumFraction, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        JLabel groupingSeparatorLabel = new JLabel(s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat.groupingSeparator"));
        ret.add((Component)groupingSeparatorLabel, gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0);
        this.cboGroupingSeparator.setFont(new Font(this.cboGroupingSeparator.getFont().getFamily(), 1, this.cboGroupingSeparator.getFont().getSize()));
        ret.add((Component)this.cboGroupingSeparator, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 4, 4, 4), 0, 0);
        JLabel decimalSeparatorLabel = new JLabel(s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat.decimalSeparator"));
        ret.add((Component)decimalSeparatorLabel, gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 4, 4, 4), 0, 0);
        this.cboDecimalSeparator.setFont(new Font(this.cboDecimalSeparator.getFont().getFamily(), 1, this.cboDecimalSeparator.getFont().getSize()));
        ret.add((Component)this.cboDecimalSeparator, gbc);
        return ret;
    }

    private String createTextForOptUseLocaleDependendFormat() {
        int minFractionDigits = this.localeDependendMinimumFraction.getInt();
        int maxFractionDigits = this.localeDependendMaximumFraction.getInt();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(minFractionDigits);
        numberFormat.setMaximumFractionDigits(maxFractionDigits);
        return s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat", numberFormat.format(new Double(1000000.0)), numberFormat.format(new Double(Math.PI)));
    }

    private String createTextForOptUseUserDefinedFormat() {
        int userDefinedMinimumFractionDigits = this.userDefinedMinimumFraction.getInt();
        int userDefinedMaximumFractionDigits = this.userDefinedMaximumFraction.getInt();
        String userDefinedDecimalSeparator = (String)this.cboDecimalSeparator.getSelectedItem();
        String userDefinedGroupingSeparator = (String)this.cboGroupingSeparator.getSelectedItem();
        NumberFormat numberFormat = UserDefinedDecimalFormatFactory.createUserDefinedFormat(userDefinedDecimalSeparator, userDefinedGroupingSeparator, userDefinedMinimumFractionDigits, userDefinedMaximumFractionDigits);
        return s_stringMgr.getString("floatingPointBase.optUseUserDefinedFormat", numberFormat.format(new Double(1000000.0)), numberFormat.format(new Double(Math.PI)));
    }

    @Override
    public void ok() {
        FloatingPointBaseDTProperties.setUseJavaDefaultFormat(this.optUseJavaDefaultFormat.isSelected());
        FloatingPointBaseDTProperties.setUseLocaleFormat(this.optUseLocaleDependendFormat.isSelected());
        FloatingPointBaseDTProperties.setUseUserDefinedFormat(this.optUseUserDefinedFormat.isSelected());
        FloatingPointBaseDTProperties.setMinimumFractionDigits(this.localeDependendMinimumFraction.getInt());
        FloatingPointBaseDTProperties.setMaximumFractionDigits(this.localeDependendMaximumFraction.getInt());
        FloatingPointBaseDTProperties.setUserDefinedMinimumFractionDigits(this.userDefinedMinimumFraction.getInt());
        FloatingPointBaseDTProperties.setUserDefinedMaximumFractionDigits(this.userDefinedMaximumFraction.getInt());
        FloatingPointBaseDTProperties.setUserDefinedDecimalSeparator((String)this.cboDecimalSeparator.getSelectedItem());
        FloatingPointBaseDTProperties.setUserDefinedGroupingSeparator((String)this.cboGroupingSeparator.getSelectedItem());
    }
}

