/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.gui.TablePopupMenu;

public class TablePopupMenuHandler {
    private final boolean _allowUpdate;
    private final IDataSetUpdateableModel _updateableObject;
    private final DataSetViewerTablePanel _dataSetViewerTablePanel;
    private final ISession _session;
    private TablePopupMenu _tablePopupMenu;
    private boolean _currentRowNumberMenuItemState;

    public TablePopupMenuHandler(boolean allowUpdate, IDataSetUpdateableModel updateableObject, DataSetViewerTablePanel dataSetViewerTablePanel, ISession session) {
        this._allowUpdate = allowUpdate;
        this._updateableObject = updateableObject;
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this._session = session;
        this.createTableMenuPopupWhenTableIsPresent();
    }

    private void createTableMenuPopupWhenTableIsPresent() {
        this._createTableMenuPopupWhenTableIsPresent(new int[1]);
    }

    private void _createTableMenuPopupWhenTableIsPresent(int[] counter) {
        if (null == this._dataSetViewerTablePanel.getTable()) {
            if (5 == counter[0]) {
                throw new IllegalStateException("Failed to create TablePopupMenu");
            }
            counter[0] = counter[0] + 1;
            SwingUtilities.invokeLater(() -> this._createTableMenuPopupWhenTableIsPresent(counter));
        } else {
            this._tablePopupMenu = new TablePopupMenu(this._allowUpdate, this._updateableObject, this._dataSetViewerTablePanel, this._session);
        }
    }

    public void reset() {
        this._currentRowNumberMenuItemState = false;
    }

    public void displayPopupMenu(MouseEvent evt) {
        this._tablePopupMenu.ensureRowNumbersMenuItemIsUpToDate(this._currentRowNumberMenuItemState);
        this._tablePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    public void ensureRowNumersMenuItemIsUpToDate(boolean currentRowNumberMenutItemState) {
        this._currentRowNumberMenuItemState = currentRowNumberMenutItemState;
    }
}

