/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;

public class ScrollColumnToVisibleHandler {
    private int blinkCount = 0;
    private Timer _timer;

    public ScrollColumnToVisibleHandler(final JTable table, ExtTableColumn toScrollto) {
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            ExtTableColumn column = (ExtTableColumn)table.getColumnModel().getColumn(i);
            if (column != toScrollto) continue;
            final int columnIxToScrollTo = i;
            Rectangle cellRect = table.getCellRect(0, columnIxToScrollTo, true);
            table.scrollRectToVisible(cellRect);
            this._timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScrollColumnToVisibleHandler.this.onBlinkCol(table, columnIxToScrollTo);
                }
            });
            this._timer.setRepeats(true);
            this.onBlinkCol(table, columnIxToScrollTo);
            this._timer.start();
            return;
        }
    }

    private void onBlinkCol(JTable table, int columnIxToScrollTo) {
        Rectangle headerRect = table.getTableHeader().getHeaderRect(columnIxToScrollTo);
        Graphics graphics = table.getTableHeader().getGraphics();
        if (this.blinkCount++ % 2 == 0) {
            Color formerColor = graphics.getColor();
            graphics.setColor(Color.red);
            graphics.drawRect(headerRect.x, headerRect.y, headerRect.width - 1, headerRect.height - 1);
            graphics.setColor(formerColor);
        } else {
            table.getTableHeader().repaint();
        }
        if (this.blinkCount > 10) {
            this._timer.stop();
            table.getTableHeader().repaint();
        }
    }
}

