/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataSetScrollingPanel
extends JScrollPane {
    private static final ILogger s_log = LoggerController.createLogger(DataSetScrollingPanel.class);
    private boolean _fullyCreated = false;
    private IDataSetViewer _viewer;
    private ISession _session;

    public DataSetScrollingPanel(String destClassName, IDataSetUpdateableModel updateableModel, ISession session) throws DataSetException {
        this(destClassName, updateableModel, null, session);
    }

    public DataSetScrollingPanel(String destClassName, IDataSetUpdateableModel updateableModel, DataModelImplementationDetails dataModelImplementationDetails, ISession session) throws DataSetException {
        this._session = session;
        this.createUserInterface(destClassName, updateableModel, dataModelImplementationDetails);
        this._fullyCreated = true;
    }

    public void load(IDataSet ds) {
        this.load(ds, null);
    }

    public void load(IDataSet ds, DataModelImplementationDetails dataModelImplementationDetails) {
        this.load(ds, null, dataModelImplementationDetails);
    }

    private void load(IDataSet ds, String destClassName, DataModelImplementationDetails dataModelImplementationDetails) {
        try {
            if (!this._fullyCreated) {
                this.createUserInterface(destClassName, null, dataModelImplementationDetails);
                this._fullyCreated = true;
            }
            UIUpdater run = new UIUpdater(this._viewer, ds);
            SwingUtilities.invokeLater(run);
        }
        catch (Exception ex) {
            s_log.error("Error", ex);
        }
    }

    public void clear() {
        if (this._viewer != null) {
            this._viewer.clear();
        }
    }

    private void createUserInterface(String destClassName, IDataSetUpdateableModel updateableModel, DataModelImplementationDetails dataModelImplementationDetails) throws DataSetException {
        this.setBorder(BorderFactory.createEmptyBorder());
        this._viewer = BaseDataSetViewerDestination.getInstance(destClassName, updateableModel, dataModelImplementationDetails, this._session);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataSetScrollingPanel.this.setViewportView(DataSetScrollingPanel.this._viewer.getComponent());
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public IDataSetViewer getViewer() {
        return this._viewer;
    }

    private static final class UIUpdater
    implements Runnable {
        private static final ILogger s_log = LoggerController.createLogger(UIUpdater.class);
        private final IDataSetViewer _viewer;
        private final IDataSet _ds;

        UIUpdater(IDataSetViewer viewer, IDataSet ds) {
            this._viewer = viewer;
            this._ds = ds;
        }

        @Override
        public void run() {
            try {
                this._viewer.show(this._ds);
            }
            catch (Throwable th) {
                s_log.error("Error processing a DataSet", th);
            }
        }
    }
}

