/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParseTerminateRequestCheck;

public class StatementBeginPrediction {
    static int predictNextStatementBegin(String sqlEditorText, int startPos, ParseTerminateRequestCheck check) {
        int ret;
        int[][] commentIntervals = StatementBeginPrediction.calculateCommentIntervals(sqlEditorText, check);
        int openBracketsCount = 0;
        int literalDelimsCount = 0;
        for (ret = startPos; sqlEditorText.length() > ret; ++ret) {
            if ('\'' == sqlEditorText.charAt(ret) && !StatementBeginPrediction.isInComment(ret, commentIntervals)) {
                ++literalDelimsCount;
            }
            if (!StatementBeginPrediction.isInComment(ret, commentIntervals) && !StatementBeginPrediction.isInLiteral(literalDelimsCount)) {
                if ('(' == sqlEditorText.charAt(ret)) {
                    ++openBracketsCount;
                } else if (')' == sqlEditorText.charAt(ret)) {
                    --openBracketsCount;
                }
            }
            if (!StatementBeginPrediction.isInLiteral(literalDelimsCount) && !StatementBeginPrediction.isInComment(ret, commentIntervals) && !StatementBeginPrediction.isInBrackets(openBracketsCount) && StatementBeginPrediction.startsWithBeginKeyWord(sqlEditorText, ret)) break;
            check.check();
        }
        return ret;
    }

    private static boolean isInLiteral(int literalDelimsCount) {
        return 1 == literalDelimsCount % 2;
    }

    private static boolean isInBrackets(int openBracketsCount) {
        return 0 < openBracketsCount;
    }

    private static int[][] calculateCommentIntervals(String sqlEditorText, ParseTerminateRequestCheck check) {
        ArrayList<int[]> ret = new ArrayList<int[]>();
        boolean inMultiLineComment = false;
        boolean inLineComment = false;
        boolean isaSlash = false;
        boolean isaStar = false;
        boolean isaMinus = false;
        int[] curComment = null;
        int literalDelimsCount = 0;
        for (int i = 0; i < sqlEditorText.length(); ++i) {
            check.check();
            if (!inLineComment && !inMultiLineComment) {
                if ('\'' == sqlEditorText.charAt(i)) {
                    ++literalDelimsCount;
                }
                if (StatementBeginPrediction.isInLiteral(literalDelimsCount)) continue;
            }
            if ('*' == sqlEditorText.charAt(i) && isaSlash && !inMultiLineComment && !inLineComment) {
                inMultiLineComment = true;
                curComment = new int[]{i - 1, -1};
            } else if ('/' == sqlEditorText.charAt(i) && isaStar && !inLineComment && inMultiLineComment) {
                inMultiLineComment = false;
                curComment[1] = i;
                ret.add(curComment);
                curComment = null;
            } else if ('-' == sqlEditorText.charAt(i) && isaMinus && !inMultiLineComment && !inLineComment) {
                inLineComment = true;
                curComment = new int[]{i - 1, -1};
            } else if ('\n' == sqlEditorText.charAt(i) && !inMultiLineComment && inLineComment) {
                inLineComment = false;
                curComment[1] = i;
                ret.add(curComment);
                curComment = null;
            }
            if ('/' == sqlEditorText.charAt(i)) {
                isaSlash = true;
                continue;
            }
            if ('*' == sqlEditorText.charAt(i)) {
                isaStar = true;
                continue;
            }
            if ('-' == sqlEditorText.charAt(i)) {
                isaMinus = true;
                continue;
            }
            isaSlash = false;
            isaStar = false;
            isaMinus = false;
        }
        if (null != curComment) {
            curComment[1] = sqlEditorText.length();
        }
        return (int[][])ret.toArray((T[])new int[ret.size()][]);
    }

    private static boolean isInComment(int ret, int[][] commentIntervals) {
        for (int i = 0; i < commentIntervals.length; ++i) {
            if (commentIntervals[i][0] > ret || ret > commentIntervals[i][1]) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWithBeginKeyWord(String sqlEditorText, int ret) {
        return StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "SELECT") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "UPDATE") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "DELETE") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "INSERT") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "ALTER") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "CREATE") || StatementBeginPrediction.startsWithIgnoreCase(sqlEditorText, ret, "DROP");
    }

    private static boolean startsWithIgnoreCase(String sqlEditorText, int ret, String keyWord) {
        int endPos;
        int beginPos = ret;
        if (ret == 0) {
            beginPos = 0;
        } else if (Character.isWhitespace(sqlEditorText.charAt(ret - 1))) {
            beginPos = ret;
        } else {
            return false;
        }
        if (sqlEditorText.length() == beginPos + keyWord.length()) {
            endPos = beginPos + keyWord.length();
        } else if (sqlEditorText.length() > beginPos + keyWord.length() && Character.isWhitespace(sqlEditorText.charAt(beginPos + keyWord.length()))) {
            endPos = beginPos + keyWord.length();
        } else {
            return false;
        }
        return keyWord.equalsIgnoreCase(sqlEditorText.substring(beginPos, endPos));
    }
}

