/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.BaseTableTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.JavabeanArrayDataSet;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.dbobj.BestRowIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.dbobj.adapter.AdapterFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RowIDTab
extends BaseTableTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RowIDTab.class);

    @Override
    public String getTitle() {
        return s_stringMgr.getString("RowIDTab.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("RowIDTab.hint");
    }

    @Override
    protected IDataSet createDataSet() throws DataSetException {
        try {
            ISQLConnection conn = this.getSession().getSQLConnection();
            SQLDatabaseMetaData md = conn.getSQLMetaData();
            ITableInfo ti = this.getTableInfo();
            BestRowIdentifier[] bris = md.getBestRowIdentifier(ti);
            return new JavabeanArrayDataSet(AdapterFactory.getInstance().createBestRowIdentifierAdapter(bris));
        }
        catch (SQLException ex) {
            throw new DataSetException(ex);
        }
    }
}

