/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLHistoryItemWrapper {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLHistoryItemWrapper.class);
    private static final String[] COLUMNS = new String[]{s_stringMgr.getString("SQLHistoryItemWrapper.index"), s_stringMgr.getString("SQLHistoryItemWrapper.lastUsed"), s_stringMgr.getString("SQLHistoryItemWrapper.aliasName"), s_stringMgr.getString("SQLHistoryItemWrapper.sql")};
    private static final SimpleDateFormat LAST_USAGE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private SQLHistoryItem _item;
    private int _index;
    private String _upperCaseSQL;
    private String _lastUsageTimeString;

    public static ArrayList<SQLHistoryItemWrapper> wrap(ArrayList<SQLHistoryItem> items) {
        ArrayList<SQLHistoryItemWrapper> ret = new ArrayList<SQLHistoryItemWrapper>(items.size());
        int i = 0;
        for (SQLHistoryItem item : items) {
            ret.add(new SQLHistoryItemWrapper(item, ++i));
        }
        return ret;
    }

    public static String[] getColumns() {
        return COLUMNS;
    }

    public static int getSQLColIx() {
        return 3;
    }

    public SQLHistoryItemWrapper(SQLHistoryItem item, int index) {
        this._item = item;
        this._index = index;
        this._upperCaseSQL = item.getSQL().toUpperCase();
        if (null != this._item.getLastUsageTime()) {
            this._lastUsageTimeString = LAST_USAGE_DATE_FORMAT.format(this._item.getLastUsageTime());
        }
    }

    public Object getColum(int column) {
        switch (column) {
            case 0: {
                return this._index;
            }
            case 1: {
                return this._lastUsageTimeString;
            }
            case 2: {
                return this._item.getAliasName();
            }
            case 3: {
                return this._item.getSQL();
            }
        }
        throw new IllegalArgumentException("Unknown colum index " + column);
    }

    public String getUpperCaseSQL() {
        return this._upperCaseSQL;
    }
}

