/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.BoundsOfSqlHandler;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.LastEditLocationHandler;
import net.sourceforge.squirrel_sql.client.session.SQLEntryPanelUtil;
import net.sourceforge.squirrel_sql.client.session.action.ViewObjectAtCursorInObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifierFactory;

public abstract class BaseSQLEntryPanel
implements ISQLEntryPanel {
    protected static final String LINE_SEPARATOR = "\n";
    protected static final String SQL_STMT_SEP = "\n\n";
    public static final IntegerIdentifierFactory ENTRY_PANEL_IDENTIFIER_FACTORY = new IntegerIdentifierFactory();
    private IIdentifier _entryPanelIdentifier;
    private TextPopupMenu _textPopupMenu;
    private IApplication _app;
    private MouseListener _sqlEntryMouseListener = new MyMouseListener();
    private BoundsOfSqlHandler _boundsOfSqlHandler;
    private LastEditLocationHandler _lastEditLocationHandler;

    protected BaseSQLEntryPanel(IApplication app) {
        this._entryPanelIdentifier = ENTRY_PANEL_IDENTIFIER_FACTORY.createIdentifier();
        this._textPopupMenu = new TextPopupMenu();
        this._app = app;
        SwingUtilities.invokeLater(() -> this.initLater());
    }

    private void initLater() {
        this.getTextComponent().addMouseListener(this._sqlEntryMouseListener);
        this._boundsOfSqlHandler = new BoundsOfSqlHandler(this.getTextComponent());
        this._lastEditLocationHandler = new LastEditLocationHandler(this.getTextComponent());
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._entryPanelIdentifier;
    }

    @Override
    public String getSQLToBeExecuted() {
        return this._boundsOfSqlHandler.getSQLToBeExecuted();
    }

    @Override
    public int[] getBoundsOfSQLToBeExecuted() {
        return this._boundsOfSqlHandler.getBoundsOfSQLToBeExecuted();
    }

    @Override
    public void moveCaretToPreviousSQLBegin() {
        int iCaretPos;
        String sql = this.getText();
        int iLastIndex = sql.lastIndexOf(SQL_STMT_SEP, iCaretPos = this.getCaretPosition() - 1);
        if (-1 == iLastIndex) {
            return;
        }
        if (-1 == (iLastIndex = sql.lastIndexOf(SQL_STMT_SEP, iLastIndex - this.getWhiteSpaceCountBackwards(iLastIndex, sql)))) {
            iLastIndex = 0;
        }
        char c = sql.charAt(iLastIndex);
        while (Character.isWhitespace(c) && iLastIndex < sql.length()) {
            c = sql.charAt(++iLastIndex);
        }
        this.setCaretPosition(iLastIndex);
    }

    private int getWhiteSpaceCountBackwards(int iStartIx, String sql) {
        int count = 0;
        while (0 < iStartIx && Character.isWhitespace(sql.charAt(iStartIx))) {
            --iStartIx;
            ++count;
        }
        return count;
    }

    @Override
    public void moveCaretToNextSQLBegin() {
        int iCaretPos;
        String sql = this.getText();
        int iNextIndex = sql.indexOf(SQL_STMT_SEP, iCaretPos = this.getCaretPosition());
        if (-1 == iNextIndex) {
            return;
        }
        while (iNextIndex < sql.length() && Character.isWhitespace(sql.charAt(iNextIndex))) {
            ++iNextIndex;
        }
        if (iNextIndex < sql.length()) {
            this.setCaretPosition(iNextIndex);
        }
    }

    @Override
    public void selectCurrentSql() {
        int[] boundsOfSQLToBeExecuted = this._boundsOfSqlHandler.getSqlBoundsBySeparatorRule(this.getCaretPosition());
        if (boundsOfSQLToBeExecuted[0] != boundsOfSQLToBeExecuted[1]) {
            this.setSelectionStart(boundsOfSQLToBeExecuted[0]);
            this.setSelectionEnd(boundsOfSQLToBeExecuted[1]);
        }
    }

    @Override
    public void addToSQLEntryAreaMenu(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Menu == null");
        }
        this._textPopupMenu.add(menu);
    }

    @Override
    public JMenuItem addToSQLEntryAreaMenu(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        return this._textPopupMenu.add(action);
    }

    @Override
    public void addSeparatorToSQLEntryAreaMenu() {
        this._textPopupMenu.addSeparator();
    }

    @Override
    public void addRedoUndoActionsToSQLEntryAreaMenu(Action undo, Action redo) {
        this._textPopupMenu.addSeparator();
        JMenuItem buf = this.addToSQLEntryAreaMenu(undo);
        this._app.getResources().configureMenuItem(undo, buf);
        buf = this.addToSQLEntryAreaMenu(redo);
        this._app.getResources().configureMenuItem(redo, buf);
        this._textPopupMenu.addSeparator();
    }

    @Override
    public boolean hasOwnUndoableManager() {
        return false;
    }

    @Override
    public IUndoHandler createUndoHandler() {
        return null;
    }

    @Override
    public void dispose() {
        this._textPopupMenu.dispose();
    }

    @Override
    public String getWordAtCursor() {
        int[] beginAndEndPos = SQLEntryPanelUtil.getWordBoundsAtCursor(this.getTextComponent(), true);
        return this.getTextComponent().getText().substring(beginAndEndPos[0], beginAndEndPos[1]).trim();
    }

    @Override
    public JScrollPane createScrollPane(JTextComponent textComponent) {
        JScrollPane sqlEntryScroller = new JScrollPane(textComponent);
        sqlEntryScroller.setBorder(BorderFactory.createEmptyBorder());
        return sqlEntryScroller;
    }

    @Override
    public void triggerParser() {
    }

    @Override
    public void goToLastEditLocation() {
        this._lastEditLocationHandler.goToLastEditLocation();
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.displayPopupMenu(evt);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.displayPopupMenu(evt);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isControlDown() && e.getClickCount() == 1) {
                final Action a = BaseSQLEntryPanel.this._app.getActionCollection().get(ViewObjectAtCursorInObjectTreeAction.class);
                GUIUtils.processOnSwingEventThread(new Runnable(){

                    @Override
                    public void run() {
                        a.actionPerformed(new ActionEvent(this, 1, "ViewObjectAtCursorInObjectTreeAction"));
                    }
                });
            }
        }

        private void displayPopupMenu(MouseEvent evt) {
            BaseSQLEntryPanel.this._textPopupMenu.setTextComponent(BaseSQLEntryPanel.this.getTextComponent());
            BaseSQLEntryPanel.this._textPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

