/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences.codereformat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPanel;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPref;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPrefReader;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.KeywordBehaviourPref;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.KeywordBehaviourPrefCtrl;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.client.util.codereformat.ColumnListSpiltMode;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class FormatSqlController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FormatSqlController.class);
    private FormatSqlPanel _formatSqlPanel;
    private FormatSqlPref _formatSqlPref;
    private IApplication _app;

    public FormatSqlController(IApplication app) {
        this._app = app;
        this._formatSqlPref = FormatSqlPrefReader.loadPref();
        this._formatSqlPanel = new FormatSqlPanel(this._formatSqlPref.getKeywordBehaviourPrefs());
        FontInfo fontInfo = app.getSquirrelPreferences().getSessionProperties().getFontInfo();
        this._formatSqlPanel.txtExampleSqls.setEditable(false);
        this._formatSqlPanel.txtExampleSqls.setFont(fontInfo.createFont());
        this._formatSqlPanel.txtIndentCount.setValue(this._formatSqlPref.getIndent());
        ActionListener adjustValuesToConstraintListeners = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatSqlController.this.adjustValuesToConstraints();
            }
        };
        this._formatSqlPanel.chkIndentSections.setSelected(this._formatSqlPref.isIndentSections());
        this._formatSqlPanel.chkIndentSections.addActionListener(adjustValuesToConstraintListeners);
        this._formatSqlPanel.radCommasAtLineBeginNo.setSelected(!this._formatSqlPref.isCommasAtLineBegin());
        this._formatSqlPanel.radCommasAtLineBeginNo.addActionListener(adjustValuesToConstraintListeners);
        this._formatSqlPanel.radCommasAtLineBeginYes.setSelected(this._formatSqlPref.isCommasAtLineBegin());
        this._formatSqlPanel.radCommasAtLineBeginYes.addActionListener(adjustValuesToConstraintListeners);
        this._formatSqlPanel.txtIndentCount.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FormatSqlController.this.refreshExampleSql(FormatSqlController.this.createFormatSqlPrefFromGui());
            }
        });
        this._formatSqlPanel.txtPreferedLineLength.setValue(this._formatSqlPref.getPreferedLineLength());
        this._formatSqlPanel.txtPreferedLineLength.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FormatSqlController.this.refreshExampleSql(FormatSqlController.this.createFormatSqlPrefFromGui());
            }
        });
        for (KeywordBehaviourPrefCtrl keywordBehaviourPrefCtrl : this._formatSqlPanel.keywordBehaviourPrefCtrls) {
            keywordBehaviourPrefCtrl.addKeyWordBehaviourChangedListener(adjustValuesToConstraintListeners);
        }
        this._formatSqlPanel.chkDoInsertValuesAlign.setSelected(this._formatSqlPref.isDoInsertValuesAlign());
        this._formatSqlPanel.chkDoInsertValuesAlign.addActionListener(adjustValuesToConstraintListeners);
        this._formatSqlPanel._cboColumnListSplitMode.setModel(new DefaultComboBoxModel<ColumnListSpiltMode>(ColumnListSpiltMode.values()));
        this._formatSqlPanel._cboColumnListSplitMode.setSelectedItem((Object)ColumnListSpiltMode.valueOf(this._formatSqlPref.getColumnListSplitMode()));
        this._formatSqlPanel._cboColumnListSplitMode.addActionListener(adjustValuesToConstraintListeners);
        this._formatSqlPanel._chkLineBreakFor_AND_OR_in_FROM_clause.setSelected(this._formatSqlPref.isLineBreakFor_AND_OR_in_FROM_clause());
        this._formatSqlPanel._chkLineBreakFor_AND_OR_in_FROM_clause.addActionListener(adjustValuesToConstraintListeners);
        this.adjustValuesToConstraints();
    }

    private void adjustValuesToConstraints() {
        KeywordBehaviourPrefCtrl andCtrl = null;
        KeywordBehaviourPrefCtrl orCtrl = null;
        for (KeywordBehaviourPrefCtrl keywordBehaviourPrefCtrl : this._formatSqlPanel.keywordBehaviourPrefCtrls) {
            String keyWord = keywordBehaviourPrefCtrl.getKeywordBehaviourPref().getKeyWord();
            if ("INSERT".equals(keyWord)) {
                if (this._formatSqlPanel.chkDoInsertValuesAlign.isSelected()) {
                    keywordBehaviourPrefCtrl.setBehaviour(FormatSqlPanel.KeywordBehaviour.START_NEW_LINE);
                    keywordBehaviourPrefCtrl.setEnabled(false);
                    continue;
                }
                keywordBehaviourPrefCtrl.setEnabled(true);
                continue;
            }
            if ("VALUES".equals(keyWord)) {
                if (this._formatSqlPanel.chkDoInsertValuesAlign.isSelected()) {
                    keywordBehaviourPrefCtrl.setBehaviour(FormatSqlPanel.KeywordBehaviour.NO_INFLUENCE_ON_NEW_LINE);
                    keywordBehaviourPrefCtrl.setEnabled(false);
                    continue;
                }
                keywordBehaviourPrefCtrl.setEnabled(true);
                continue;
            }
            if ("AND".equals(keyWord)) {
                andCtrl = keywordBehaviourPrefCtrl;
                continue;
            }
            if (!"OR".equals(keyWord)) continue;
            orCtrl = keywordBehaviourPrefCtrl;
        }
        if (FormatSqlPanel.KeywordBehaviour.START_NEW_LINE == andCtrl.getSelectedKeywordBehaviour() || FormatSqlPanel.KeywordBehaviour.START_NEW_LINE == orCtrl.getSelectedKeywordBehaviour()) {
            this._formatSqlPanel._chkLineBreakFor_AND_OR_in_FROM_clause.setEnabled(true);
        } else {
            this._formatSqlPanel._chkLineBreakFor_AND_OR_in_FROM_clause.setEnabled(false);
        }
        this.refreshExampleSql(this.createFormatSqlPrefFromGui());
    }

    private void refreshExampleSql(FormatSqlPref formatSqlPref) {
        CodeReformator codeReformator = new CodeReformator(CodeReformatorConfigFactory.createConfig(formatSqlPref));
        String sqls = codeReformator.reformat("SELECT table1.id,table2.number,table2.name,table2.info1,table2.info2,table2.info3,table2.info4,table2.info5,table2.info6,SUM(table1.amount) FROM table1 INNER JOIN table2 ON table.id1 = table2.table1_id1 AND table.id2 = table2.table1_id2 LEFT OUTER JOIN table3 ON table.id1 = table3.table1_id1 AND table.id2 = table3.table1_id3 WHERE table1.id IN (SELECT table1_id FROM table3 WHERE table3.name = 'Foo Bar' and table3.type = 'unknown_type') AND table2.name LIKE '%g%' GROUP BY table1.id,table2.number ORDER BY table1.id");
        sqls = sqls + "\n\n";
        sqls = sqls + codeReformator.reformat("UPDATE table1 SET name = 'Hello', number = '1456-789' WHERE id = 42");
        sqls = sqls + "\n\n";
        sqls = sqls + codeReformator.reformat("INSERT INTO table1 (name, number) SELECT name,number FROM table1_bak");
        sqls = sqls + "\n\n";
        sqls = sqls + codeReformator.reformat("INSERT INTO table1 (name,number,type) VALUES ('Foo',42,'VA')");
        sqls = sqls + "\n\n";
        sqls = sqls + codeReformator.reformat("DELETE FROM table1 WHERE  name = 'Hello' OR number = '1456-789'");
        this._formatSqlPanel.txtExampleSqls.setText(sqls);
    }

    public void applyChanges() {
        try {
            this._formatSqlPref = this.createFormatSqlPrefFromGui();
            XMLBeanWriter bw = new XMLBeanWriter(this._formatSqlPref);
            bw.save(FormatSqlPrefReader.getPrefsFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FormatSqlPref createFormatSqlPrefFromGui() {
        FormatSqlPref ret = new FormatSqlPref();
        if (null != this._formatSqlPanel.txtIndentCount.getText()) {
            try {
                Integer indent = Integer.valueOf(this._formatSqlPanel.txtIndentCount.getText());
                if (indent >= 0) {
                    ret.setIndent(indent);
                }
            }
            catch (NumberFormatException indent) {
                // empty catch block
            }
        }
        if (null != this._formatSqlPanel.txtPreferedLineLength.getText()) {
            try {
                Integer preferedLineLength = Integer.valueOf(this._formatSqlPanel.txtPreferedLineLength.getText());
                if (preferedLineLength >= 0) {
                    ret.setPreferedLineLength(preferedLineLength);
                }
            }
            catch (NumberFormatException preferedLineLength) {
                // empty catch block
            }
        }
        ret.setIndentSections(this._formatSqlPanel.chkIndentSections.isSelected());
        ret.setCommasAtLineBegin(this._formatSqlPanel.radCommasAtLineBeginYes.isSelected());
        ArrayList<KeywordBehaviourPref> buf = new ArrayList<KeywordBehaviourPref>();
        for (KeywordBehaviourPrefCtrl keywordBehaviourPrefCtrl : this._formatSqlPanel.keywordBehaviourPrefCtrls) {
            keywordBehaviourPrefCtrl.applyChanges();
            buf.add(keywordBehaviourPrefCtrl.getKeywordBehaviourPref());
        }
        ret.setKeywordBehaviourPrefs(buf.toArray(new KeywordBehaviourPref[buf.size()]));
        ret.setDoInsertValuesAlign(this._formatSqlPanel.chkDoInsertValuesAlign.isSelected());
        ColumnListSpiltMode selMode = (ColumnListSpiltMode)((Object)this._formatSqlPanel._cboColumnListSplitMode.getSelectedItem());
        ret.setColumnListSplitMode(selMode.name());
        ret.setLineBreakFor_AND_OR_in_FROM_clause(this._formatSqlPanel._chkLineBreakFor_AND_OR_in_FROM_clause.isSelected());
        return ret;
    }

    public FormatSqlPanel getPanel() {
        return this._formatSqlPanel;
    }
}

