/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public enum SquirrelBatchOptions {
    ALIAS(new Option("alias", true, "SQuirreL Alias to connect to")),
    PASSWORD(new Option("password", true, "Connection password")),
    USER(new Option("user", true, "Connection password")),
    URL(new Option("url", true, "JDBC URL")),
    DRIVER(new Option("driver", true, "JDBC driver class name")),
    DRIVERCP(new Option("drivercp", true, "JDBC driver class path (a Java classpath)")),
    SQL(new Option("sql", true, "SQL statement or SQL script file")),
    MAX_ROWS(new Option("maxrows", true, "Max rows of SQL query. 0 means no maximum. For default see SQuirreL GUI -> New Session Properties -> tab SQL")),
    USERDIR(new Option("userdir", true, "The user directory of your SQuirreL installation. Needed only if a non standard user directory is used.")),
    HELP(new Option("help", false, "Print help"));

    private Option _option;

    private SquirrelBatchOptions(Option option) {
        this._option = option;
    }

    public static Options getOptions() {
        Options options = new Options();
        for (SquirrelBatchOptions squirrelBatchOption : SquirrelBatchOptions.values()) {
            options.addOption(squirrelBatchOption._option);
        }
        return options;
    }

    public static String isValid(CommandLine commandLine) {
        if (!commandLine.hasOption(SquirrelBatchOptions.SQL._option.getOpt())) {
            return "Missing parameter " + SquirrelBatchOptions.SQL._option.getOpt();
        }
        if (commandLine.hasOption(SquirrelBatchOptions.ALIAS._option.getOpt()) && commandLine.hasOption(SquirrelBatchOptions.URL._option.getOpt())) {
            return "Only one of the parameters " + SquirrelBatchOptions.ALIAS._option.getOpt() + ", " + SquirrelBatchOptions.URL._option.getOpt() + " is allowed";
        }
        if (!commandLine.hasOption(SquirrelBatchOptions.ALIAS._option.getOpt())) {
            if (commandLine.hasOption(SquirrelBatchOptions.URL._option.getOpt())) {
                if (!commandLine.hasOption(SquirrelBatchOptions.DRIVER._option.getOpt())) {
                    return "Missing parameter " + SquirrelBatchOptions.DRIVER._option.getOpt();
                }
                if (!commandLine.hasOption(SquirrelBatchOptions.DRIVERCP._option.getOpt())) {
                    return "Missing parameter " + SquirrelBatchOptions.DRIVERCP._option.getOpt();
                }
                if (!commandLine.hasOption(SquirrelBatchOptions.USER._option.getOpt())) {
                    return "Missing parameter " + SquirrelBatchOptions.USER._option.getOpt();
                }
            } else {
                return "One of the parameters " + SquirrelBatchOptions.ALIAS._option.getOpt() + ", " + SquirrelBatchOptions.URL._option.getOpt() + " must be passed";
            }
        }
        if (commandLine.hasOption(SquirrelBatchOptions.MAX_ROWS._option.getOpt())) {
            try {
                Integer.parseInt(commandLine.getOptionValue(SquirrelBatchOptions.MAX_ROWS._option.getOpt()));
            }
            catch (NumberFormatException e) {
                return SquirrelBatchOptions.MAX_ROWS._option.getOpt() + " must be an integer";
            }
        }
        return null;
    }

    public String getValue(CommandLine commandLine) {
        return commandLine.getOptionValue(this._option.getOpt());
    }

    public boolean hasParam(CommandLine commandLine) {
        return commandLine.hasOption(this._option.getOpt());
    }
}

