/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptDecrypt {
    private Cipher cipher;
    private int iterations;
    private String keyAlgorithmName;
    private String cipherAlgorithmName;
    private int keyLength;
    private String paddingAlgorithm;
    private String password;
    public static final String KEY_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final String CIPHER_ALGORITHM = "AES";
    public static final int ITERATIONS = 65536;
    public static final int KEY_LENGTH = 128;
    public static final String PADDING_ALGORITHM = "AES/CBC/PKCS5Padding";

    public EncryptDecrypt(String string) {
        this.password = string;
        this.keyAlgorithmName = KEY_ALGORITHM;
        this.cipherAlgorithmName = CIPHER_ALGORITHM;
        this.iterations = 65536;
        this.keyLength = 128;
        this.paddingAlgorithm = PADDING_ALGORITHM;
    }

    public EncryptDecrypt(String string, String string2, String string3, int n, int n2, String string4) {
        this.password = string;
        this.keyAlgorithmName = string2;
        this.cipherAlgorithmName = string3;
        this.iterations = n;
        this.keyLength = n2;
        this.paddingAlgorithm = string4;
    }

    public SecretKey generateKey(byte[] byArray) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.keyAlgorithmName);
        PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password.toCharArray(), byArray, this.iterations, this.keyLength);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKeyFactory.generateSecret(pBEKeySpec).getEncoded(), this.cipherAlgorithmName);
        this.cipher = Cipher.getInstance(this.paddingAlgorithm);
        return secretKeySpec;
    }

    public byte[] generateSalt() throws NoSuchAlgorithmException {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public OutputStream getEncryptStream(OutputStream outputStream) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidParameterSpecException, IOException, InvalidKeyException {
        byte[] byArray = this.generateSalt();
        SecretKey secretKey = this.generateKey(byArray);
        this.cipher.init(1, secretKey);
        outputStream.write(byArray, 0, 8);
        byte[] byArray2 = this.cipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV();
        outputStream.write(byArray2, 0, 16);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, this.cipher);
        return cipherOutputStream;
    }

    public InputStream getDecryptStream(InputStream inputStream) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray = new byte[8];
        inputStream.read(byArray, 0, 8);
        byte[] byArray2 = new byte[16];
        inputStream.read(byArray2, 0, 16);
        SecretKey secretKey = this.generateKey(byArray);
        this.cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray2));
        CipherInputStream cipherInputStream = null;
        cipherInputStream = new CipherInputStream(inputStream, this.cipher);
        return cipherInputStream;
    }

    public void encrypt(InputStream inputStream, OutputStream outputStream) throws IOException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException {
        byte[] byArray = new byte[1024];
        OutputStream outputStream2 = this.getEncryptStream(outputStream);
        int n = 0;
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream2.write(byArray, 0, n);
        }
        outputStream2.close();
    }

    public void decrypt(InputStream inputStream, OutputStream outputStream) throws IOException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        byte[] byArray = new byte[1024];
        InputStream inputStream2 = this.getDecryptStream(inputStream);
        int n = 0;
        while ((n = inputStream2.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
    }
}

