/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceField;
import unity.annotation.SourceView;
import unity.engine.Attribute;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityPreparedStatement;
import unity.jdbc.UnityResultSet;
import unity.jdbc.UnityStatement;
import unity.query.GQFieldRef;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.query.LQCreateViewNode;
import unity.query.LQUpdateNode;
import unity.query.LocalQuery;
import unity.query.Optimizer;
import unity.query.QueryThread;
import unity.util.StringFunc;

public class Evaluator {
    protected GlobalQuery globalQuery;
    private GlobalUpdate globalUpdate;

    public Evaluator(GlobalQuery globalQuery) {
        this.globalQuery = globalQuery;
    }

    public Evaluator(GlobalUpdate globalUpdate) {
        this.globalUpdate = globalUpdate;
    }

    public UnityResultSet execute(UnityStatement unityStatement, UnityConnection unityConnection, int n, int n2, int n3, int n4) throws SQLException {
        Object object;
        ArrayList<LocalQuery> arrayList = this.globalQuery.getLocalQueries();
        int n5 = arrayList.size();
        if (n5 > 1) {
            Evaluator.executeLocalQueries(arrayList, this.globalQuery);
        } else if (n5 == 1) {
            object = arrayList.get(0);
            ((LocalQuery)object).setResultSetType(n);
            ((LocalQuery)object).setResultSetConcurrency(n2);
            ((LocalQuery)object).execute(unityConnection);
        }
        object = new UnityResultSet(unityStatement, this.globalQuery, n);
        return object;
    }

    public static void executeLocalQuery(LocalQuery localQuery, GlobalQuery globalQuery) {
        QueryThread queryThread = new QueryThread(localQuery, globalQuery);
        Thread thread = new Thread(queryThread);
        thread.start();
    }

    public static void executeLocalQueries(ArrayList<LocalQuery> arrayList, GlobalQuery globalQuery) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Evaluator.executeLocalQuery(arrayList.get(i), globalQuery);
        }
    }

    public int executeUpdate(UnityConnection unityConnection, UnityStatement unityStatement) throws SQLException {
        if (this.globalUpdate.getType() == 50) {
            return this.executeCreateViewMultiDB(unityConnection, unityStatement);
        }
        if (!this.globalUpdate.hasGlobalSubQuery()) {
            if (this.globalUpdate.getDatabase() == null) {
                throw new SQLException(UnityDriver.i18n.getString("Evaluator.NoUpdate"));
            }
            if (unityStatement instanceof UnityPreparedStatement && ((UnityPreparedStatement)unityStatement).isHasBlob()) {
                return this.executePreparedStatement(unityConnection, unityStatement);
            }
            Connection connection = unityConnection.getConnection(this.globalUpdate.getDatabase().getDatabaseName());
            Statement statement = connection.createStatement();
            String string = this.globalUpdate.getSqlStmt();
            if (UnityDriver.DEBUG) {
                System.out.println(string);
            }
            int n = statement.executeUpdate(string);
            return n;
        }
        if (this.globalUpdate.getType() == 22) {
            return this.executeInsertMultiDB(unityConnection, unityStatement);
        }
        if (this.globalUpdate.getType() == 20) {
            return this.executeDeleteMultiDB(unityConnection, unityStatement);
        }
        if (this.globalUpdate.getType() == 21) {
            return this.executeUpdateMultiDB(unityConnection, unityStatement);
        }
        throw new SQLException(UnityDriver.i18n.getString("Evaluator.NoSupport"));
    }

    private int executeCreateViewMultiDB(UnityConnection unityConnection, UnityStatement unityStatement) throws SQLException {
        LQCreateViewNode lQCreateViewNode;
        String string;
        LocalQuery localQuery;
        Object object;
        GlobalQuery globalQuery = this.globalUpdate.getSubQuery();
        try {
            object = globalQuery.getLocalQueries();
            localQuery = ((ArrayList)object).get(0);
            localQuery.execute(unityConnection);
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("Evaluator.CreateViewError") + exception);
        }
        object = unityConnection.getGlobalSchema();
        AnnotatedSourceDatabase annotatedSourceDatabase = ((GlobalSchema)object).getDB("unity");
        if (annotatedSourceDatabase == null) {
            annotatedSourceDatabase = new AnnotatedSourceDatabase("unity", "unity", "UnityJDBC", UnityDriver.getVersion(), "", "", '\"');
            ((GlobalSchema)object).addDatabase(annotatedSourceDatabase);
        }
        if (annotatedSourceDatabase.getTable(string = (lQCreateViewNode = (LQCreateViewNode)this.globalUpdate.getPlan().getLogicalQueryTree().getRoot()).getViewName()) != null) {
            throw new SQLException(UnityDriver.i18n.getString("Evaluator.ViewsExists") + string);
        }
        HashMap<String, SourceField> hashMap = new HashMap<String, SourceField>();
        int n = this.globalUpdate.getStatement().toLowerCase().indexOf("as");
        String string2 = this.globalUpdate.getStatement().substring(n + 2);
        ArrayList<GQFieldRef> arrayList = lQCreateViewNode.getViewFields();
        SourceView sourceView = new SourceView(null, "unity", string, "", hashMap, string2);
        ResultSet resultSet = localQuery.getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n2 = resultSetMetaData.isNullable(i);
            String string3 = "NO";
            if (n2 == 1) {
                string3 = "YES";
            } else if (n2 > 1) {
                string3 = "";
            }
            String string4 = arrayList.get(i - 1).getName();
            AnnotatedSourceField annotatedSourceField = new AnnotatedSourceField(null, "unity", string, string4, resultSetMetaData.getColumnType(i), resultSetMetaData.getColumnTypeName(i), resultSetMetaData.getColumnDisplaySize(i), resultSetMetaData.getScale(i), resultSetMetaData.getPrecision(i), resultSetMetaData.isNullable(i), "", null, 0, i, string3);
            sourceView.addField(annotatedSourceField);
            annotatedSourceField.setParentTable(sourceView);
        }
        sourceView.setParentDatabase(annotatedSourceDatabase);
        annotatedSourceDatabase.addTable(sourceView);
        ((GlobalSchema)object).addTableIdentifiers(sourceView);
        return 0;
    }

    private int executePreparedStatement(UnityConnection unityConnection, UnityStatement unityStatement) throws SQLException {
        int n;
        Connection connection = unityConnection.getConnection(this.globalUpdate.getDatabase().getDatabaseName());
        String string = this.globalUpdate.getSqlStmt();
        string = string.replaceAll("'!!BLOB!!'", "?");
        UnityPreparedStatement unityPreparedStatement = (UnityPreparedStatement)unityStatement;
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ArrayList<UnityPreparedStatement.Parameter> arrayList = unityPreparedStatement.getParameters();
        int n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            UnityPreparedStatement.Parameter parameter = arrayList.get(n);
            int n3 = parameter.getType();
            if (!Attribute.isStreamType(n3)) continue;
            ++n2;
            long l = parameter.getLength();
            if (n3 == -3) {
                if (l == 0L) {
                    preparedStatement.setBinaryStream(n2, (InputStream)parameter.getObjValue());
                    continue;
                }
                preparedStatement.setBinaryStream(n2, (InputStream)parameter.getObjValue(), l);
                continue;
            }
            if (n3 == 2004) {
                if (l == 0L) {
                    preparedStatement.setBlob(n2, (InputStream)parameter.getObjValue());
                    continue;
                }
                preparedStatement.setBlob(n2, (InputStream)parameter.getObjValue(), l);
                continue;
            }
            if (n3 == 2005) {
                if (l == 0L) {
                    preparedStatement.setClob(n2, (Reader)parameter.getObjValue());
                    continue;
                }
                preparedStatement.setClob(n2, (Reader)parameter.getObjValue(), l);
                continue;
            }
            if (n3 != -1) continue;
            if (l == 0L) {
                preparedStatement.setCharacterStream(n2, (Reader)parameter.getObjValue());
                continue;
            }
            preparedStatement.setCharacterStream(n2, (Reader)parameter.getObjValue(), l);
        }
        n = preparedStatement.executeUpdate();
        return n;
    }

    private int executeInsertMultiDB(UnityConnection unityConnection, UnityStatement unityStatement) throws SQLException {
        GlobalQuery globalQuery = this.globalUpdate.getSubQuery();
        Optimizer optimizer = new Optimizer(globalQuery, false, unityStatement);
        globalQuery = optimizer.optimize();
        Evaluator evaluator = new Evaluator(globalQuery);
        globalQuery.setConnection(unityConnection);
        UnityResultSet unityResultSet = evaluator.execute(unityStatement, unityConnection, 1003, 1007, 0, Integer.MAX_VALUE);
        ResultSetMetaData resultSetMetaData = unityResultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        Connection connection = null;
        int n2 = 0;
        try {
            connection = unityConnection.getConnection(this.globalUpdate.getDatabase().getDatabaseName());
            Statement statement = connection.createStatement();
            connection.setAutoCommit(false);
            String string = this.globalUpdate.generateBaseSQL() + " VALUES (";
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append(string);
            int n3 = string.length();
            while (unityResultSet.next()) {
                stringBuffer.setLength(n3);
                Object object = unityResultSet.getObject(1);
                stringBuffer.append(StringFunc.formatSQLValue(object));
                for (int i = 2; i <= n; ++i) {
                    object = unityResultSet.getObject(i);
                    stringBuffer.append(", ");
                    stringBuffer.append(StringFunc.formatSQLValue(object));
                }
                stringBuffer.append(')');
                if (UnityDriver.DEBUG) {
                    System.out.println("Executing: " + stringBuffer.toString());
                }
                n2 += statement.executeUpdate(stringBuffer.toString());
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            if (connection != null) {
                connection.rollback();
            }
            throw new SQLException(sQLException.toString());
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(true);
            }
        }
        return n2;
    }

    private int executeDeleteMultiDB(UnityConnection unityConnection, UnityStatement unityStatement) throws SQLException {
        StringBuffer stringBuffer;
        Statement statement;
        GlobalQuery globalQuery = this.globalUpdate.getSubQuery();
        Optimizer optimizer = new Optimizer(globalQuery, false, unityStatement);
        globalQuery = optimizer.optimize();
        Evaluator evaluator = new Evaluator(globalQuery);
        globalQuery.setConnection(unityConnection);
        UnityResultSet unityResultSet = evaluator.execute(unityStatement, unityConnection, 1003, 1007, 0, Integer.MAX_VALUE);
        Connection connection = null;
        int n = 0;
        try {
            Object object;
            connection = unityConnection.getConnection(this.globalUpdate.getDatabase().getDatabaseName());
            statement = connection.createStatement();
            connection.setAutoCommit(false);
            String string = this.globalUpdate.generateBaseSQL() + " WHERE ";
            string = string + this.globalUpdate.generateConditionSQL();
            stringBuffer = new StringBuffer(20000);
            stringBuffer.append(string);
            if (unityResultSet.next()) {
                object = unityResultSet.getObject(1);
                stringBuffer.append(StringFunc.formatSQLValue(object));
            }
            while (unityResultSet.next()) {
                stringBuffer.append(", ");
                object = unityResultSet.getObject(1);
                stringBuffer.append(StringFunc.formatSQLValue(object));
            }
            stringBuffer.append(')');
            if (UnityDriver.DEBUG) {
                System.out.println("Executing: " + stringBuffer.toString());
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            if (connection != null) {
                connection.rollback();
            }
            throw new SQLException(sQLException.toString());
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(true);
            }
        }
        return n += statement.executeUpdate(stringBuffer.toString());
    }

    private int executeUpdateMultiDB(UnityConnection unityConnection, UnityStatement unityStatement) throws SQLException {
        GlobalQuery globalQuery = this.globalUpdate.getSubQuery();
        Optimizer optimizer = new Optimizer(globalQuery, false, unityStatement);
        globalQuery = optimizer.optimize();
        Evaluator evaluator = new Evaluator(globalQuery);
        globalQuery.setConnection(unityConnection);
        globalQuery.setQueryString(globalQuery.getQueryString());
        UnityResultSet unityResultSet = evaluator.execute(unityStatement, unityConnection, 1003, 1007, 0, Integer.MAX_VALUE);
        ResultSetMetaData resultSetMetaData = unityResultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        LQUpdateNode lQUpdateNode = (LQUpdateNode)this.globalUpdate.getPlan().getLogicalQueryTree().getRoot();
        Connection connection = null;
        int n2 = 0;
        try {
            connection = unityConnection.getConnection(this.globalUpdate.getDatabase().getDatabaseName());
            Statement statement = connection.createStatement();
            connection.setAutoCommit(false);
            String string = this.globalUpdate.generateBaseSQL();
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append(string);
            int n3 = string.length();
            int n4 = lQUpdateNode.getPKFields();
            while (unityResultSet.next()) {
                Object object;
                int n5;
                stringBuffer.setLength(n3);
                for (n5 = lQUpdateNode.getPKFields() + 1; n5 <= n; ++n5) {
                    object = unityResultSet.getObject(n5);
                    if (n5 != lQUpdateNode.getPKFields() + 1) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(lQUpdateNode.getField(n5 - 1 - n4) + "=" + StringFunc.formatSQLValue(object));
                }
                stringBuffer.append(" WHERE ");
                for (n5 = 1; n5 <= lQUpdateNode.getPKFields(); ++n5) {
                    object = unityResultSet.getObject(n5);
                    if (n5 != 1) {
                        stringBuffer.append(" AND ");
                    }
                    stringBuffer.append(lQUpdateNode.getPKField(n5 - 1) + "=" + StringFunc.formatSQLValue(object));
                }
                if (UnityDriver.DEBUG) {
                    System.out.println("Executing: " + stringBuffer.toString());
                }
                n2 += statement.executeUpdate(stringBuffer.toString());
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            if (connection != null) {
                connection.rollback();
            }
            throw new SQLException(sQLException.toString());
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(true);
            }
        }
        return n2;
    }
}

