/*
 * Decompiled with CFR 0.152.
 */
package unity.parser;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.jdbc.UnityDriver;
import unity.parser.PTreeBuilderValidater;
import unity.parser.SimpleNode;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.util.StringFunc;

public class GlobalParser {
    private PTreeBuilderValidater ptbv;
    private SimpleNode parseTreeRoot;
    private boolean localExecution = false;
    private boolean schemaValidation = true;

    public GlobalParser(boolean bl, boolean bl2) {
        this.localExecution = bl;
        this.schemaValidation = bl2;
    }

    public GlobalQuery parse(String string, GlobalSchema globalSchema) throws SQLException {
        Serializable serializable;
        if (this.schemaValidation) {
            this.ptbv = new PTreeBuilderValidater(globalSchema, this.schemaValidation);
        } else {
            ArrayList<SourceDatabase> arrayList;
            serializable = null;
            if (globalSchema != null && (arrayList = globalSchema.getAnnotatedDatabases()) != null && arrayList.size() > 0) {
                serializable = arrayList.get(0);
            }
            this.ptbv = new PTreeBuilderValidater(globalSchema, this.schemaValidation, (AnnotatedSourceDatabase)serializable);
        }
        this.parseTreeRoot = this.ptbv.buildPTree(string);
        if (UnityDriver.DEBUG) {
            this.parseTreeRoot.dump("");
        }
        serializable = this.ptbv.buildLQTree(this.parseTreeRoot, this.localExecution);
        ((GlobalQuery)serializable).setQueryString(string);
        return serializable;
    }

    public GlobalUpdate parseUpdate(String string, GlobalSchema globalSchema) throws SQLException {
        this.ptbv = new PTreeBuilderValidater(globalSchema, this.schemaValidation);
        this.parseTreeRoot = this.ptbv.buildPTree(string);
        GlobalUpdate globalUpdate = this.ptbv.validateUpdate(this.parseTreeRoot);
        return globalUpdate;
    }

    public static void printParseTree(SimpleNode simpleNode, int n) {
        System.out.println(StringFunc.spaces(n * 4) + simpleNode.toString());
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            GlobalParser.printParseTree(simpleNode2, n + 1);
        }
    }

    public SimpleNode testParser(String string, GlobalSchema globalSchema) throws SQLException {
        this.ptbv = new PTreeBuilderValidater(globalSchema, this.schemaValidation);
        this.parseTreeRoot = this.ptbv.buildPTree(string);
        return this.parseTreeRoot;
    }
}

