/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import unity.engine.Tuple;
import unity.operators.Operator;

public class Limit
extends Operator {
    private static final long serialVersionUID = 1L;
    private int start;
    private int count;
    private int rowNum;

    public Limit(Operator operator, int n, int n2) {
        super(new Operator[]{operator}, 0L);
        this.setOutputRelation(operator.getOutputRelation());
        this.start = n;
        this.count = n2;
    }

    @Override
    public void init() throws SQLException {
        this.input[0].init();
        Tuple tuple = new Tuple();
        this.rowNum = 1;
        while (this.rowNum <= this.start && this.input[0].next(tuple)) {
            ++this.rowNum;
        }
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        if (this.rowNum > this.start + this.count) {
            return false;
        }
        if (!this.input[0].next(tuple)) {
            return false;
        }
        ++this.rowNum;
        this.incrementRowsOut();
        return true;
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }

    public String toString() {
        String string = "LIMIT " + this.count;
        if (this.start != 0 && this.start != Integer.MAX_VALUE) {
            string = string + " OFFSET " + this.start;
        }
        return string;
    }

    @Override
    public String getName() {
        return "LIMIT";
    }

    @Override
    public String getDescription() {
        return this.toString();
    }
}

