/*
 * Decompiled with CFR 0.152.
 */
package unity.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Scanner;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import unity.jdbc.UnityDriver;
import unity.util.EncryptDecrypt;

public class FileManager {
    private static String TEMPORARY_PATH = null;

    public static BufferedReader openTextInputFile(String string) throws FileNotFoundException {
        return new BufferedReader(new FileReader(string));
    }

    public static PrintWriter openTextOutputFile(String string) throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(string)));
    }

    public static BufferedInputStream openInputFile(String string) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(string));
    }

    public static BufferedOutputStream openOutputFile(String string) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(string));
    }

    public static void closeFile(BufferedReader bufferedReader) throws IOException {
        bufferedReader.close();
    }

    public static void closeFile(PrintWriter printWriter) throws IOException {
        printWriter.close();
    }

    public static void closeFile(BufferedInputStream bufferedInputStream) throws IOException {
        bufferedInputStream.close();
    }

    public static void closeStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeFile(BufferedOutputStream bufferedOutputStream) throws IOException {
        bufferedOutputStream.close();
    }

    public static String getFileName(String string) {
        int n = (string = FileManager.correctFileSeparator(string)).lastIndexOf(File.separatorChar);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getPath(String string) {
        int n = (string = FileManager.correctFileSeparator(string)).lastIndexOf(File.separator);
        if (n == -1) {
            n = string.lastIndexOf("/");
            if (n == -1) {
                return "";
            }
            return string.substring(0, n);
        }
        return string.substring(0, n);
    }

    public static String getPathNoCorrect(String string) {
        System.out.println("INput path name: " + string);
        int n = string.lastIndexOf(File.separator);
        if (n == -1) {
            n = string.lastIndexOf("/");
            if (n == -1) {
                return "";
            }
            return string.substring(0, n);
        }
        return string.substring(0, n);
    }

    public static String createTempFileName(String string) {
        long l = System.currentTimeMillis();
        return TEMPORARY_PATH + string + "_" + l + ".dat";
    }

    public static String getTemporaryPath() throws IOException {
        if (TEMPORARY_PATH != null) {
            return TEMPORARY_PATH;
        }
        File file = null;
        file = File.createTempFile("unityjdbc", "");
        String string = file.getParent();
        file.delete();
        file = new File(string);
        if (file.mkdirs()) {
            file.deleteOnExit();
        }
        string = file.getPath() + File.separatorChar + "unityjdbc" + File.separatorChar;
        File file2 = new File(string);
        file2.mkdir();
        return string;
    }

    public static boolean deleteDirectory(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = FileManager.deleteDirectory(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static void deleteFile(String string) {
        File file = new File(string);
        file.delete();
    }

    public static String getXMLFile(String string, ClassLoader classLoader) throws IOException {
        String string2 = string;
        if (string2.toLowerCase().indexOf("jdbc:unity://") == 0) {
            string2 = string2.substring(13);
        }
        if (new File(string2).exists() || string2.indexOf("http") >= 0) {
            return string2;
        }
        String string3 = null;
        URL uRL = FileManager.JarFind(string2, classLoader);
        string3 = uRL.toString().replaceAll("%20", " ");
        return string3;
    }

    public static InputStream getStream(String string) throws IOException {
        InputStream inputStream = null;
        String string2 = string;
        if (string2.indexOf("jar") >= 0) {
            String string3 = string2.substring(9, string2.indexOf("!"));
            String string4 = string2.substring(string2.indexOf("!") + 2);
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(string3);
            }
            catch (Exception exception) {
                string3 = FileManager.getXMLFile(string3, UnityDriver.classLoader);
                jarFile = new JarFile(string3);
            }
            ZipEntry zipEntry = jarFile.getEntry(string4);
            inputStream = jarFile.getInputStream(zipEntry);
        } else if (string2.indexOf("http") >= 0) {
            String string5 = string2.substring(string2.indexOf("http"));
            URL uRL = new URL(string5);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
        } else {
            string2 = FileManager.correctFileSeparator(string2);
            try {
                if (string2.indexOf("file:") >= 0) {
                    string2 = string2.substring(string2.indexOf("file:"));
                    int n = string2.indexOf("file:") + 5;
                    string2 = string2.substring(n);
                }
                inputStream = new FileInputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("Input file not found: " + string2);
            }
        }
        return inputStream;
    }

    public static InputStream getDecryptedStream(String string, String string2, String string3, String string4, int n, int n2, String string5) throws IOException {
        InputStream inputStream = FileManager.getStream(string);
        EncryptDecrypt encryptDecrypt = new EncryptDecrypt(string2, string3, string4, n, n2, string5);
        try {
            InputStream inputStream2 = encryptDecrypt.getDecryptStream(inputStream);
            return inputStream2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static InputStream getDecryptedStream(String string, String string2, Properties properties) throws IOException {
        InputStream inputStream = FileManager.getStream(string);
        String string3 = "PBKDF2WithHmacSHA1";
        String string4 = "AES";
        int n = 65536;
        int n2 = 128;
        String string5 = "AES/CBC/PKCS5Padding";
        if (properties != null) {
            if (properties.containsKey("keyenc")) {
                string3 = properties.getProperty("keyenc");
            }
            if (properties.containsKey("cipher")) {
                string4 = properties.getProperty("cipher");
            }
            if (properties.containsKey("padding")) {
                string5 = properties.getProperty("padding");
            }
            try {
                if (properties.containsKey("keylen")) {
                    n2 = Integer.parseInt(properties.getProperty("keylen"));
                }
                if (properties.containsKey("iterations")) {
                    n = Integer.parseInt(properties.getProperty("iterations"));
                }
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        EncryptDecrypt encryptDecrypt = new EncryptDecrypt(string2, string3, string4, n, n2, string5);
        try {
            InputStream inputStream2 = encryptDecrypt.getDecryptStream(inputStream);
            return inputStream2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static InputStream getDecryptedStream(InputStream inputStream, String string, String string2, String string3, int n, int n2, String string4) throws IOException {
        EncryptDecrypt encryptDecrypt = new EncryptDecrypt(string, string2, string3, n, n2, string4);
        try {
            InputStream inputStream2 = encryptDecrypt.getDecryptStream(inputStream);
            return inputStream2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static URL JarFind(String string, ClassLoader classLoader) throws IOException {
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException(UnityDriver.i18n.getString("FileManager.FileNotFoundInJar") + string);
        }
        return uRL;
    }

    public static String readFileToString(String string) throws IOException {
        BufferedReader bufferedReader = FileManager.openTextInputFile(string);
        Scanner scanner = new Scanner(bufferedReader);
        StringBuilder stringBuilder = new StringBuilder(10000);
        while (scanner.hasNextLine()) {
            stringBuilder.append(scanner.nextLine());
            stringBuilder.append('\n');
        }
        scanner.close();
        bufferedReader.close();
        return stringBuilder.toString();
    }

    private static String correctFileSeparator(String string) {
        char c = File.separatorChar;
        String string2 = null;
        string2 = c == '/' ? string.replace('\\', c) : string.replace('/', c);
        return string2;
    }

    static {
        try {
            TEMPORARY_PATH = FileManager.getTemporaryPath();
        }
        catch (IOException iOException) {
            System.out.println(UnityDriver.i18n.getString("FileManager.NoTempPath") + iOException);
        }
    }
}

