/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;

public class D_Sum
extends Aggregate_Function {
    private static final long serialVersionUID = 1L;
    protected double currentTotalDouble;
    protected long currentTotalInt;
    protected boolean hasData = false;
    protected boolean isIntType;
    protected HashSet<Object> values;

    public D_Sum(Expression expression) {
        this.children = new ArrayList(1);
        this.children.add(expression);
        this.computedExpr = expression;
        this.returnType = expression.getReturnType();
        this.isIntType = this.returnType == -5 || this.returnType == 4;
        this.values = new HashSet();
    }

    @Override
    public void reset() {
        this.currentTotalDouble = 0.0;
        this.currentTotalInt = 0L;
        this.hasData = false;
        this.values = new HashSet();
    }

    @Override
    public Object compute() {
        if (this.hasData) {
            if (this.isIntType) {
                return new Long(this.currentTotalInt);
            }
            return new Double(this.currentTotalDouble);
        }
        return null;
    }

    @Override
    public void add(Tuple tuple) throws SQLException {
        Object object = this.computedExpr.evaluate(tuple);
        if (object != null) {
            if (this.values.contains(object)) {
                return;
            }
            if (this.isIntType) {
                this.currentTotalInt += ((Number)object).longValue();
            } else {
                this.currentTotalDouble += ((Number)object).doubleValue();
            }
            this.hasData = true;
            this.values.add(object);
        }
    }

    @Override
    public String toString(Relation relation, Attribute attribute) {
        return "SUM(" + this.computedExpr.toString(relation) + ") AS " + attribute.getName();
    }
}

