/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import unity.engine.Attribute;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.F_Cast;

public class ConstantValue
extends Expression {
    private static final long serialVersionUID = 1L;
    private Object value;

    public ConstantValue(Object object) {
        this.value = this.computeType(object);
    }

    @Override
    public Object evaluate(Tuple tuple) {
        return this.value;
    }

    public void changeType(int n) throws SQLException {
        if (n == this.returnType) {
            return;
        }
        this.value = F_Cast.changeType(this.value, this.returnType, n);
        this.returnType = n;
    }

    public String toString() {
        if (this.value instanceof String) {
            return "'" + this.value.toString() + "'";
        }
        if (Attribute.isNumberType(this.returnType)) {
            return this.value.toString();
        }
        if (Attribute.isDateType(this.returnType)) {
            if (this.returnType == 91) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                return "'" + simpleDateFormat.format(this.value) + "'";
            }
            if (this.returnType == 92) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                return "'" + simpleDateFormat.format(this.value) + "'";
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + simpleDateFormat.format(this.value) + "'";
        }
        return "'" + this.value.toString() + "'";
    }
}

