/*
 * Decompiled with CFR 0.152.
 */
package pig.query;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import pig.query.PigOperation;
import pig.query.PigQuery;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.SourceField;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.operators.Operator;
import unity.predicates.AttrJoinPredicate;
import unity.predicates.IntJoinPredicate;
import unity.predicates.JoinPredicate;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQCondNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.LQOrderByNode;
import unity.query.LQProjNode;
import unity.query.LQSelNode;
import unity.query.LQTree;
import unity.util.StringFunc;

public class PigBuilder {
    private LQNode root;
    private ArrayList<PigOperation> statements;

    public PigBuilder(LQNode lQNode) {
        this.root = lQNode;
    }

    public PigQuery buildQuery() throws SQLException {
        this.statements = new ArrayList();
        this.simplifyLQTree(this.root);
        LQTree.printTree(this.root, 0);
        this.buildQuery(this.root);
        return new PigQuery(this.statements);
    }

    private void buildQuery(LQNode lQNode) throws SQLException {
        if (lQNode == null) {
            return;
        }
        int n = lQNode.getNumChildren();
        for (int i = 0; i < n; ++i) {
            this.buildQuery(lQNode.getChild(i));
        }
        if (lQNode instanceof LQProjNode) {
            this.processProject(lQNode);
        } else if (lQNode instanceof LQSelNode) {
            this.processSelect(lQNode);
        } else if (lQNode instanceof LQExprNode) {
            this.processTable(lQNode);
        } else if (lQNode instanceof LQOrderByNode) {
            this.processOrderBy(lQNode);
        } else if (lQNode instanceof LQGroupByNode) {
            this.processGroupBy(lQNode);
        } else if (lQNode instanceof LQJoinNode) {
            this.processJoin(lQNode);
        } else {
            throw new SQLException("Operation not supported by Pig translator: " + lQNode.toString());
        }
    }

    private void processProject(LQNode lQNode) throws SQLException {
        LQNode lQNode2 = lQNode.getChild(0);
        PigOperation pigOperation = (PigOperation)lQNode2.getReference();
        Relation relation = lQNode2.getOutputRelation();
        ArrayList<LQExprNode> arrayList = ((LQProjNode)lQNode).getExpressions();
        PigOperation pigOperation2 = this.buildForEach(lQNode, pigOperation.getAlias(), arrayList, relation);
        this.statements.add(pigOperation2);
    }

    private PigOperation buildForEach(LQNode lQNode, String string, ArrayList<LQExprNode> arrayList, Relation relation) throws SQLException {
        GlobalQuery globalQuery = new GlobalQuery();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "S" + this.statements.size();
        stringBuilder.append(string2);
        stringBuilder.append(" = FOREACH ");
        stringBuilder.append(string);
        stringBuilder.append(" GENERATE ");
        int n = arrayList.size();
        Attribute[] attributeArray = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            attributeArray[i] = arrayList.get(i).buildAttribute(globalQuery);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(arrayList.get(i).generatePig(relation));
        }
        stringBuilder.append(";");
        Relation relation2 = new Relation(attributeArray);
        lQNode.setOutputRelation(relation2);
        PigOperation pigOperation = new PigOperation(stringBuilder.toString(), string2, relation2);
        lQNode.setReference(pigOperation);
        return pigOperation;
    }

    private void processSelect(LQNode lQNode) {
        LQNode lQNode2 = lQNode.getChild(0);
        PigOperation pigOperation = (PigOperation)lQNode2.getReference();
        Relation relation = lQNode2.getOutputRelation();
        StringBuilder stringBuilder = new StringBuilder();
        String string = "S" + this.statements.size();
        stringBuilder.append(string);
        stringBuilder.append(" = FILTER ");
        stringBuilder.append(pigOperation.getAlias());
        stringBuilder.append(" BY ");
        LQSelNode lQSelNode = (LQSelNode)lQNode;
        LQCondNode lQCondNode = lQSelNode.getCondition();
        stringBuilder.append(lQCondNode.generatePig(relation));
        stringBuilder.append(";");
        lQNode.setOutputRelation(relation);
        PigOperation pigOperation2 = new PigOperation(stringBuilder.toString(), string, relation);
        lQNode.setReference(pigOperation2);
        this.statements.add(pigOperation2);
    }

    private void processOrderBy(LQNode lQNode) {
        LQNode lQNode2 = lQNode.getChild(0);
        PigOperation pigOperation = (PigOperation)lQNode2.getReference();
        Relation relation = lQNode2.getOutputRelation();
        StringBuilder stringBuilder = new StringBuilder();
        String string = "S" + this.statements.size();
        stringBuilder.append(string);
        stringBuilder.append(" = ORDER ");
        stringBuilder.append(pigOperation.getAlias());
        stringBuilder.append(" BY ");
        stringBuilder.append(lQNode.generatePig(relation));
        stringBuilder.append(";");
        lQNode.setOutputRelation(relation);
        PigOperation pigOperation2 = new PigOperation(stringBuilder.toString(), string, relation);
        lQNode.setReference(pigOperation2);
        this.statements.add(pigOperation2);
    }

    private void processGroupBy(LQNode lQNode) {
        LQNode lQNode2 = lQNode.getChild(0);
        PigOperation pigOperation = (PigOperation)lQNode2.getReference();
        Relation relation = lQNode2.getOutputRelation();
        LQGroupByNode lQGroupByNode = (LQGroupByNode)lQNode;
        ArrayList<LQExprNode> arrayList = lQGroupByNode.getFunctionList();
        ArrayList<LQExprNode> arrayList2 = lQGroupByNode.getGroupList();
        StringBuilder stringBuilder = new StringBuilder();
        String string = "S" + this.statements.size();
        stringBuilder.append(string);
        stringBuilder.append(" = GROUP ");
        stringBuilder.append(pigOperation.getAlias());
        if (arrayList2.size() > 0) {
            stringBuilder.append(" BY ");
            this.appendExpr(stringBuilder, arrayList2, relation);
            stringBuilder.append(";");
        } else {
            stringBuilder.append(" ALL;");
        }
        PigOperation pigOperation2 = new PigOperation(stringBuilder.toString(), string, relation);
        lQNode.setReference(pigOperation2);
        this.statements.add(pigOperation2);
        Attribute[] attributeArray = new Attribute[]{new Attribute("group", 4, 0, arrayList2), new Attribute(pigOperation.getAlias(), 4, 0, relation)};
        lQNode.setOutputRelation(new Relation(attributeArray));
        LQExprNode lQExprNode = new LQExprNode();
        lQExprNode.setType(101);
        lQExprNode.setContent("group");
        arrayList.add(0, lQExprNode);
    }

    private void processJoin(LQNode lQNode) throws SQLException {
        Attribute attribute;
        int n;
        Serializable serializable;
        LQNode lQNode2 = lQNode.getChild(0);
        PigOperation pigOperation = (PigOperation)lQNode2.getReference();
        Relation relation = lQNode2.getOutputRelation();
        LQNode lQNode3 = lQNode.getChild(1);
        PigOperation pigOperation2 = (PigOperation)lQNode3.getReference();
        Relation relation2 = lQNode3.getOutputRelation();
        LQJoinNode lQJoinNode = (LQJoinNode)lQNode;
        if (lQJoinNode.isComplex()) {
            throw new SQLException("Unable to translate joins that involve expressions.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "S" + this.statements.size();
        stringBuilder.append(string);
        stringBuilder.append(" = JOIN ");
        stringBuilder.append(pigOperation.getAlias());
        stringBuilder.append(" BY ");
        LQCondNode lQCondNode = lQJoinNode.getCondition();
        GlobalQuery globalQuery = new GlobalQuery();
        JoinPredicate joinPredicate = null;
        if (lQCondNode != null && (joinPredicate = lQCondNode.buildJoinPredicate(new Operator[0], lQJoinNode, globalQuery, null)) == null) {
            throw new SQLException("Only supporting equi-joins currently.");
        }
        if (joinPredicate instanceof IntJoinPredicate) {
            serializable = (IntJoinPredicate)joinPredicate;
            stringBuilder.append("$" + ((IntJoinPredicate)serializable).getAttr1Loc());
            this.appendJoinType(stringBuilder, lQJoinNode);
            stringBuilder.append(", ");
            stringBuilder.append(pigOperation2.getAlias());
            stringBuilder.append(" BY ");
            stringBuilder.append("$" + ((IntJoinPredicate)serializable).getAttr2Loc());
            stringBuilder.append(";");
        } else if (joinPredicate instanceof AttrJoinPredicate) {
            serializable = (AttrJoinPredicate)joinPredicate;
            int[] nArray = ((AttrJoinPredicate)serializable).getAttr1Locs();
            int[] nArray2 = ((AttrJoinPredicate)serializable).getAttr2Locs();
            this.appendAttr(stringBuilder, nArray);
            this.appendJoinType(stringBuilder, lQJoinNode);
            stringBuilder.append(", ");
            stringBuilder.append(pigOperation2.getAlias());
            stringBuilder.append(" BY ");
            this.appendAttr(stringBuilder, nArray2);
            stringBuilder.append(";");
        } else {
            throw new SQLException("Join predicates with expressions are not currently supported.");
        }
        serializable = new Relation(relation);
        int n2 = ((Relation)serializable).getNumAttributes();
        for (n = 0; n < n2; ++n) {
            attribute = ((Relation)serializable).getAttribute(n);
            attribute.setName(pigOperation.getAlias() + "::" + attribute.getName());
        }
        ((Relation)serializable).mergeRelation(relation2);
        for (n = n2; n < ((Relation)serializable).getNumAttributes(); ++n) {
            attribute = ((Relation)serializable).getAttribute(n);
            attribute.setName(pigOperation2.getAlias() + "::" + attribute.getName());
        }
        lQNode.setOutputRelation((Relation)serializable);
        PigOperation pigOperation3 = new PigOperation(stringBuilder.toString(), string, (Relation)serializable);
        lQNode.setReference(pigOperation3);
        this.statements.add(pigOperation3);
    }

    private void appendJoinType(StringBuilder stringBuilder, LQJoinNode lQJoinNode) {
        if (lQJoinNode.isLeftOuterJoin() && lQJoinNode.isRightOuterJoin()) {
            stringBuilder.append(" FULL");
        } else if (lQJoinNode.isLeftOuterJoin()) {
            stringBuilder.append(" LEFT");
        } else if (lQJoinNode.isRightOuterJoin()) {
            stringBuilder.append(" RIGHT");
        }
    }

    private void appendAttr(StringBuilder stringBuilder, int[] nArray) {
        if (nArray.length > 1) {
            stringBuilder.append("(");
        }
        stringBuilder.append("$" + nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append("$" + nArray[i]);
        }
        if (nArray.length > 1) {
            stringBuilder.append(")");
        }
    }

    private void appendExpr(StringBuilder stringBuilder, ArrayList<LQExprNode> arrayList, Relation relation) {
        if (arrayList.size() > 1) {
            stringBuilder.append("(");
        }
        stringBuilder.append(arrayList.get(0).generatePig(relation));
        for (int i = 1; i < arrayList.size(); ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(arrayList.get(i).generatePig(relation));
        }
        if (arrayList.size() > 1) {
            stringBuilder.append(")");
        }
    }

    private void processTable(LQNode lQNode) throws SQLException {
        Object object;
        Iterator<SourceField> iterator;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        String string2 = null;
        String string3 = null;
        GQTableRef gQTableRef = null;
        AnnotatedSourceTable annotatedSourceTable = null;
        if (lQNode.getType() == 6) {
            iterator = lQNode.getContent();
            if (iterator == null || !(iterator instanceof GQTableRef)) {
                throw new SQLException("Invalid table node: " + lQNode.toString());
            }
            gQTableRef = (GQTableRef)((Object)iterator);
            annotatedSourceTable = ((GQTableRef)((Object)iterator)).getTable();
            string = gQTableRef.getAliasName();
            if (string == null) {
                string = annotatedSourceTable.getTableName();
            }
            if ((string2 = (String)annotatedSourceTable.getProperty("location")) == null) {
                throw new SQLException("No HDFS location specified for table: " + string);
            }
            string2 = StringFunc.delimitName(string2, '\'');
            string3 = "";
        }
        stringBuilder.append(string);
        stringBuilder.append(" = LOAD ");
        stringBuilder.append(string2);
        stringBuilder.append(" AS (");
        iterator = annotatedSourceTable.fieldIterator();
        int n = 0;
        Attribute[] attributeArray = new Attribute[annotatedSourceTable.getNumFields()];
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            object = iterator.next();
            int n2 = ((SourceField)object).getDataType();
            String string4 = ((SourceField)object).getColumnName();
            GQFieldRef gQFieldRef = gQTableRef.getFieldRef((SourceField)object);
            attributeArray[n] = new Attribute(string4, n2, 0, gQFieldRef);
            stringBuilder.append(((SourceField)object).getColumnName());
            stringBuilder.append(":");
            if (n2 == 4) {
                stringBuilder.append("int");
            } else if (n2 == 8) {
                stringBuilder.append("double");
            } else if (n2 == 6) {
                stringBuilder.append("float");
            } else if (n2 == 91 || n2 == 92 || n2 == 93) {
                stringBuilder.append("chararray");
                attributeArray[n].setType(93);
            } else {
                stringBuilder.append("chararray");
                attributeArray[n].setType(12);
            }
            ++n;
        }
        stringBuilder.append(");");
        object = new Relation(attributeArray);
        lQNode.setOutputRelation((Relation)object);
        PigOperation pigOperation = new PigOperation(stringBuilder.toString(), string, (Relation)object);
        lQNode.setReference(pigOperation);
        this.statements.add(pigOperation);
    }

    private void simplifyLQTree(LQNode lQNode) {
        LQNode lQNode2;
        LQNode lQNode3;
        if (lQNode instanceof LQExprNode && (lQNode3 = lQNode.getParent()) instanceof LQProjNode) {
            lQNode2 = lQNode3.getParent();
            lQNode2.replaceChild(lQNode3, lQNode);
            lQNode.setParent(lQNode2);
        }
        if (lQNode instanceof LQSelNode && (lQNode3 = lQNode.getParent()) instanceof LQSelNode) {
            lQNode2 = (LQSelNode)lQNode3;
            LQSelNode lQSelNode = (LQSelNode)lQNode;
            LQCondNode lQCondNode = lQSelNode.getCondition();
            LQCondNode lQCondNode2 = ((LQSelNode)lQNode2).getCondition();
            LQCondNode lQCondNode3 = new LQCondNode();
            lQCondNode3.setType(111);
            lQCondNode3.addChild(lQCondNode);
            lQCondNode3.addChild(lQCondNode2);
            lQCondNode3.setContent("AND");
            lQSelNode.setCondition(lQCondNode3);
            LQNode lQNode4 = lQNode3.getParent();
            lQNode4.replaceChild(lQNode3, lQNode);
            lQNode.setParent(lQNode4);
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            this.simplifyLQTree(lQNode.getChild(i));
        }
    }
}

