/*
 * Decompiled with CFR 0.152.
 */
package pig.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.ResourceBundle;
import pig.conn.ServerConnection;
import pig.jdbc.PigDatabaseMetaData;
import pig.jdbc.PigPreparedStatement;
import pig.jdbc.PigStatement;
import unity.generic.jdbc.ConnectionImpl;
import unity.jdbc.UnityDriver;

public class PigConnection
extends ConnectionImpl {
    public PigConnection(String string, String string2, int n, String string3, Properties properties) throws SQLException {
        this.url = string;
        this.clientInfo = properties;
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        if (this.clientInfo.containsKey("dbname")) {
            string3 = this.clientInfo.getProperty("dbname");
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Database to connect to:.  URL:  " + string2 + " Port: " + n + " Database name: " + string3);
        }
        this.connection = new ServerConnection();
        this.connection.connect(this.clientInfo);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n == 1005) {
            throw new SQLException(resources.getString("nosupportScrollSensitive"));
        }
        if (n2 == 1008) {
            throw new SQLException(resources.getString("nosupportConcurUpdatable"));
        }
        if (this.currentStatement != null) {
            this.currentStatement.close();
        }
        this.currentStatement = new PigStatement(this, this.connection, n, n2);
        return this.currentStatement;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new PigDatabaseMetaData(this, this.connection);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new PigPreparedStatement(this, this.connection, n, n2, string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return new PigPreparedStatement(this, this.connection, n, n2, string);
    }

    static {
        resources = ResourceBundle.getBundle("resources/pig/PigConnection", locale);
    }
}

