/*
 * Decompiled with CFR 0.152.
 */
package mongodb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import mongodb.conn.ServerConnection;
import mongodb.jdbc.MongoConnection;
import mongodb.query.MongoQuery;
import unity.engine.IServerConnection;
import unity.generic.jdbc.StatementImpl;
import unity.query.LimitInfo;
import unity.util.StringFunc;

public class MongoStatement
extends StatementImpl {
    private MongoQuery query;

    public MongoStatement(MongoConnection mongoConnection, IServerConnection iServerConnection, int n, int n2) {
        super(mongoConnection, iServerConnection, n, n2);
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        String string2 = string;
        if (this._results != null) {
            this._results.close();
        }
        this.queryActive = false;
        this._results = null;
        this.query = null;
        if (this._maxRows > 0) {
            LimitInfo limitInfo = LimitInfo.parse(string);
            limitInfo.rowCount = limitInfo.hasLimit ? Math.min(limitInfo.rowCount, this._maxRows) : this._maxRows;
            limitInfo.hasLimit = true;
            string2 = StringFunc.replaceLimit(string, limitInfo);
        }
        this._results = ((ServerConnection)this.con).executeQuery(string2, this._resultSetType, this);
        this.queryActive = true;
        return this._results;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (string.toLowerCase().trim().startsWith("select")) {
            throw new SQLException(resources.getString("errorExecuteUpdate") + string);
        }
        String string2 = string + ';';
        return ((ServerConnection)this.con).executeUpdate(string2, this);
    }

    public String getQueryString() {
        if (this.query == null) {
            return "";
        }
        try {
            return this.query.toMongoString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setQuery(MongoQuery mongoQuery) {
        this.query = mongoQuery;
    }

    static {
        resources = ResourceBundle.getBundle("resources/mongo/MongoStatement", locale);
    }
}

