/*
 * Decompiled with CFR 0.152.
 */
package com.unityjdbc.sourcebuilder;

import com.unityjdbc.sourcebuilder.ExtractStatus;
import com.unityjdbc.sourcebuilder.ExtractThread;
import com.unityjdbc.sourcebuilder.SourceBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.GlobalSchema;
import unity.io.FileManager;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.mapping.DatabaseMapping;
import unity.mapping.Driver;
import unity.util.EncryptDecrypt;

public class SourceFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static String addFailedMessage = UnityDriver.i18n.getString("SourceFrame.addFailedMessage");
    private static String addSuccessMessage = UnityDriver.i18n.getString("SourceFrame.addSuccessMessage");
    private JTextField txtSources;
    private JTextField txtName;
    private JTextField txtURL;
    private JTextField txtDriver;
    private JTextField txtXSpec;
    private JTextField txtUserId;
    private JTextField txtPassword;
    private JTextField txtSchema;
    private JTextField txtTablesInc;
    private JTextField txtTablesExc;
    private JTextField txtCatalogInc;
    private JList lstSourceType;
    private JTextArea txtMessages;
    private JButton btnXSpecBrowse;
    private JButton btnExit;
    private JButton btnAdd;
    private static int fieldSize = 55;
    private String startDirectory = null;
    private String sourcesFileName = "";
    private Source[] sources;
    private SourceBuilder sb;
    private ExtractStatus status;
    private Timer timer;
    private AnnotatedSourceDatabase database;
    private boolean extractInProgress = false;
    private boolean doAdd = true;
    private File lastDirectory = null;
    private JLabel lbl_1;
    private JLabel lbl_2;
    private JLabel lbl_3;
    private JLabel lbl_4;
    private JLabel lbl_5;
    private JLabel lbl_6;
    private JLabel lbl_7;
    private JLabel lblMessages;
    private JLabel lblProgress;
    private JPanel progressPanel;
    private JProgressBar progressBar;
    private JPanel progressMessagePanel;
    private JLabel lblCount;
    private JLabel lblLastMessage;
    private JLabel lblMessage;
    private JComboBox cbxStats;

    public SourceFrame(SourceBuilder sourceBuilder) {
        super(sourceBuilder);
        this.sb = sourceBuilder;
        this.setSize(784, 661);
        this.setTitle(UnityDriver.i18n.getString("SourceFrame.title"));
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(this.getRootPane());
        this.setModal(true);
        this.startDirectory = System.getProperty("user.dir");
        this.initSources();
        this.initialize();
        this.setupDisplay();
    }

    public void setupDisplay() {
        boolean bl = this.doAdd = this.database == null;
        if (this.database != null) {
            this.btnAdd.setText(UnityDriver.i18n.getString("SourceFrame.updateSource"));
            this.setField(this.txtName, this.database.getDatabaseName());
            this.setField(this.txtURL, this.database.getURL());
            this.setField(this.txtDriver, this.database.getJavaDriverClassName());
            this.setField(this.txtXSpec, this.database.getSchemaFile());
            this.setField(this.txtUserId, this.database.getUserId());
            this.setField(this.txtPassword, this.database.getPassword());
            this.setField(this.txtSchema, this.database.getSchema());
            this.setField(this.txtTablesInc, this.database.getTableInclude());
            this.setField(this.txtTablesExc, this.database.getTableExclude());
            this.setField(this.txtCatalogInc, this.database.getCatalogInclude());
            if (this.txtTablesExc.getText().equals("")) {
                this.txtTablesExc.setText(".*\\$.*");
            }
        } else {
            this.btnAdd.setText(UnityDriver.i18n.getString("SourceFrame.addSource"));
            this.txtURL.setText("");
            this.txtDriver.setText("");
            this.txtXSpec.setText("");
            this.txtName.setText("");
            this.txtPassword.setText("");
            this.txtUserId.setText("");
            this.txtSchema.setText("");
            this.txtTablesInc.setText("");
            this.txtCatalogInc.setText("");
            this.txtTablesExc.setText("");
            this.lstSourceType.setSelectedIndex(-1);
        }
    }

    private void setField(JTextField jTextField, String string) {
        if (string == null) {
            jTextField.setText("");
        } else {
            jTextField.setText(string);
        }
    }

    public void setSourcesFile(String string) {
        this.sourcesFileName = string;
        this.txtSources.setText(this.sourcesFileName);
        File file = new File(this.sourcesFileName);
        this.startDirectory = file.getParent();
        if (this.startDirectory == null) {
            this.startDirectory = "";
        }
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        GridLayout gridLayout = new GridLayout(12, 1);
        gridLayout.setHgap(5);
        Font font = new Font("DialogInput", 1, 12);
        Font font2 = new Font("SansSerif", 0, 12);
        Font font3 = new Font("SansSerif", 0, 11);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 0, 1, 0);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 700;
        gridBagConstraints.ipady = 250;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 0, 5, 0);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.ipadx = 10;
        gridBagConstraints2.ipady = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.ipadx = 185;
        gridBagConstraints3.ipady = 79;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        gridBagLayout.columnWeights = new double[]{1.0};
        gridBagLayout.rowHeights = new int[]{0, 0, 48, 0};
        jPanel.setLayout(gridBagLayout);
        String string = this.startDirectory.equals("") ? "sources.xml" : this.startDirectory + System.getProperty("file.separator") + "sources.xml";
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(1.0f);
        jPanel3.setBorder(null);
        this.lstSourceType = new JList<Source>(this.sources);
        this.lstSourceType.setAlignmentX(0.0f);
        this.lstSourceType.setFont(font2);
        this.lstSourceType.setBorder(BorderFactory.createEtchedBorder(0));
        this.lstSourceType.setSelectionMode(0);
        this.lstSourceType.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SourceFrame.this.lstSourceType.getSelectedIndex();
                SourceFrame.this.txtURL.setText(((SourceFrame)SourceFrame.this).sources[n].defaultURL);
                SourceFrame.this.txtDriver.setText(((SourceFrame)SourceFrame.this).sources[n].driverName);
                SourceFrame.this.txtTablesExc.setText(((SourceFrame)SourceFrame.this).sources[n].tableExc);
                SourceFrame.this.txtURL.repaint();
                SourceFrame.this.txtDriver.repaint();
            }
        });
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel(UnityDriver.i18n.getString("SourceFrame.sourceType"));
        jLabel.setLabelFor(this.lstSourceType);
        jLabel.setAlignmentY(0.0f);
        jLabel.setVerticalAlignment(1);
        jLabel.setHorizontalAlignment(2);
        jLabel.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jLabel);
        jPanel3.add(this.lstSourceType);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_1 = new JLabel(UnityDriver.i18n.getString("SourceFrame.nameLabel"));
        this.lbl_1.setBounds(12, 6, 100, 17);
        this.lbl_1.setFont(font);
        jPanel5.add(this.lbl_1);
        jPanel4.setLayout(gridLayout);
        this.txtName = new JTextField(fieldSize);
        this.txtName.setBounds(130, 5, 444, 19);
        this.txtName.setFont(font3);
        jPanel5.add(this.txtName);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_4 = new JLabel(UnityDriver.i18n.getString("SourceFrame.schemaFileLabel"));
        this.lbl_4.setBounds(12, 6, 84, 17);
        this.lbl_4.setFont(font);
        jPanel5.add(this.lbl_4);
        this.txtXSpec = new JTextField(fieldSize - 2);
        this.txtXSpec.setBounds(130, 5, 428, 19);
        this.txtXSpec.setFont(font3);
        jPanel5.add(this.txtXSpec);
        this.btnXSpecBrowse = new JButton("...");
        this.btnXSpecBrowse.setBounds(527, 5, 18, 18);
        this.btnXSpecBrowse.setFont(font3);
        this.btnXSpecBrowse.setPreferredSize(new Dimension(18, 18));
        this.btnXSpecBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = SourceFrame.this.getFile(SourceFrame.this.txtXSpec.getText());
                if (file != null) {
                    SourceFrame.this.txtXSpec.setText(file.getPath());
                }
            }
        });
        jPanel5.add(this.btnXSpecBrowse);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_2 = new JLabel(UnityDriver.i18n.getString("SourceFrame.urlLabel"));
        this.lbl_2.setBounds(12, 6, 84, 17);
        this.lbl_2.setFont(font);
        jPanel5.add(this.lbl_2);
        this.txtURL = new JTextField(fieldSize);
        this.txtURL.setHorizontalAlignment(2);
        this.txtURL.setBounds(130, 5, 444, 19);
        this.txtURL.setFont(font3);
        jPanel5.add(this.txtURL);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_5 = new JLabel(UnityDriver.i18n.getString("SourceFrame.driverLabel"));
        this.lbl_5.setBounds(12, 6, 84, 17);
        this.lbl_5.setFont(font);
        jPanel5.add(this.lbl_5);
        this.txtDriver = new JTextField(fieldSize);
        this.txtDriver.setBounds(130, 5, 444, 19);
        this.txtDriver.setFont(font3);
        jPanel5.add(this.txtDriver);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_3 = new JLabel(UnityDriver.i18n.getString("SourceFrame.userLabel"));
        this.lbl_3.setBounds(12, 6, 84, 17);
        this.lbl_3.setFont(font);
        jPanel5.add(this.lbl_3);
        this.txtUserId = new JTextField(fieldSize);
        this.txtUserId.setBounds(130, 5, 444, 19);
        this.txtUserId.setFont(font3);
        jPanel5.add(this.txtUserId);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_7 = new JLabel(UnityDriver.i18n.getString("SourceFrame.passwordLabel"));
        this.lbl_7.setBounds(12, 6, 84, 17);
        this.lbl_7.setFont(font);
        jPanel5.add(this.lbl_7);
        this.txtPassword = new JPasswordField(fieldSize);
        this.txtPassword.setBounds(130, 5, 444, 19);
        this.txtPassword.setFont(font3);
        jPanel5.add(this.txtPassword);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_6 = new JLabel(UnityDriver.i18n.getString("SourceFrame.catalogIncludeLabel"));
        this.lbl_6.setBounds(12, 6, 84, 17);
        this.lbl_6.setFont(font);
        jPanel5.add(this.lbl_6);
        this.txtCatalogInc = new JTextField(fieldSize);
        this.txtCatalogInc.setBounds(130, 5, 444, 19);
        this.txtCatalogInc.setFont(font3);
        jPanel5.add(this.txtCatalogInc);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_6 = new JLabel(UnityDriver.i18n.getString("SourceFrame.schemaLabel2"));
        this.lbl_6.setBounds(12, 6, 84, 17);
        this.lbl_6.setFont(font);
        jPanel5.add(this.lbl_6);
        this.txtSchema = new JTextField(fieldSize);
        this.txtSchema.setBounds(130, 5, 444, 19);
        this.txtSchema.setFont(font3);
        jPanel5.add(this.txtSchema);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_6 = new JLabel(UnityDriver.i18n.getString("SourceFrame.tableIncludeLabel"));
        this.lbl_6.setBounds(12, 6, 125, 17);
        this.lbl_6.setFont(font);
        jPanel5.add(this.lbl_6);
        this.txtTablesInc = new JTextField(fieldSize);
        this.txtTablesInc.setBounds(130, 5, 444, 19);
        this.txtTablesInc.setFont(font3);
        jPanel5.add(this.txtTablesInc);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        this.lbl_6 = new JLabel(UnityDriver.i18n.getString("SourceFrame.tableExcludeLabel"));
        this.lbl_6.setBounds(12, 6, 125, 17);
        this.lbl_6.setFont(font);
        jPanel5.add(this.lbl_6);
        this.txtTablesExc = new JTextField(fieldSize);
        this.txtTablesExc.setBounds(130, 5, 444, 19);
        this.txtTablesExc.setFont(font3);
        jPanel5.add(this.txtTablesExc);
        jPanel4.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(null);
        JLabel jLabel2 = new JLabel(UnityDriver.i18n.getString("SourceFrame.statsLabel"));
        jLabel2.setBounds(12, 6, 125, 17);
        jLabel2.setFont(font);
        jPanel5.add(jLabel2);
        this.cbxStats = new JComboBox();
        this.cbxStats.setLocation(130, 3);
        this.cbxStats.setSize(100, 19);
        this.cbxStats.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Row Counts", "All"}));
        this.cbxStats.setSelectedIndex(1);
        jPanel5.add(this.cbxStats);
        jPanel4.add(jPanel5);
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (SourceFrame.this.txtName.getText().length() > 0) {
                    if (SourceFrame.this.startDirectory.equals("")) {
                        SourceFrame.this.txtXSpec.setText(SourceFrame.this.txtName.getText() + ".xml");
                    } else {
                        SourceFrame.this.txtXSpec.setText(SourceFrame.this.startDirectory + System.getProperty("file.separator") + SourceFrame.this.txtName.getText() + ".xml");
                    }
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (SourceFrame.this.txtName.getText().length() > 0) {
                    if (SourceFrame.this.startDirectory.equals("")) {
                        SourceFrame.this.txtXSpec.setText(SourceFrame.this.txtName.getText() + ".xml");
                    } else {
                        SourceFrame.this.txtXSpec.setText(SourceFrame.this.startDirectory + System.getProperty("file.separator") + SourceFrame.this.txtName.getText() + ".xml");
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (SourceFrame.this.txtName.getText().length() > 0) {
                    if (SourceFrame.this.startDirectory.equals("")) {
                        SourceFrame.this.txtXSpec.setText(SourceFrame.this.txtName.getText() + ".xml");
                    } else {
                        SourceFrame.this.txtXSpec.setText(SourceFrame.this.startDirectory + System.getProperty("file.separator") + SourceFrame.this.txtName.getText() + ".xml");
                    }
                }
            }
        });
        jPanel2.add(jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        this.txtMessages = new JTextArea(10, 60);
        this.txtMessages.setText("");
        JScrollPane jScrollPane = new JScrollPane(this.txtMessages);
        jScrollPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        jPanel6.add(jScrollPane);
        this.lblMessages = new JLabel(UnityDriver.i18n.getString("SourceFrame.messagesLabel"));
        jScrollPane.setColumnHeaderView(this.lblMessages);
        this.setContentPane(jPanel);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 5, 0), 185, 79);
        gridBagConstraints4.ipady = 0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.anchor = 11;
        FlowLayout flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(0);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(flowLayout2);
        jPanel7.setBorder(BorderFactory.createEtchedBorder(0));
        this.txtSources = new JTextField(40);
        this.txtSources.setText(string);
        this.txtSources.setEditable(false);
        jPanel7.add((Component)new JLabel(UnityDriver.i18n.getString("SourceFrame.sourcesFileLabel")), null);
        jPanel7.add(this.txtSources);
        this.btnExit = new JButton(UnityDriver.i18n.getString("SourceFrame.exitButtonLabel"));
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceFrame.this.setVisible(false);
            }
        });
        jPanel7.add(this.btnExit);
        jPanel.add((Component)jPanel7, gridBagConstraints4);
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        this.progressPanel = new JPanel();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        jPanel.add((Component)this.progressPanel, gridBagConstraints5);
        this.progressPanel.setLayout(new GridLayout(2, 1, 0, 0));
        this.progressMessagePanel = new JPanel();
        this.progressPanel.add(this.progressMessagePanel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWidths = new int[]{10, 42, 1, 50, 0};
        gridBagLayout2.rowHeights = new int[]{20, 0};
        gridBagLayout2.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.progressMessagePanel.setLayout(gridBagLayout2);
        this.lblProgress = new JLabel(UnityDriver.i18n.getString("SourceFrame.progressLabel"));
        this.lblProgress.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        this.progressMessagePanel.add((Component)this.lblProgress, gridBagConstraints6);
        this.lblCount = new JLabel("");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 0;
        this.progressMessagePanel.add((Component)this.lblCount, gridBagConstraints7);
        this.lblLastMessage = new JLabel(" ");
        this.lblLastMessage.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints8.gridx = 2;
        gridBagConstraints8.gridy = 0;
        this.progressMessagePanel.add((Component)this.lblLastMessage, gridBagConstraints8);
        this.lblMessage = new JLabel("");
        this.lblMessage.setHorizontalAlignment(2);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.anchor = 18;
        gridBagConstraints9.gridx = 3;
        gridBagConstraints9.gridy = 0;
        this.progressMessagePanel.add((Component)this.lblMessage, gridBagConstraints9);
        this.progressBar = new JProgressBar();
        this.progressBar.setForeground(Color.GREEN);
        this.progressPanel.add(this.progressBar);
        jPanel.add((Component)jPanel6, gridBagConstraints);
        jPanel2.setFont(new Font("Dialog", 2, 12));
        jPanel4.setFont(new Font("Dialog", 2, 12));
        this.btnAdd = new JButton(UnityDriver.i18n.getString("SourceFrame.addSourceButton"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceFrame.this.database == null && SourceFrame.this.txtName.getText().length() == 0) {
                    JOptionPane.showMessageDialog(SourceFrame.this, UnityDriver.i18n.getString("SourceFrame.errorUniqueDBName"), UnityDriver.i18n.getString("SourceFrame.errorFrameTitle"), 0);
                    return;
                }
                if (SourceFrame.this.txtXSpec.getText().length() == 0) {
                    JOptionPane.showMessageDialog(SourceFrame.this, UnityDriver.i18n.getString("SourceFrame.errorDBLocation"), UnityDriver.i18n.getString("SourceFrame.errorFrameTitle"), 0);
                    return;
                }
                if (SourceFrame.this.txtDriver.getText().length() == 0 || SourceFrame.this.txtURL.getText().length() == 0) {
                    JOptionPane.showMessageDialog(SourceFrame.this, UnityDriver.i18n.getString("SourceFrame.errorJDBCURL"), UnityDriver.i18n.getString("SourceFrame.errorFrameTitle"), 0);
                    return;
                }
                if (SourceFrame.this.database == null) {
                    try {
                        UnityConnection unityConnection;
                        GlobalSchema globalSchema;
                        AnnotatedSourceDatabase annotatedSourceDatabase;
                        String string = "jdbc:unity://" + SourceFrame.this.sourcesFileName;
                        Properties properties = new Properties();
                        if (SourceFrame.this.sb.getPassword() != null) {
                            properties.put("password", SourceFrame.this.sb.getPassword());
                        }
                        if ((annotatedSourceDatabase = (globalSchema = (unityConnection = (UnityConnection)DriverManager.getConnection(string, properties)).getGlobalSchema()).getDB(SourceFrame.this.txtName.getText())) != null && annotatedSourceDatabase != SourceFrame.this.database) {
                            JOptionPane.showMessageDialog(SourceFrame.this, UnityDriver.i18n.getString("SourceFrame.errorUniqueDBName2") + SourceFrame.this.txtName.getText(), UnityDriver.i18n.getString("SourceFrame.errorFrameTitle"), 0);
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SourceFrame.this.doAdd();
                } else {
                    SourceFrame.this.doUpdate();
                }
            }
        });
        jPanel4.add(this.btnAdd);
    }

    public void clearForNewSource() {
        this.progressBar.setValue(0);
        this.lblMessage.setText("");
        this.lblCount.setText("");
        this.txtMessages.setText("");
    }

    private void initSources() {
        Map<String, Driver> map = DatabaseMapping.getDrivers();
        this.sources = new Source[map.size()];
        Iterator<Map.Entry<String, Driver>> iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Source source;
            Map.Entry<String, Driver> entry = iterator.next();
            Driver driver = entry.getValue();
            this.sources[n] = source = new Source(driver.getClassName(), driver.getName(), driver.getUrl(), driver.getTableExclude());
            ++n;
        }
    }

    private File getFile(String string) {
        JFileChooser jFileChooser;
        File file;
        if (string != null && !string.equals("")) {
            file = new File(string);
            jFileChooser = new JFileChooser(file);
            jFileChooser.setSelectedFile(file);
        } else {
            jFileChooser = new JFileChooser();
            if (this.lastDirectory != null) {
                jFileChooser.setCurrentDirectory(this.lastDirectory);
            } else {
                jFileChooser.setCurrentDirectory(new File(this.startDirectory));
            }
        }
        jFileChooser.setDialogTitle(UnityDriver.i18n.getString("SourceFrame.saveTitle"));
        jFileChooser.setFileFilter(new XMLFileFilter());
        if (jFileChooser.showSaveDialog(new JFrame()) == 0) {
            file = jFileChooser.getSelectedFile();
            if (file.isDirectory()) {
                return null;
            }
            this.lastDirectory = jFileChooser.getCurrentDirectory();
            return file;
        }
        return null;
    }

    private void doAdd() {
        this.clearForNewSource();
        ExtractSourceThread extractSourceThread = new ExtractSourceThread(this.sb.getPassword());
        extractSourceThread.start();
    }

    private void doUpdate() {
        this.clearForNewSource();
        ExtractSourceThread extractSourceThread = new ExtractSourceThread(this.sb.getPassword());
        extractSourceThread.start();
    }

    private void threadDoAdd(AnnotatedSourceDatabase annotatedSourceDatabase, String string) {
        String string2 = this.txtSources.getText();
        String string3 = this.txtXSpec.getText();
        if (this.txtUserId.getText() != null && !this.txtUserId.getText().equals("")) {
            annotatedSourceDatabase.setUserId(this.txtUserId.getText());
            annotatedSourceDatabase.setPassword(this.txtPassword.getText());
        }
        try {
            this.txtMessages.append("Writing information into XML file.\n");
            OutputStream outputStream = FileManager.openOutputFile(string3);
            EncryptDecrypt encryptDecrypt = null;
            if (string != null) {
                encryptDecrypt = new EncryptDecrypt(string);
                try {
                    outputStream = encryptDecrypt.getEncryptStream(outputStream);
                }
                catch (Exception exception) {
                    this.txtMessages.append("Failed to encrypt schema file.");
                    return;
                }
            }
            annotatedSourceDatabase.setSchemaFile(string3);
            annotatedSourceDatabase.exportXML(outputStream, "UTF-8");
            if (this.doAdd) {
                this.txtMessages.append("Updating sources file.\n");
                GlobalSchema globalSchema = this.sb.getSchema();
                if (globalSchema == null) {
                    globalSchema = new GlobalSchema();
                }
                globalSchema.addDatabase(annotatedSourceDatabase);
                String string4 = globalSchema.exportSources();
                OutputStream outputStream2 = FileManager.openOutputFile(string2);
                if (string != null) {
                    try {
                        outputStream2 = encryptDecrypt.getEncryptStream(outputStream2);
                    }
                    catch (Exception exception) {
                        this.txtMessages.append("Failed to encrypt sources file.");
                    }
                }
                outputStream2.write(string4.getBytes(Charset.forName("UTF-8")));
                outputStream2.close();
            }
            this.txtMessages.append(addSuccessMessage);
            this.sb.reInit(this.sb.getUrlUnity());
        }
        catch (IOException iOException) {
            this.txtMessages.append("IOException during extract: " + iOException.getMessage() + '\n');
            this.txtMessages.append(addFailedMessage);
        }
    }

    public void setDatabase(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.database = annotatedSourceDatabase;
    }

    private class ExtractSourceThread
    extends Thread {
        private String password;

        public ExtractSourceThread(String string) {
            this.password = string;
        }

        @Override
        public void run() {
            if (SourceFrame.this.extractInProgress) {
                return;
            }
            SourceFrame.this.extractInProgress = true;
            SourceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            SourceFrame.this.progressBar.setForeground(Color.GREEN);
            String string = SourceFrame.this.txtDriver.getText();
            String string2 = SourceFrame.this.txtURL.getText();
            String string3 = SourceFrame.this.txtName.getText();
            String string4 = SourceFrame.this.txtSchema.getText();
            String string5 = SourceFrame.this.txtTablesInc.getText();
            String string6 = SourceFrame.this.txtTablesExc.getText();
            String string7 = SourceFrame.this.txtCatalogInc.getText();
            if (string7.trim().equals("")) {
                string7 = null;
            }
            int n = SourceFrame.this.cbxStats.getSelectedIndex();
            if (string3.equals("")) {
                string3 = null;
            }
            if (string4.equals("")) {
                string4 = null;
            }
            SourceFrame.this.status = new ExtractStatus();
            SourceFrame.this.timer = new Timer(100, new RefreshAction());
            SourceFrame.this.timer.start();
            ExtractThread extractThread = new ExtractThread(SourceFrame.this.status, string, string2, SourceFrame.this.txtUserId.getText(), SourceFrame.this.txtPassword.getText(), string3, string4, string5, string6, string7, n);
            extractThread.start();
            while (!SourceFrame.this.status.isComplete()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (!SourceFrame.this.status.hasError()) {
                AnnotatedSourceDatabase annotatedSourceDatabase = extractThread.getDatabase();
                SourceFrame.this.threadDoAdd(annotatedSourceDatabase, this.password);
            }
            SourceFrame.this.extractInProgress = false;
            SourceFrame.this.setCursor(null);
        }
    }

    private class RefreshAction
    implements ActionListener {
        private int lastMessageOutput = 0;

        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            SourceFrame.this.progressBar.setMaximum(SourceFrame.this.status.getTotalTables());
            SourceFrame.this.progressBar.setValue(SourceFrame.this.status.getProcessedTables());
            SourceFrame.this.lblCount.setText(SourceFrame.this.status.getProcessedTables() + " of " + SourceFrame.this.status.getTotalTables());
            int n = 110;
            ArrayList<String> arrayList = SourceFrame.this.status.getMessages();
            if (arrayList != null && arrayList.size() > 0) {
                string = SourceFrame.this.status.getLastMessage();
                SourceFrame.this.lblMessage.setText(string.substring(0, Math.min(n, string.length())));
            }
            while (this.lastMessageOutput < arrayList.size()) {
                SourceFrame.this.txtMessages.append(arrayList.get(this.lastMessageOutput) + '\n');
                ++this.lastMessageOutput;
            }
            string = SourceFrame.this.status.getError();
            if (string != null) {
                SourceFrame.this.lblMessage.setText(string.substring(0, Math.min(n, string.length())));
                SourceFrame.this.progressBar.setForeground(Color.RED);
            }
            if (SourceFrame.this.status.isComplete()) {
                SourceFrame.this.timer.stop();
                return;
            }
        }
    }

    private class XMLFileFilter
    extends FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = this.getExtension(file);
                if (string != null && string.toLowerCase().equals("xml")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "XML Files";
        }

        public String getExtension(File file) {
            String string;
            int n;
            if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
                return string.substring(n + 1).toLowerCase();
            }
            return null;
        }
    }

    private class Source {
        public String driverName;
        public String sourceName;
        public String defaultURL;
        public String tableExc;

        public Source(String string, String string2, String string3, String string4) {
            this.driverName = string;
            this.sourceName = string2;
            this.defaultURL = string3;
            this.tableExc = string4;
        }

        public String toString() {
            return this.sourceName;
        }
    }
}

