/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.util.HashMap;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanelFactory;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.AutoCorrector;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.ToolsPopupHandler;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxSQLEntryAreaFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;

public class SQLEntryPanelFactoryProxy
implements ISQLEntryPanelFactory {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLEntryPanelFactoryProxy.class);
    private SyntaxPlugin _syntaxPlugin;
    private ISQLEntryPanelFactory _originalFactory;
    private RSyntaxSQLEntryAreaFactory _rsyntaxFactory;

    SQLEntryPanelFactoryProxy(SyntaxPlugin syntaxPlugin, ISQLEntryPanelFactory originalFactory) {
        this._originalFactory = originalFactory;
        this._rsyntaxFactory = new RSyntaxSQLEntryAreaFactory(syntaxPlugin);
        this._syntaxPlugin = syntaxPlugin;
    }

    public void sessionEnding(ISession session) {
        this._rsyntaxFactory.sessionEnding(session);
    }

    public ISQLEntryPanel createSQLEntryPanel(ISession session, HashMap<String, Object> props) {
        ISQLEntryPanel newPnl;
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        SyntaxPreferences prefs = this.getPreferences(session);
        ISQLEntryPanel pnl = this.getPanel(session);
        if (prefs.getUseRSyntaxTextArea()) {
            newPnl = this._rsyntaxFactory.createSQLEntryPanel(session, props);
            boolean replaceTabsBySpaces = this._syntaxPlugin.getSyntaxPreferences().isReplaceTabsBySpaces();
            ((SquirrelRSyntaxTextArea)((Object)newPnl.getTextComponent())).setTabsEmulated(replaceTabsBySpaces);
        } else {
            newPnl = this._originalFactory.createSQLEntryPanel(session, props);
        }
        newPnl.getTextComponent().setTabSize(this._syntaxPlugin.getSyntaxPreferences().getTabLength());
        new ToolsPopupHandler(this._syntaxPlugin).initToolsPopup(props, newPnl);
        new AutoCorrector(newPnl.getTextComponent(), this._syntaxPlugin);
        if (null == pnl || !newPnl.getClass().equals(pnl.getClass())) {
            this.removePanel(session);
            this.savePanel(session, newPnl);
        }
        return newPnl;
    }

    private SyntaxPreferences getPreferences(ISession session) {
        return (SyntaxPreferences)session.getPluginObject((IPlugin)this._syntaxPlugin, "prefs");
    }

    private void removePanel(ISession session) {
        session.removePluginObject((IPlugin)this._syntaxPlugin, "sqlentry");
    }

    private ISQLEntryPanel getPanel(ISession session) {
        return (ISQLEntryPanel)session.getPluginObject((IPlugin)this._syntaxPlugin, "sqlentry");
    }

    private void savePanel(ISession session, ISQLEntryPanel pnl) {
        session.putPluginObject((IPlugin)this._syntaxPlugin, "sqlentry", (Object)pnl);
    }
}

