/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerExceptionUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.IntraVmConnectionFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ServerMain;

public class ServerMainImpl
implements ServerMain {
    public static void main(String[] args) throws Exception {
        int port;
        try {
            String portString = args[0].substring("-port:".length(), args[0].length());
            port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            System.out.println("ERROR: Invalid port parameter. Should be -port:<port number>");
            throw e;
        }
        LocateRegistry.createRegistry(port);
        ServerMainImpl obj = new ServerMainImpl();
        ServerMain stub = (ServerMain)UnicastRemoteObject.exportObject((Remote)obj, 0);
        Registry registry = LocateRegistry.getRegistry(port);
        registry.rebind(ServerMain.class.getName(), stub);
        System.out.println("Hibernate process ready");
    }

    @Override
    public HibernateServerConnection createHibernateServerConnection(HibernateConfiguration cfg) throws RemoteException {
        try {
            IntraVmConnectionFactory intraVmConnectionFactory = new IntraVmConnectionFactory();
            HibernateServerConnection ret = intraVmConnectionFactory.createHibernateConnection(cfg, true);
            return (HibernateServerConnection)UnicastRemoteObject.exportObject((Remote)ret, 0);
        }
        catch (Throwable t) {
            throw new RemoteException(t.getMessage(), HibernateServerExceptionUtil.prepareTransport(t));
        }
    }

    @Override
    public void exit() {
        System.out.println("Will exit on client request");
        System.exit(0);
    }
}

