/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.FactoryWrapper;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerExceptionUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateSqlConnectionData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HqlQueryResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.JDBCConnectionAccess;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.JDBCTemporalEscapeParse;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoLoader;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstituteFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.QueryCreationResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.RCParam;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ReflectionCaller;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.SQLGenerator;

public class HibernateServerConnectionImpl
implements HibernateServerConnection {
    private FactoryWrapper _sessionFactoryImpl;
    private ClassLoader _cl;
    private boolean _server;
    private HashMap<String, MappedClassInfoData> _infoDataByClassName;
    private ReflectionCaller _rcHibernateSession;
    private String _driverClassName;
    private String _url;
    private String _user;
    private String _password;

    HibernateServerConnectionImpl(FactoryWrapper sessionFactoryImpl, ClassLoader cl, boolean isServer) throws RemoteException {
        this._sessionFactoryImpl = sessionFactoryImpl;
        this._cl = cl;
        this._server = isServer;
    }

    @Override
    public String generateSQL(String hqlQuery) {
        return SQLGenerator.generateSql(this.createQuery(hqlQuery).getRcQuery(), this._cl, this._sessionFactoryImpl);
    }

    @Override
    public void closeConnection() {
        Throwable reThrow = null;
        try {
            new ReflectionCaller(this._sessionFactoryImpl.getEntityManagerFactory()).callMethod("close");
        }
        catch (Throwable t) {
            reThrow = t;
        }
        finally {
            this._sessionFactoryImpl = null;
            this._cl = null;
            this._infoDataByClassName = null;
            System.gc();
            if (null != reThrow) {
                throw new RuntimeException(reThrow);
            }
        }
    }

    @Override
    public ArrayList<MappedClassInfoData> getMappedClassInfoData() {
        this.initMappedClassInfos();
        return new ArrayList<MappedClassInfoData>(this._infoDataByClassName.values());
    }

    private void initMappedClassInfos() {
        if (null != this._infoDataByClassName) {
            return;
        }
        this._infoDataByClassName = MappedClassInfoLoader.getMappedClassInfos(this._sessionFactoryImpl, this._cl, this._server);
    }

    @Override
    public HibernateSqlConnectionData getHibernateSqlConnectionData() {
        return JDBCConnectionAccess.getHibernateSqlConnectionData(this._cl, this.getRcHibernateSession());
    }

    @Override
    public HqlQueryResult createQueryList(String hqlQuery, int sqlNbrRowsToShow) {
        if (null != this._driverClassName) {
            this._driverClassName = null;
            this._url = null;
            this._user = null;
            this._password = null;
            this._rcHibernateSession = null;
        }
        return this._createResultList(hqlQuery, sqlNbrRowsToShow);
    }

    @Override
    public HqlQueryResult createQueryList(String hqlQuery, int sqlNbrRowsToShow, String driverClassName, String url, String user, String password) throws RemoteException {
        if (null == this._driverClassName) {
            this._driverClassName = driverClassName;
            this._url = url;
            this._user = user;
            this._password = password;
            this._rcHibernateSession = null;
        }
        return this._createResultList(hqlQuery, sqlNbrRowsToShow);
    }

    private HqlQueryResult _createResultList(String hqlQuery, int sqlNbrRowsToShow) {
        HqlQueryResult ret = new HqlQueryResult();
        List queryResList = null;
        try {
            this.getRcHibernateSession().callMethod("getTransaction").callMethod("begin");
        }
        catch (Throwable t) {
            ret.putSessionAdminException("Exception occurced during call of Session.getTransaction().begin()", HibernateServerExceptionUtil.prepareTransport(t, this._server));
        }
        try {
            QueryCreationResult queryCreationResult = this.createQuery(hqlQuery);
            if (null != queryCreationResult.getMessagePanelInfoText()) {
                ret.setMessagePanelInfoText(queryCreationResult.getMessagePanelInfoText());
            }
            ReflectionCaller rcQuery = queryCreationResult.getRcQuery();
            if (this.isDataUpdate(hqlQuery)) {
                int updateCount = (Integer)rcQuery.callMethod("executeUpdate").getCallee();
                ret.setUpdateCount(updateCount);
                this.getRcHibernateSession().callMethod("getTransaction").callMethod("commit");
            } else {
                if (0 <= sqlNbrRowsToShow) {
                    rcQuery = rcQuery.callMethod("setMaxResults", new RCParam().add(sqlNbrRowsToShow, Integer.TYPE));
                }
                queryResList = (List)rcQuery.callMethod("list").getCallee();
                this.tryRollbackTx(ret);
            }
        }
        catch (Throwable t) {
            ret.setExceptionOccuredWhenExecutingQuery(HibernateServerExceptionUtil.prepareTransport(t, this._server));
            this.tryRollbackTx(ret);
        }
        if (null != queryResList) {
            ret.setQueryResultList(new ObjectSubstituteFactory(this._cl).replaceObjectsWithSubstitutes(queryResList, this._infoDataByClassName));
        }
        return ret;
    }

    private QueryCreationResult createQuery(String hqlQuery) {
        ReflectionCaller rcQuery;
        JDBCTemporalEscapeParse jdbcTemporalEscapeParse = new JDBCTemporalEscapeParse(hqlQuery);
        QueryCreationResult queryCreationResult = new QueryCreationResult();
        if (jdbcTemporalEscapeParse.hasEscapes()) {
            rcQuery = this.getRcHibernateSession().callMethod("createQuery", jdbcTemporalEscapeParse.getHql());
            TreeMap<String, Date> datesByParamName = jdbcTemporalEscapeParse.getDatesByParamName();
            for (String paramName : datesByParamName.keySet()) {
                RCParam param = new RCParam();
                param.add(paramName, String.class);
                param.add(datesByParamName.get(paramName), Object.class);
                rcQuery.callMethod("setParameter", param);
            }
            queryCreationResult.setMessagePanelInfoText("Temporal values were parameterized:\n" + jdbcTemporalEscapeParse.getMessagePanelInfoText());
        } else {
            rcQuery = this.getRcHibernateSession().callMethod("createQuery", hqlQuery);
        }
        queryCreationResult.setRcQuery(rcQuery);
        return queryCreationResult;
    }

    private void tryRollbackTx(HqlQueryResult ret) {
        try {
            this.getRcHibernateSession().callMethod("getTransaction").callMethod("rollback");
        }
        catch (Throwable t) {
            ret.putSessionAdminException("Exception occurced during call of Session.getTransaction().rollback()", HibernateServerExceptionUtil.prepareTransport(t, this._server));
        }
    }

    private boolean isDataUpdate(String hqlQuery) {
        return null != hqlQuery && (hqlQuery.trim().toLowerCase().startsWith("insert") || hqlQuery.trim().toLowerCase().startsWith("update") || hqlQuery.trim().toLowerCase().startsWith("delete"));
    }

    private ReflectionCaller getRcHibernateSession() {
        try {
            if (null == this._rcHibernateSession) {
                if (null == this._driverClassName) {
                    this._rcHibernateSession = new ReflectionCaller(this._sessionFactoryImpl.getSessionFactory()).callMethod("openSession");
                } else {
                    ReflectionCaller driver = new ReflectionCaller().getClass(this._driverClassName, this._cl).newInstance();
                    Properties props = new Properties();
                    props.put("user", this._user);
                    props.put("password", this._password);
                    ReflectionCaller con = driver.callMethod("connect", this._url, props);
                    RCParam rcParam = new RCParam();
                    rcParam.add(con.getCallee(), Connection.class);
                    ReflectionCaller sessionBuilderRc = new ReflectionCaller(this._sessionFactoryImpl.getSessionFactory()).callMethod("withOptions");
                    this._rcHibernateSession = sessionBuilderRc.callMethod("connection", rcParam).callMethod("openSession");
                }
            }
            return this._rcHibernateSession;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

