/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.configuration;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePrefsListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.ClassPathItemListModel;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.HibernateConfigPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.JpaConnectionConfigCtrl;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.ProcessDetails;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.ProcessDetailsController;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ClassPathItem;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HibernateUtil;

public class HibernateConfigController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HibernateConfigController.class);
    private HibernatePlugin _plugin;
    private HibernateConfigPanel _panel;
    static final String PERF_KEY_LAST_DIR = "Squirrel.Hibernate.lastDir";
    public static final String HIBERNATE_CONFIGS_XML_FILE_OLD = "hibernateConfigs.xml";
    public static final String HIBERNATE_CONFIGS_XML_FILE = "hibernateConfigs32.xml";
    private HibernatePrefsListener _hibernatePrefsListener;
    private ProcessDetails _processDetails;
    private FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();
    private JpaConnectionConfigCtrl _jpaConnectionConfigCtrl;

    public HibernateConfigController(HibernatePlugin plugin) {
        this._plugin = plugin;
        this._processDetails = new ProcessDetails(this._plugin);
        this._panel = new HibernateConfigPanel(this._plugin.getResources());
        this._hibernatePrefsListener = this._plugin.removeHibernatePrefsListener();
        this._jpaConnectionConfigCtrl = new JpaConnectionConfigCtrl(this._panel._jpaConnectionConfigPanel, this._plugin);
        this._panel.btnNewConfig.addActionListener(e -> this.onNewConfig());
        this._panel.btnRemoveConfig.addActionListener(e -> this.onRemoveConfig());
        this._panel.btnClassPathAdd.addActionListener(e -> this.onAddClasspathEntry());
        this._panel.btnClassPathDirAdd.addActionListener(e -> this.onAddClassPathDir());
        this._panel.btnClassPathRemove.addActionListener(e -> this.onRemoveSelectedClasspathEntries());
        this._panel.btnClassPathMoveUp.addActionListener(e -> this.onMoveUpClasspathEntries());
        this._panel.btnClassPathMoveDown.addActionListener(e -> this.onMoveDownClasspathEntries());
        this._panel.btnApplyConfigChanges.addActionListener(e -> this.onApplyConfigChanges(false));
        this._panel.cboConfigs.addItemListener(e -> this.onSelectedConfigChanged(e));
        ItemListener radProcessListener = e -> this.onProcessChanged();
        this._panel.radCreateProcess.addItemListener(radProcessListener);
        this._panel.radInVM.addItemListener(radProcessListener);
        this._panel.btnProcessDetails.addActionListener(e -> this.onProcessDetails());
    }

    private void onProcessDetails() {
        new ProcessDetailsController(this._plugin, this._processDetails, this.getClassPathListModel().getClassPathArray());
    }

    private ClassPathItemListModel getClassPathListModel() {
        return (ClassPathItemListModel)this._panel.lstClassPath.getModel();
    }

    private void onProcessChanged() {
        this._panel.btnProcessDetails.setEnabled(this._panel.radCreateProcess.isSelected());
    }

    private void onRemoveConfig() {
        HibernateConfiguration selConfig = (HibernateConfiguration)this._panel.cboConfigs.getSelectedItem();
        if (null == selConfig) {
            JOptionPane.showMessageDialog((Component)this._plugin.getApplication().getMainFrame(), s_stringMgr.getString("HibernateController.NoConfigToRemove"));
        } else if (0 == JOptionPane.showConfirmDialog((Component)this._plugin.getApplication().getMainFrame(), s_stringMgr.getString("HibernateController.ReallyRemoveConfig", new Object[]{selConfig}))) {
            ((DefaultComboBoxModel)this._panel.cboConfigs.getModel()).removeElement(selConfig);
        }
    }

    private void onRemoveSelectedClasspathEntries() {
        int[] selIces = this._panel.lstClassPath.getSelectedIndices();
        ArrayList<ClassPathItem> toRemove = new ArrayList<ClassPathItem>();
        DefaultListModel listModel = (DefaultListModel)this._panel.lstClassPath.getModel();
        for (int i = 0; i < selIces.length; ++i) {
            toRemove.add((ClassPathItem)listModel.getElementAt(selIces[i]));
        }
        for (ClassPathItem ci : toRemove) {
            listModel.removeElement(ci);
        }
    }

    private void onSelectedConfigChanged(ItemEvent e) {
        if (1 == e.getStateChange() && null != e.getItem()) {
            this.initConfig((HibernateConfiguration)e.getItem());
        } else if (2 == e.getStateChange() && null != e.getItem()) {
            this.initConfig(null);
        }
    }

    private boolean onApplyConfigChanges(boolean silent) {
        if (!this._jpaConnectionConfigCtrl.checkValid(silent)) {
            return false;
        }
        String cfgName = this._panel.txtConfigName.getText();
        if (null == cfgName || 0 == cfgName.trim().length()) {
            if (!silent) {
                JOptionPane.showMessageDialog((Component)this._plugin.getApplication().getMainFrame(), s_stringMgr.getString("HibernateController.noProviderMsg"));
            }
            return false;
        }
        HibernateConfiguration cfg = (HibernateConfiguration)this._panel.cboConfigs.getSelectedItem();
        boolean wasNull = false;
        if (null == cfg) {
            wasNull = true;
            cfg = new HibernateConfiguration();
        }
        this._jpaConnectionConfigCtrl.saveConfiguration(cfg);
        cfg.setName(cfgName);
        ClassPathItem[] classPathEntries = new ClassPathItem[this.getClassPathListModel().getSize()];
        for (int i = 0; i < this.getClassPathListModel().getSize(); ++i) {
            classPathEntries[i] = this.getClassPathListModel().getClassPathItemAt(i);
        }
        cfg.setClassPathItems(classPathEntries);
        cfg.setUseProcess(this._panel.radCreateProcess.isSelected());
        this._processDetails.apply(cfg);
        if (wasNull) {
            this._panel.cboConfigs.addItem(cfg);
            this._panel.cboConfigs.setSelectedItem(cfg);
        }
        return true;
    }

    private void onAddClassPathDir() {
        String dirPath = Props.getString((String)PERF_KEY_LAST_DIR, (String)System.getProperty("user.home"));
        JFileChooser fc = new JFileChooser(dirPath);
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return s_stringMgr.getString("HibernateController.classpathDirEntryDesc");
            }
        });
        if (0 != fc.showOpenDialog((Component)this._plugin.getApplication().getMainFrame())) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        for (int i = 0; i < files.length; ++i) {
            this.getClassPathListModel().addJarDir(files[i].getPath());
        }
        if (0 < files.length) {
            Props.putString((String)PERF_KEY_LAST_DIR, (String)files[0].getPath());
        }
    }

    private void onAddClasspathEntry() {
        String dirPath = Props.getString((String)PERF_KEY_LAST_DIR, (String)System.getProperty("user.home"));
        JFileChooser fc = new JFileChooser(dirPath);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith(".ZIP") || f.getName().toUpperCase().endsWith(".JAR");
            }

            @Override
            public String getDescription() {
                return s_stringMgr.getString("HibernateController.classpathEntryDesc");
            }
        });
        if (0 != fc.showOpenDialog((Component)this._plugin.getApplication().getMainFrame())) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        for (int i = 0; i < files.length; ++i) {
            this.getClassPathListModel().addJar(files[i].getPath());
        }
        if (0 < files.length) {
            if (null == files[0].getParent()) {
                Props.putString((String)PERF_KEY_LAST_DIR, (String)files[0].getPath());
            } else {
                Props.putString((String)PERF_KEY_LAST_DIR, (String)files[0].getParent());
            }
        }
    }

    private void onMoveUpClasspathEntries() {
        int[] selIx = this._panel.lstClassPath.getSelectedIndices();
        if (null == selIx || 0 == selIx.length) {
            return;
        }
        for (int i : selIx) {
            if (0 != i) continue;
            return;
        }
        int[] newSelIx = new int[selIx.length];
        for (int i = 0; i < selIx.length; ++i) {
            ClassPathItem item = (ClassPathItem)this.getClassPathListModel().remove(selIx[i]);
            newSelIx[i] = selIx[i] - 1;
            this.getClassPathListModel().insertElementAt(item, newSelIx[i]);
        }
        this._panel.lstClassPath.setSelectedIndices(newSelIx);
        this._panel.lstClassPath.ensureIndexIsVisible(newSelIx[0]);
    }

    private void onMoveDownClasspathEntries() {
        int[] selIx = this._panel.lstClassPath.getSelectedIndices();
        if (null == selIx || 0 == selIx.length) {
            return;
        }
        for (int i : selIx) {
            if (this.getClassPathListModel().getSize() - 1 != i) continue;
            return;
        }
        int[] newSelIx = new int[selIx.length];
        for (int i = selIx.length - 1; i >= 0; --i) {
            ClassPathItem item = (ClassPathItem)this.getClassPathListModel().remove(selIx[i]);
            newSelIx[i] = selIx[i] + 1;
            this.getClassPathListModel().insertElementAt(item, newSelIx[i]);
        }
        this._panel.lstClassPath.setSelectedIndices(newSelIx);
        this._panel.lstClassPath.ensureIndexIsVisible(newSelIx[newSelIx.length - 1]);
    }

    private void onNewConfig() {
        this._panel.cboConfigs.setSelectedItem(null);
        this.initConfig(null);
    }

    private void initConfig(HibernateConfiguration cfg) {
        this._jpaConnectionConfigCtrl.init(cfg);
        if (null == cfg) {
            this._panel.txtConfigName.setText(null);
            this.getClassPathListModel().clear();
            this._panel.radCreateProcess.setSelected(true);
            this._panel.btnProcessDetails.setEnabled(true);
            return;
        }
        this._panel.txtConfigName.setText(cfg.getName());
        this.getClassPathListModel().clear();
        for (ClassPathItem path : cfg.getClassPathItems()) {
            this.getClassPathListModel().addItem(path);
        }
        this._panel.radCreateProcess.setSelected(cfg.isUseProcess());
        this._panel.btnProcessDetails.setEnabled(cfg.isUseProcess());
        this._panel.radInVM.setSelected(!cfg.isUseProcess());
        if (null != cfg.getCommand()) {
            this._processDetails.setCommand(cfg.getCommand());
            this._processDetails.setEndProcessOnDisconnect(cfg.isEndProcessOnDisconnect());
        }
    }

    public HibernateConfigPanel getPanel() {
        return this._panel;
    }

    public void applyChanges() {
        try {
            if (this.onApplyConfigChanges(true)) {
                FileWrapper pluginUserSettingsFolder = this._plugin.getPluginUserSettingsFolder();
                FileWrapper cfgsFile = this.fileWrapperFactory.create(pluginUserSettingsFolder, HIBERNATE_CONFIGS_XML_FILE);
                XMLBeanWriter bw = new XMLBeanWriter();
                ArrayList<HibernateConfiguration> buf = new ArrayList<HibernateConfiguration>();
                for (int i = 0; i < this._panel.cboConfigs.getItemCount(); ++i) {
                    HibernateConfiguration cfg = (HibernateConfiguration)this._panel.cboConfigs.getItemAt(i);
                    bw.addToRoot((Object)cfg);
                    buf.add(cfg);
                }
                bw.save(cfgsFile);
                if (null != this._hibernatePrefsListener) {
                    this._hibernatePrefsListener.configurationChanged(buf);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize() {
        try {
            XMLBeanReader reader = HibernateUtil.createHibernateConfigsReader(this._plugin);
            if (reader == null) {
                return;
            }
            HibernateConfiguration toSel = null;
            for (Object o : reader) {
                HibernateConfiguration cfg = (HibernateConfiguration)o;
                if (null != this._hibernatePrefsListener && null != this._hibernatePrefsListener.getPreselectedCfg() && cfg.getName().equals(this._hibernatePrefsListener.getPreselectedCfg().getName())) {
                    toSel = cfg;
                }
                if (null == cfg.getCommand()) {
                    this._processDetails.apply(cfg);
                }
                this._panel.cboConfigs.addItem(cfg);
            }
            if (null != toSel) {
                this._panel.cboConfigs.setSelectedItem(toSel);
            } else if (0 < this._panel.cboConfigs.getItemCount()) {
                this._panel.cboConfigs.setSelectedItem(this._panel.cboConfigs.getItemAt(0));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull((String)"setFileWrapperFactory", (Object[])new Object[]{"fileWrapperFactory", fileWrapperFactory});
        this.fileWrapperFactory = fileWrapperFactory;
    }
}

