/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.completion;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.AliasInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.MappingInfoProvider;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;

public class HqlAliasParser {
    private StringBuffer _token = new StringBuffer();

    public ArrayList<AliasInfo> parse(String hql, MappingInfoProvider mappingInfoProvider) {
        ArrayList<AliasInfo> ret = new ArrayList<AliasInfo>();
        int[] i = new int[1];
        MappedClassInfo lastMappedClass = null;
        while (i[0] < hql.length()) {
            String token = this.nextToken(i, hql);
            if ("as".equals(token)) continue;
            if (mappingInfoProvider.mayBeClassOrAliasName(token)) {
                if (null != lastMappedClass) {
                    ret.add(new AliasInfo(lastMappedClass, token));
                    lastMappedClass = null;
                    continue;
                }
                lastMappedClass = mappingInfoProvider.getMappedClassInfoFor(token);
                continue;
            }
            lastMappedClass = null;
        }
        return ret;
    }

    private String nextToken(int[] i, String hql) {
        this._token.setLength(0);
        for (int j = i[0]; j < hql.length(); ++j) {
            char c = hql.charAt(j);
            if (Character.isWhitespace(c)) {
                if (0 == this._token.length()) continue;
                i[0] = j + 1;
                return this._token.toString();
            }
            if (this.isSepartor(c)) {
                if (0 == this._token.length()) {
                    i[0] = j + 1;
                    return this._token.append(c).toString();
                }
                i[0] = j;
                return this._token.toString();
            }
            this._token.append(c);
        }
        i[0] = hql.length();
        return this._token.toString();
    }

    private boolean isSepartor(char c) {
        return ',' == c || '(' == c || ')' == c;
    }
}

