/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.plugins.graph.HideDockButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SortedColumn;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SortedColumnsOrderPanel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SortedColumnsTableModel;

public class SortedColumnsPanelCtrl {
    private SortedColumnsOrderPanel _panel;

    public SortedColumnsPanelCtrl(HideDockButtonHandler hideDockButtonHandler, SortedColumnsTableModel sortedColumnsTableModel, String labelText) {
        this._panel = new SortedColumnsOrderPanel(hideDockButtonHandler, labelText);
        SortedColumnsTableModel tableModel = sortedColumnsTableModel;
        this._panel.tblOrder.setModel(tableModel);
        this._panel.tblOrder.setColumnModel(tableModel.getColumnModel());
        this._panel.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortedColumnsPanelCtrl.this.onMoveUp();
            }
        });
        this._panel.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortedColumnsPanelCtrl.this.onMoveDown();
            }
        });
    }

    public JPanel getSortedColumnsPanel() {
        return this._panel;
    }

    public SortedColumn[] syncSortedColumns(Class<? extends SortedColumn> clazz, ArrayList<SortedColumn> sortedCols) {
        SortedColumnsTableModel tableModel = (SortedColumnsTableModel)this._panel.tblOrder.getModel();
        tableModel.updateOrderCols(sortedCols);
        return tableModel.getSortedCols(clazz);
    }

    private void onMoveUp() {
        int[] selRows = this._panel.tblOrder.getSelectedRows();
        if (null == selRows || 0 == selRows.length) {
            return;
        }
        SortedColumnsTableModel model = (SortedColumnsTableModel)this._panel.tblOrder.getModel();
        int[] newSelRows = model.moveUp(selRows);
        DefaultListSelectionModel selectionModel = (DefaultListSelectionModel)this._panel.tblOrder.getSelectionModel();
        selectionModel.clearSelection();
        for (int newSelRow : newSelRows) {
            selectionModel.addSelectionInterval(newSelRow, newSelRow);
        }
        this._panel.tblOrder.scrollRectToVisible(this._panel.tblOrder.getCellRect(newSelRows[0], 0, false));
    }

    private void onMoveDown() {
        int[] selRows = this._panel.tblOrder.getSelectedRows();
        if (null == selRows || 0 == selRows.length) {
            return;
        }
        SortedColumnsTableModel model = (SortedColumnsTableModel)this._panel.tblOrder.getModel();
        int[] newSelRows = model.moveDown(selRows);
        DefaultListSelectionModel selectionModel = (DefaultListSelectionModel)this._panel.tblOrder.getSelectionModel();
        selectionModel.clearSelection();
        for (int newSelRow : newSelRows) {
            selectionModel.addSelectionInterval(newSelRow, newSelRow);
        }
        this._panel.tblOrder.scrollRectToVisible(this._panel.tblOrder.getCellRect(newSelRows[newSelRows.length - 1], 0, false));
    }

    public SortedColumn[] getSortedColumns(Class<? extends SortedColumn> clazz) {
        SortedColumnsTableModel tableModel = (SortedColumnsTableModel)this._panel.tblOrder.getModel();
        return tableModel.getSortedCols(clazz);
    }
}

