/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Point;
import net.sourceforge.squirrel_sql.plugins.graph.Zoomer;

public class FoldingPoint {
    private Point _unzoomedPoint;
    private Zoomer _zoomer;
    private Point _zoomedPointBuffer = new Point();

    public FoldingPoint(Point unZoomedPoint, Zoomer zoomer) {
        this._unzoomedPoint = unZoomedPoint;
        if (this._unzoomedPoint.x < 0) {
            this._unzoomedPoint.x = 0;
        }
        if (this._unzoomedPoint.y < 0) {
            this._unzoomedPoint.y = 0;
        }
        this._zoomer = zoomer;
    }

    public FoldingPoint(FoldingPoint fp) {
        this._unzoomedPoint = fp._unzoomedPoint;
        this._zoomer = fp._zoomer;
    }

    Point getZoomedPoint() {
        if (this._zoomer.isEnabled()) {
            double zoom = this._zoomer.getZoom();
            this._zoomedPointBuffer.x = (int)((double)this._unzoomedPoint.x * zoom + 0.5);
            this._zoomedPointBuffer.y = (int)((double)this._unzoomedPoint.y * zoom + 0.5);
        } else {
            this._zoomedPointBuffer.x = this._unzoomedPoint.x;
            this._zoomedPointBuffer.y = this._unzoomedPoint.y;
        }
        return this._zoomedPointBuffer;
    }

    public boolean equals(Object obj) {
        FoldingPoint other = (FoldingPoint)obj;
        return this._unzoomedPoint.equals(other._unzoomedPoint);
    }

    public int hashCode() {
        return this._unzoomedPoint.hashCode();
    }

    public Point getUnZoomedPoint() {
        return this._unzoomedPoint;
    }

    public void moveBy(Point delta) {
        double zoom = this._zoomer.getZoom();
        this._unzoomedPoint.x += (int)((double)delta.x / zoom + (double)Math.signum(delta.x) * 0.5);
        this._unzoomedPoint.y += (int)((double)delta.y / zoom + (double)Math.signum(delta.y) * 0.5);
    }
}

