/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.VolatileNullableLazyValue;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiVariableEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsClassImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsMemberImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsParsingUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.ui.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class ClsFieldImpl
extends ClsMemberImpl<PsiFieldStub>
implements PsiField,
PsiVariableEx,
ClsModifierListOwner {
    private final NotNullLazyValue<PsiTypeElement> myTypeElement;
    private final NullableLazyValue<PsiExpression> myInitializer;

    public ClsFieldImpl(@NotNull PsiFieldStub stub) {
        if (stub == null) {
            ClsFieldImpl.$$$reportNull$$$0(0);
        }
        super(stub);
        this.myTypeElement = new AtomicNotNullLazyValue<PsiTypeElement>(){

            @Override
            @NotNull
            protected PsiTypeElement compute() {
                PsiFieldStub stub = (PsiFieldStub)ClsFieldImpl.this.getStub();
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                ClsTypeElementImpl clsTypeElementImpl = new ClsTypeElementImpl(ClsFieldImpl.this, typeText, '\u0000');
                if (clsTypeElementImpl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return clsTypeElementImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFieldImpl$1", "compute"));
            }
        };
        this.myInitializer = new VolatileNullableLazyValue<PsiExpression>(){

            @Override
            @Nullable
            protected PsiExpression compute() {
                String initializerText = ((PsiFieldStub)ClsFieldImpl.this.getStub()).getInitializerText();
                return initializerText != null && !Comparing.equal(";INITIALIZER_TOO_LONG;", initializerText) ? ClsParsingUtil.createExpressionFromText(initializerText, ClsFieldImpl.this.getManager(), ClsFieldImpl.this) : null;
            }
        };
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildren(this.getDocComment(), this.getModifierList(), this.getTypeElement(), this.getNameIdentifier());
        if (psiElementArray == null) {
            ClsFieldImpl.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = ObjectUtils.assertNotNull(this.getTypeElement()).getType();
        if (psiType == null) {
            ClsFieldImpl.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        return this.myTypeElement.getValue();
    }

    @Override
    public PsiModifierList getModifierList() {
        return (PsiModifierList)ObjectUtils.assertNotNull(((PsiFieldStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST)).getPsi();
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            ClsFieldImpl.$$$reportNull$$$0(3);
        }
        return ObjectUtils.assertNotNull(this.getModifierList()).hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return this.myInitializer.getValue();
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue((Set<PsiVariable>)new THashSet());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null) {
            String qName = containingClass.getQualifiedName();
            if ("java.lang.Float".equals(qName)) {
                String name = this.getName();
                if ("POSITIVE_INFINITY".equals(name)) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                if ("NEGATIVE_INFINITY".equals(name)) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                if ("NaN".equals(name)) {
                    return Float.valueOf(Float.NaN);
                }
            } else if ("java.lang.Double".equals(qName)) {
                String name = this.getName();
                if ("POSITIVE_INFINITY".equals(name)) {
                    return Double.POSITIVE_INFINITY;
                }
                if ("NEGATIVE_INFINITY".equals(name)) {
                    return Double.NEGATIVE_INFINITY;
                }
                if ("NaN".equals(name)) {
                    return Double.NaN;
                }
            }
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiFieldStub)this.getStub()).isDeprecated() || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsFieldImpl.$$$reportNull$$$0(4);
        }
        ClsFieldImpl.appendText(this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsFieldImpl.appendText(this.getModifierList(), indentLevel, buffer, "");
        ClsFieldImpl.appendText(this.getTypeElement(), indentLevel, buffer, " ");
        ClsFieldImpl.appendText(this.getNameIdentifier(), indentLevel, buffer);
        PsiExpression initializer = this.getInitializer();
        if (initializer != null) {
            buffer.append(" = ");
            buffer.append(initializer.getText());
        }
        buffer.append(';');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsFieldImpl.$$$reportNull$$$0(5);
        }
        this.setMirrorCheckingType(element, null);
        PsiField mirror = (PsiField)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsFieldImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsFieldImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsFieldImpl.setMirror(this.getTypeElement(), mirror.getTypeElement());
        ClsFieldImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsFieldImpl.$$$reportNull$$$0(6);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitField(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        block8: {
            PsiElement psiElement;
            for (ClsCustomNavigationPolicy navigationPolicy : ClsCustomNavigationPolicy.EP_NAME.getExtensionList()) {
                PsiElement psiElement2;
                try {
                    PsiElement navigationElement = navigationPolicy.getNavigationElement(this);
                    if (navigationElement == null) continue;
                    psiElement2 = navigationElement;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    continue;
                }
                if (psiElement2 == null) {
                    ClsFieldImpl.$$$reportNull$$$0(7);
                }
                return psiElement2;
            }
            try {
                PsiField field;
                PsiClass mirrorClass = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
                if (mirrorClass == null || (field = mirrorClass.findFieldByName(this.getName(), false)) == null) break block8;
                psiElement = field.getNavigationElement();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (psiElement == null) {
                ClsFieldImpl.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        ClsFieldImpl clsFieldImpl = this;
        if (clsFieldImpl == null) {
            ClsFieldImpl.$$$reportNull$$$0(9);
        }
        return clsFieldImpl;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            ClsFieldImpl.$$$reportNull$$$0(10);
        }
        return searchScope;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFieldImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFieldImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

