/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by Together */

package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;

/**
 * The <CODE>PlateFieldLocation</CODE> class contains specific location information
 * within the Plate field of a CodeUnitLocation object.
 */
public class PlateFieldLocation extends CommentFieldLocation {

	/**
	 * The row index into the comment.
	 */
	private int commentRow;

	/**
	 * Construct a new PlateFieldLocation.
	 * 
	 * @param program the program of the location
	 * @param addr the address of the code unit.
	 * @param componentPath the componentPath of the codeUnit
	 * @param row the line of the location
	 * @param charOffset the character position on the row of the location.
	 * @param comment plate comment text
	 * @param commentRow The row index into the comments of this location.  This is different 
	 *        than the <code>row</code> due to the fact that the PlateField has fictitious borders
	 *        that don't exist in the actual comment.
	 */
	public PlateFieldLocation(Program program, Address addr, int[] componentPath, int row,
			int charOffset, String[] comment, int commentRow) {

		super(program, addr, componentPath, comment, CodeUnit.PLATE_COMMENT, row, charOffset);
		this.commentRow = commentRow;
	}

	/**
	 * Default constructor needed for restoring
	 * a plate field location from XML.
	 */
	public PlateFieldLocation() {
	}

	@Override
	public String toString() {
		return super.toString() + ", Comment Row = " + commentRow;
	}

	@Override
	public boolean equals(Object obj) {
		if (super.equals(obj)) {
			PlateFieldLocation loc = (PlateFieldLocation) obj;
			return (commentRow == loc.commentRow);
		}
		return false;
	}

	/**
	 * Returns the index into the String[] returned by {@link #getComment()} that represents
	 * the comment row that was clicked.  <code>-1</code> will be returned if the border of the 
	 * plate field was clicked. 
	 * <p>
	 * <b>Note: </b> This value is different than that returned by {@link #getRow()}, as that
	 *         value represents the screen row clicked.  Further, the PlateField adds screen
	 *         decoration to the comments, which causes the screen row to differ from the comment
	 *         row.
	 * @return the index into the String[] returned by {@link #getComment()} that represents
	 * the comment row that was clicked.  <code>-1</code> will be returned if the border of the 
	 * plate field was clicked.
	 */
	public int getCommentRow() {
		return commentRow;
	}

	@Override
	public void restoreState(Program p, SaveState obj) {
		super.restoreState(p, obj);
		commentRow = obj.getInt("_COMMENT_ROW", 0);
	}

	@Override
	public void saveState(SaveState obj) {
		super.saveState(obj);
		obj.putInt("_COMMENT_ROW", commentRow);
	}

}
