/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;

public class TraceChangeRecord<T, U>
extends DomainObjectChangeRecord {
    private static final long serialVersionUID = 1L;
    private final TraceChangeType<T, U> type;
    private final TraceAddressSpace space;
    private final T affectedObject;
    private final boolean oldKnown;

    public TraceChangeRecord(TraceChangeType<T, U> type, TraceAddressSpace space, T affectedObject, U oldValue, U newValue) {
        super(type.getType(), type.getSubType(), oldValue, newValue);
        this.type = type;
        this.space = space;
        this.affectedObject = affectedObject;
        this.oldKnown = true;
    }

    public TraceChangeRecord(TraceChangeType<T, U> type, TraceAddressSpace space, T affectedObject, U newValue) {
        super(type.getType(), type.getSubType(), null, newValue);
        this.type = type;
        this.space = space;
        this.affectedObject = affectedObject;
        this.oldKnown = false;
    }

    public TraceChangeRecord(TraceChangeType<T, U> type, TraceAddressSpace space, T affectedObject) {
        super(type.getType(), type.getSubType(), null, null);
        this.type = type;
        this.space = space;
        this.affectedObject = affectedObject;
        this.oldKnown = false;
    }

    public TraceChangeRecord(TraceChangeType<T, U> type, TraceAddressSpace space) {
        super(type.getType(), type.getSubType(), null, null);
        this.type = type;
        this.space = space;
        this.affectedObject = null;
        this.oldKnown = false;
    }

    public TraceChangeType<T, U> getType() {
        return this.type;
    }

    public TraceAddressSpace getSpace() {
        return this.space;
    }

    public T getAffectedObject() {
        return this.affectedObject;
    }

    public boolean isOldKnown() {
        return this.oldKnown;
    }

    public U getOldValue() {
        return (U)super.getOldValue();
    }

    public U getNewValue() {
        return (U)super.getNewValue();
    }
}

