/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.projectdata.column;

import ghidra.docking.settings.Settings;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.ProjectDataColumn;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.ServiceProvider;

public class AddressSizeProjectDataColumn
extends ProjectDataColumn<Integer> {
    public String getColumnName() {
        return "Address Size";
    }

    public Integer getValue(DomainFileInfo info, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
        String sizeString = info.getMetaDataValue("Address Size");
        if (sizeString == null) {
            return null;
        }
        try {
            return Integer.parseInt(sizeString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getColumnPreferredWidth() {
        return 60;
    }

    public boolean isDefaultColumn() {
        return true;
    }

    public int getPriority() {
        return 3;
    }
}

