/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.function.FunctionDB;
import ghidra.program.model.listing.Function;
import ghidra.program.util.FunctionTagFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FunctionTagFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Function Tags";
    public static final Color DEFAULT_COLOR = new Color(130, 0, 75);
    private Color literalColor;

    public FunctionTagFieldFactory() {
        super(FIELD_NAME);
    }

    private FunctionTagFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.color = displayOptions.getColor(OptionsGui.FUN_TAG.getColorOptionName(), OptionsGui.FUN_TAG.getDefaultColor());
        this.literalColor = displayOptions.getColor(OptionsGui.SEPARATOR.getColorOptionName(), OptionsGui.SEPARATOR.getDefaultColor());
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        if (!this.enabled) {
            return null;
        }
        Object obj = proxy.getObject();
        if (!(obj instanceof FunctionDB)) {
            return null;
        }
        FunctionDB function = (FunctionDB)obj;
        List<FieldElement> textElements = this.createFunctionTagElements(function);
        if (textElements == null) {
            return null;
        }
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)new CompositeFieldElement(textElements), this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            Function function = functionProxy.getObject();
            return new FunctionTagFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), function.getCallFixup(), col);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField listingField, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (programLoc instanceof FunctionTagFieldLocation) {
            FunctionTagFieldLocation fieldLocation = (FunctionTagFieldLocation)programLoc;
            return new FieldLocation(index, fieldNum, 0, fieldLocation.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return category == 2;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new FunctionTagFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(OptionsGui.FUN_TAG.getColorOptionName())) {
            this.color = (Color)newValue;
        } else if (optionName.equals(OptionsGui.SEPARATOR.getColorOptionName())) {
            this.literalColor = (Color)newValue;
        }
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
    }

    protected List<FieldElement> createFunctionTagElements(FunctionDB function) {
        Collection<String> tagNames = this.getTags(function);
        if (tagNames == null || tagNames.isEmpty()) {
            return null;
        }
        ArrayList<FieldElement> textElements = new ArrayList<FieldElement>();
        int elementIndex = 0;
        AttributedString as = new AttributedString("Tags: ", this.literalColor, this.getMetrics());
        textElements.add((FieldElement)new TextFieldElement(as, elementIndex++, 0));
        String tagNamesStr = StringUtils.join(tagNames, (String)", ");
        as = new AttributedString(tagNamesStr, this.color, this.getMetrics());
        textElements.add((FieldElement)new TextFieldElement(as, elementIndex++, 0));
        return textElements;
    }

    private Collection<String> getTags(FunctionDB function) {
        if (function == null) {
            return Collections.emptyList();
        }
        Set tags = function.getTags();
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        return tags.stream().sorted().map(t -> t.getName()).collect(Collectors.toList());
    }
}

