/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.task;

import docking.widgets.OptionDialog;
import ghidra.app.util.dialog.CheckoutDialog;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.remote.User;
import ghidra.framework.store.ExclusiveCheckoutException;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OpenProgramTask
extends Task {
    private final List<DomainFileInfo> domainFileInfoList = new ArrayList<DomainFileInfo>();
    private List<Program> programList = new ArrayList<Program>();
    private final Object consumer;
    private boolean silent;
    private boolean noCheckout;
    private String openPromptText = "Open";

    public OpenProgramTask(DomainFile domainFile, int version, boolean forceReadOnly, Object consumer) {
        super("Open Program(s)", true, false, true);
        this.consumer = consumer;
        this.domainFileInfoList.add(new DomainFileInfo(domainFile, version, forceReadOnly));
    }

    public OpenProgramTask(DomainFile domainFile, int version, Object consumer) {
        this(domainFile, version, false, consumer);
    }

    public OpenProgramTask(DomainFile domainFile, boolean forceReadOnly, Object consumer) {
        this(domainFile, -1, forceReadOnly, consumer);
    }

    public OpenProgramTask(DomainFile domainFile, Object consumer) {
        this(domainFile, -1, false, consumer);
    }

    public OpenProgramTask(List<DomainFile> domainFileList, boolean forceReadOnly, Object consumer) {
        super("Open Program(s)", true, domainFileList.size() > 1, true);
        this.consumer = consumer;
        for (DomainFile domainFile : domainFileList) {
            this.domainFileInfoList.add(new DomainFileInfo(domainFile, -1, forceReadOnly));
        }
    }

    public OpenProgramTask(List<DomainFile> domainFileList, Object consumer) {
        this(domainFileList, false, consumer);
    }

    public void setOpenPromptText(String text) {
        this.openPromptText = text;
    }

    public void addProgramToOpen(DomainFile domainFile, int version) {
        this.addProgramToOpen(domainFile, version, false);
    }

    public void addProgramToOpen(DomainFile domainFile, int version, boolean forceReadOnly) {
        this.setHasProgress(true);
        this.domainFileInfoList.add(new DomainFileInfo(domainFile, version, forceReadOnly));
    }

    public void setSilent() {
        this.silent = true;
    }

    public void setNoCheckout() {
        this.noCheckout = true;
    }

    public List<Program> getOpenPrograms() {
        return this.programList;
    }

    public Program getOpenProgram() {
        if (this.programList.isEmpty()) {
            return null;
        }
        return this.programList.get(0);
    }

    public void run(TaskMonitor monitor) {
        this.taskMonitor.initialize((long)this.domainFileInfoList.size());
        for (DomainFileInfo domainFileInfo : this.domainFileInfoList) {
            if (this.taskMonitor.isCancelled()) {
                return;
            }
            this.openDomainFile(domainFileInfo);
            this.taskMonitor.incrementProgress(1L);
        }
    }

    private void openDomainFile(DomainFileInfo domainFileInfo) {
        int version = domainFileInfo.getVersion();
        DomainFile domainFile = domainFileInfo.getDomainFile();
        if (version != -1) {
            this.openVersionedFile(domainFile, version);
        } else if (domainFileInfo.isReadOnly()) {
            this.openReadOnlyFile(domainFile, version);
        } else {
            this.openUnversionedFile(domainFile);
        }
    }

    private void openReadOnlyFile(DomainFile domainFile, int version) {
        this.taskMonitor.setMessage("Opening " + domainFile.getName());
        this.openReadOnly(domainFile, version);
    }

    private void openVersionedFile(DomainFile domainFile, int version) {
        this.taskMonitor.setMessage("Getting Version " + version + " for " + domainFile.getName());
        this.openReadOnly(domainFile, version);
    }

    private void openReadOnly(DomainFile domainFile, int version) {
        String contentType = null;
        try {
            contentType = domainFile.getContentType();
            Program program = (Program)domainFile.getReadOnlyDomainObject(this.consumer, version, this.taskMonitor);
            if (program == null) {
                String errorMessage = "Can't open program - \"" + domainFile.getPathname() + "\"";
                if (version != -1) {
                    errorMessage = errorMessage + " version " + version;
                }
                Msg.showError((Object)((Object)this), null, (String)"DomainFile Not Found", (Object)errorMessage);
            } else {
                this.programList.add(program);
            }
        }
        catch (CancelledException program) {
        }
        catch (IOException e) {
            if (domainFile.isInWritableProject()) {
                ClientUtil.handleException((RepositoryAdapter)AppInfo.getActiveProject().getRepository(), (Exception)e, (String)"Get Versioned Object", null);
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Error Getting Versioned Object", (Object)("Could not get version " + version + " for " + domainFile.getName()), (Throwable)e);
            }
        }
        catch (VersionException e) {
            VersionExceptionHandler.showVersionError(null, (String)domainFile.getName(), (String)contentType, (String)"Open", (VersionException)e);
        }
    }

    private void openUnversionedFile(DomainFile domainFile) {
        String filename = domainFile.getName();
        this.taskMonitor.setMessage("Opening " + filename);
        this.performOptionalCheckout(domainFile);
        try {
            this.openFileMaybeUgrade(domainFile);
        }
        catch (VersionException e) {
            String contentType = domainFile.getContentType();
            VersionExceptionHandler.showVersionError(null, (String)filename, (String)contentType, (String)"Open", (VersionException)e);
        }
        catch (CancelledException e) {
        }
        catch (LanguageNotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)("Error Opening " + filename), (Object)(e.getMessage() + "\nPlease contact the Ghidra team for assistance."));
        }
        catch (Exception e) {
            if (domainFile.isInWritableProject() && e instanceof IOException) {
                RepositoryAdapter repo = domainFile.getParent().getProjectData().getRepository();
                ClientUtil.handleException((RepositoryAdapter)repo, (Exception)e, (String)"Open File", null);
            }
            Msg.showError((Object)((Object)this), null, (String)("Error Opening " + filename), (Object)("Getting domain object failed.\n" + e.getMessage()), (Throwable)e);
        }
    }

    private void openFileMaybeUgrade(DomainFile domainFile) throws IOException, CancelledException, VersionException {
        block4: {
            boolean recoverFile = false;
            if (!this.silent && domainFile.isInWritableProject() && domainFile.canRecover()) {
                recoverFile = this.askRecoverFile(domainFile.getName());
            }
            try {
                Program program = (Program)domainFile.getDomainObject(this.consumer, false, recoverFile, this.taskMonitor);
                if (program != null) {
                    this.programList.add(program);
                }
            }
            catch (VersionException e) {
                Program program;
                if (!VersionExceptionHandler.isUpgradeOK(null, (DomainFile)domainFile, (String)this.openPromptText, (VersionException)e) || (program = (Program)domainFile.getDomainObject(this.consumer, true, recoverFile, this.taskMonitor)) == null) break block4;
                this.programList.add(program);
            }
        }
    }

    private boolean askRecoverFile(String filename) {
        int option = OptionDialog.showYesNoDialog(null, (String)"Crash Recovery Data Found", (String)("<html>" + HTMLUtilities.escapeHTML((String)filename) + " has crash data.<br>Would you like to recover unsaved changes?"));
        return option == 1;
    }

    private void performOptionalCheckout(DomainFile domainFile) {
        if (this.silent || this.noCheckout || !domainFile.canCheckout()) {
            return;
        }
        User user = domainFile.getParent().getProjectData().getUser();
        CheckoutDialog dialog = new CheckoutDialog(domainFile, user);
        if (dialog.showDialog() == 0) {
            try {
                this.taskMonitor.setMessage("Checking Out " + domainFile.getName());
                if (domainFile.checkout(dialog.exclusiveCheckout(), this.taskMonitor)) {
                    return;
                }
                Msg.showError((Object)((Object)this), null, (String)"Checkout Failed", (Object)("Exclusive checkout failed for: " + domainFile.getName() + "\nOne or more users have file checked out!"));
            }
            catch (CancelledException cancelledException) {
            }
            catch (ExclusiveCheckoutException e) {
                Msg.showError((Object)((Object)this), null, (String)"Checkout Failed", (Object)e.getMessage());
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Error on Check Out", (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    static class DomainFileInfo {
        private final DomainFile domainFile;
        private final int version;
        private boolean forceReadOnly;

        public DomainFileInfo(DomainFile domainFile, int version, boolean forceReadOnly) {
            this.domainFile = domainFile;
            this.version = domainFile.isReadOnly() && domainFile.isVersioned() ? domainFile.getVersion() : version;
            this.forceReadOnly = forceReadOnly;
        }

        public boolean isReadOnly() {
            return this.forceReadOnly || this.domainFile.isReadOnly() || this.version != -1;
        }

        public DomainFile getDomainFile() {
            return this.domainFile;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

